/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.tools.idea.refactoring.modularize.AndroidModularizeProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.CollectionComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "project", "Lcom/intellij/openapi/project/Project;", "targetModules", "", "Lcom/intellij/openapi/module/Module;", "processor", "Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor;)V", "myModuleCombo", "Lcom/intellij/openapi/ui/ComboBox;", "createCenterPanel", "Ljavax/swing/JComponent;", "doAction", "", "intellij.android.core"})
public final class AndroidModularizeDialog
extends RefactoringDialog {
    @NotNull
    private final List<Module> targetModules;
    @NotNull
    private final AndroidModularizeProcessor processor;
    private ComboBox<Module> myModuleCombo;

    public AndroidModularizeDialog(@NotNull Project project, @NotNull List<? extends Module> targetModules, @NotNull AndroidModularizeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetModules, (String)"targetModules");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        super(project, true);
        this.targetModules = targetModules;
        this.processor = processor;
        this.setTitle("Modularize");
        this.init();
    }

    protected void doAction() {
        ComboBox<Module> comboBox2 = this.myModuleCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myModuleCombo");
            comboBox2 = null;
        }
        Object object = comboBox2.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.module.Module");
        this.processor.setTargetModule((Module)object);
        this.processor.setPreviewUsages(this.isPreviewUsages());
        this.close(0);
        this.processor.run();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        Locale locale = Locale.US;
        String string = "Move %1$d classes, " + (this.processor.getKtTopLevelDeclarationsCount() != 0 ? "%2$d top-level declarations, " : "") + "and %3$d resources to:";
        Object[] objectArray = new Object[]{this.processor.getClassesCount(), this.processor.getKtTopLevelDeclarationsCount(), this.processor.getResourcesCount()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        panel2.add((Component)new JLabel(string2), "North");
        ComboBoxModel model2 = (ComboBoxModel)new CollectionComboBoxModel(this.targetModules);
        this.myModuleCombo = new ComboBox(model2);
        ComboBox<Module> comboBox2 = this.myModuleCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myModuleCombo");
            comboBox2 = null;
        }
        panel2.add((Component)comboBox2, "Center");
        return panel2;
    }
}

