/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle.sync;

import com.android.tools.idea.projectsystem.gradle.sync.PerformanceMeasurementUtilKt;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0086\u0002\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\"J\"\u0010#\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0082\b\u00a2\u0006\u0002\u0010 J\b\u0010$\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\f\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/sync/Counter;", "", "name", "", "(Ljava/lang/String;)V", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "maxCpu", "Ljava/util/concurrent/atomic/AtomicLong;", "maxCpuNanos", "", "getMaxCpuNanos", "()J", "maxWall", "maxWallNanos", "getMaxWallNanos", "getName", "()Ljava/lang/String;", "totalCount", "", "getTotalCount", "()I", "totalCpu", "totalCpuNanos", "getTotalCpuNanos", "totalWall", "totalWallNanos", "getTotalWallNanos", "invoke", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "reset", "", "time", "toString", "intellij.android.projectSystem.gradle.sync"})
public final class Counter {
    @NotNull
    private final String name;
    @NotNull
    private final AtomicLong totalCpu;
    @NotNull
    private final AtomicLong totalWall;
    @NotNull
    private final AtomicLong maxCpu;
    @NotNull
    private final AtomicLong maxWall;
    @NotNull
    private final AtomicInteger count;

    public Counter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.totalCpu = new AtomicLong();
        this.totalWall = new AtomicLong();
        this.maxCpu = new AtomicLong();
        this.maxWall = new AtomicLong();
        this.count = new AtomicInteger();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getTotalCpuNanos() {
        return this.totalCpu.get();
    }

    public final long getMaxCpuNanos() {
        return this.maxCpu.get();
    }

    public final long getTotalWallNanos() {
        return this.totalWall.get();
    }

    public final long getMaxWallNanos() {
        return this.maxWall.get();
    }

    public final int getTotalCount() {
        return this.count.get();
    }

    public final void reset() {
        this.totalCpu.set(0L);
        this.maxCpu.set(0L);
        this.totalWall.set(0L);
        this.maxWall.set(0L);
        this.count.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R time(Function0<? extends R> block) {
        Object object;
        boolean $i$f$time = false;
        long startWall = PerformanceMeasurementUtilKt.access$getCurrentTimeNano();
        long startCpu = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime();
        try {
            object = block.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            long deltaWall = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall;
            long deltaCpu = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu;
            this.totalCpu.addAndGet(deltaCpu);
            this.maxCpu.updateAndGet(new LongUnaryOperator(deltaCpu){
                final /* synthetic */ long $deltaCpu;
                {
                    this.$deltaCpu = $deltaCpu;
                }

                public final long applyAsLong(long it) {
                    return Long.max(it, this.$deltaCpu);
                }
            });
            this.totalWall.addAndGet(deltaWall);
            this.maxWall.updateAndGet(new LongUnaryOperator(deltaWall){
                final /* synthetic */ long $deltaWall;
                {
                    this.$deltaWall = $deltaWall;
                }

                public final long applyAsLong(long it) {
                    return Long.max(it, this.$deltaWall);
                }
            });
            this.count.incrementAndGet();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        long deltaWall = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall;
        long deltaCpu = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu;
        this.totalCpu.addAndGet(deltaCpu);
        this.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this.totalWall.addAndGet(deltaWall);
        this.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this.count.incrementAndGet();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int totalCount = this.count.get();
        if (totalCount > 0) {
            double avgCpuMicros = (double)(this.getTotalCpuNanos() / (long)totalCount / (long)100) / 10.0;
            double maxCpuMicros = (double)(this.getMaxCpuNanos() / (long)100) / 10.0;
            double totalCpuMillis = (double)(this.getTotalCpuNanos() / (long)100000) / 10.0;
            double avgWallMicros = (double)(this.getTotalWallNanos() / (long)totalCount / (long)100) / 10.0;
            double maxWallMicros = (double)(this.getMaxWallNanos() / (long)100) / 10.0;
            double totalWallMillis = (double)(this.getTotalWallNanos() / (long)100000) / 10.0;
            Object[] objectArray = new String[]{"Counter:     ", this.name, " \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (String[])objectArray);
            objectArray = new Object[]{"    Count:     ", totalCount, " \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (Object[])objectArray);
            objectArray = new String[]{"    TotalCpu:  ", PerformanceMeasurementUtilKt.format(totalCpuMillis), "ms \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (String[])objectArray);
            objectArray = new String[]{"    TotalWall: ", PerformanceMeasurementUtilKt.format(totalWallMillis), "ms \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2d0.append('\n'), (String)"append('\\n')");
            objectArray = new String[]{"    AvgCpu:    ", PerformanceMeasurementUtilKt.format(avgCpuMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (String[])objectArray);
            objectArray = new String[]{"    MaxCpu:    ", PerformanceMeasurementUtilKt.format(maxCpuMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (String[])objectArray);
            objectArray = new String[]{"    AvgWall:   ", PerformanceMeasurementUtilKt.format(avgWallMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (String[])objectArray);
            objectArray = new String[]{"    MaxWall:   ", PerformanceMeasurementUtilKt.format(maxWallMicros), "\u03bcs \n"};
            StringsKt.append((StringBuilder)$this$toString_u24lambda_u2d0, (String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2d0.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R invoke(@NotNull Function0<? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Counter this_$iv = this;
        boolean $i$f$time = false;
        long startWall$iv = PerformanceMeasurementUtilKt.access$getCurrentTimeNano();
        long startCpu$iv = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime();
        try {
            object = block.invoke();
        }
        catch (Throwable throwable) {
            long deltaWall$iv = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall$iv;
            long deltaCpu$iv = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu$iv;
            this_$iv.totalCpu.addAndGet(deltaCpu$iv);
            this_$iv.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this_$iv.totalWall.addAndGet(deltaWall$iv);
            this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this_$iv.count.incrementAndGet();
            throw throwable;
        }
        long deltaWall$iv = PerformanceMeasurementUtilKt.access$getCurrentTimeNano() - startWall$iv;
        long deltaCpu$iv = PerformanceMeasurementUtilKt.access$getCurrentThreadCpuTime() - startCpu$iv;
        this_$iv.totalCpu.addAndGet(deltaCpu$iv);
        this_$iv.maxCpu.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.totalWall.addAndGet(deltaWall$iv);
        this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.count.incrementAndGet();
        return (R)object;
    }
}

