/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystemBuildManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\bJ\u001a\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystemBuildPublisher;", "Lcom/android/tools/idea/gradle/project/build/GradleBuildListener$Adapter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "PROJECT_SYSTEM_BUILD_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/android/tools/idea/projectsystem/ProjectSystemBuildManager$BuildListener;", "kotlin.jvm.PlatformType", "buildCount", "", "isBuilding", "", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "addBuildListener", "", "parentDisposable", "buildListener", "buildFinished", "status", "Lcom/android/tools/idea/gradle/project/build/BuildStatus;", "context", "Lcom/android/tools/idea/gradle/project/build/BuildContext;", "buildStarted", "dispose", "intellij.android.projectSystem.gradle"})
final class GradleProjectSystemBuildPublisher
extends GradleBuildListener.Adapter
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Topic<ProjectSystemBuildManager.BuildListener> PROJECT_SYSTEM_BUILD_TOPIC;
    private int buildCount;

    public GradleProjectSystemBuildPublisher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.PROJECT_SYSTEM_BUILD_TOPIC = new Topic("Project build", ProjectSystemBuildManager.BuildListener.class);
        GradleBuildState.subscribe(this.project, this, this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void buildStarted(@NotNull BuildContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int n = this.buildCount;
        this.buildCount = n + 1;
        ProjectSystemBuildManager.BuildListener buildListener2 = (ProjectSystemBuildManager.BuildListener)this.project.getMessageBus().syncPublisher(this.PROJECT_SYSTEM_BUILD_TOPIC);
        Object object = context2.getBuildMode();
        if (object == null || (object = GradleProjectSystemBuildManagerKt.access$toProjectSystemBuildMode(object)) == null) {
            object = ProjectSystemBuildManager.BuildMode.UNKNOWN;
        }
        buildListener2.buildStarted((ProjectSystemBuildManager.BuildMode)((Object)object));
    }

    @Override
    public void buildFinished(@NotNull BuildStatus status2, @Nullable BuildContext context2) {
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        Object object = context2;
        if (object == null || (object = object.getBuildMode()) == null || (object = GradleProjectSystemBuildManagerKt.access$toProjectSystemBuildMode((BuildMode)object)) == null) {
            object = ProjectSystemBuildManager.BuildMode.UNKNOWN;
        }
        ProjectSystemBuildManager.BuildResult result2 = new ProjectSystemBuildManager.BuildResult((ProjectSystemBuildManager.BuildMode)((Object)object), GradleProjectSystemBuildManagerKt.access$toProjectSystemBuildStatus(status2), System.currentTimeMillis());
        ((ProjectSystemBuildManager.BuildListener)this.project.getMessageBus().syncPublisher(this.PROJECT_SYSTEM_BUILD_TOPIC)).beforeBuildCompleted(result2);
        this.buildCount = Math.max(this.buildCount - 1, 0);
        ((ProjectSystemBuildManager.BuildListener)this.project.getMessageBus().syncPublisher(this.PROJECT_SYSTEM_BUILD_TOPIC)).buildCompleted(result2);
    }

    public void dispose() {
    }

    public final void addBuildListener(@NotNull Disposable parentDisposable, @NotNull ProjectSystemBuildManager.BuildListener buildListener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)buildListener2, (String)"buildListener");
        this.project.getMessageBus().connect(parentDisposable).subscribe(this.PROJECT_SYSTEM_BUILD_TOPIC, (Object)buildListener2);
    }

    public final boolean isBuilding() {
        return this.buildCount > 0;
    }
}

