/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.gradle.model.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GradleClassFinderUtil {
    private GradleClassFinderUtil() {
    }

    @NotNull
    private static Stream<File> getCompilerOutputRoots(@NotNull GradleAndroidModel model2, boolean includeAndroidTests) {
        ArrayList<IdeAndroidArtifact> artifacts = new ArrayList<IdeAndroidArtifact>();
        artifacts.add(model2.getMainArtifact());
        if (includeAndroidTests) {
            artifacts.add(model2.getArtifactForAndroidTest());
        }
        return artifacts.stream().flatMap(artifactInfo -> artifactInfo.getClassesFolder().stream());
    }

    @NotNull
    public static Stream<File> getModuleCompileOutputs(@NotNull Module module2, boolean includeAndroidTests) {
        GradleAndroidModel androidModel = GradleAndroidModel.get(module2);
        if (androidModel != null) {
            return GradleClassFinderUtil.getCompilerOutputRoots(androidModel, includeAndroidTests);
        }
        Module[] modules2 = new Module[]{module2};
        return Stream.of(CompilerPaths.getOutputPaths((Module[])modules2)).map(File::new);
    }
}

