/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem;

import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.android.tools.idea.util.LinkedAndroidModuleGroup;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b*\u00020\u0006\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\u0006\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\u0006\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0006\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u0006\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0006\u001a\n\u0010\u0016\u001a\u00020\u0015*\u00020\u0006\u001a\n\u0010\u0017\u001a\u00020\u0015*\u00020\u0006\u001a\n\u0010\u0018\u001a\u00020\u0015*\u00020\u0006\u001a\n\u0010\u0019\u001a\u00020\u0015*\u00020\u0006\u00a8\u0006\u001a"}, d2={"androidFacetsForNonHolderModules", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lcom/intellij/openapi/project/Project;", "androidProjectType", "Lcom/android/tools/idea/projectsystem/AndroidModuleSystem$Type;", "Lcom/intellij/openapi/module/Module;", "getAllLinkedModules", "", "getAndroidTestModule", "getHolderModule", "getMainModule", "getScopeType", "Lcom/android/tools/idea/projectsystem/ScopeType;", "Lcom/android/tools/idea/projectsystem/AndroidModuleSystem;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "getTestFixturesModule", "getUnitTestModule", "isAndroidTestModule", "", "isHolderModule", "isLinkedAndroidModule", "isMainModule", "isUnitTestModule", "intellij.android.projectSystem"})
@JvmName(name="ModuleSystemUtil")
public final class ModuleSystemUtil {
    @NotNull
    public static final ScopeType getScopeType(@NotNull AndroidModuleSystem $this$getScopeType, @NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getScopeType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!TestSourcesFilter.isTestSources((VirtualFile)file2, (Project)project)) {
            return ScopeType.MAIN;
        }
        TestArtifactSearchScopes testArtifactSearchScopes = $this$getScopeType.getTestArtifactSearchScopes();
        if (testArtifactSearchScopes == null) {
            return ScopeType.ANDROID_TEST;
        }
        TestArtifactSearchScopes testScopes = testArtifactSearchScopes;
        boolean inAndroidTest = testScopes.isAndroidTestSource(file2);
        boolean inUnitTest = testScopes.isUnitTestSource(file2);
        return inUnitTest && inAndroidTest ? ScopeType.SHARED_TEST : (inUnitTest && !inAndroidTest ? ScopeType.UNIT_TEST : ScopeType.ANDROID_TEST);
    }

    @NotNull
    public static final List<Module> getAllLinkedModules(@NotNull Module $this$getAllLinkedModules) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllLinkedModules, (String)"<this>");
        Object object = (LinkedAndroidModuleGroup)$this$getAllLinkedModules.getUserData(CommonAndroidUtil.LINKED_ANDROID_MODULE_GROUP);
        if (object == null || (object = object.getModules()) == null) {
            object = CollectionsKt.listOf((Object)$this$getAllLinkedModules);
        }
        return object;
    }

    @NotNull
    public static final Module getHolderModule(@NotNull Module $this$getHolderModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getHolderModule, (String)"<this>");
        LinkedAndroidModuleGroup linkedAndroidModuleGroup = (LinkedAndroidModuleGroup)$this$getHolderModule.getUserData(CommonAndroidUtil.LINKED_ANDROID_MODULE_GROUP);
        if (linkedAndroidModuleGroup == null || (linkedAndroidModuleGroup = linkedAndroidModuleGroup.getHolder()) == null) {
            linkedAndroidModuleGroup = $this$getHolderModule;
        }
        return linkedAndroidModuleGroup;
    }

    public static final boolean isHolderModule(@NotNull Module $this$isHolderModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isHolderModule, (String)"<this>");
        return Intrinsics.areEqual((Object)ModuleSystemUtil.getHolderModule($this$isHolderModule), (Object)$this$isHolderModule);
    }

    @NotNull
    public static final Module getMainModule(@NotNull Module $this$getMainModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getMainModule, (String)"<this>");
        LinkedAndroidModuleGroup linkedAndroidModuleGroup = (LinkedAndroidModuleGroup)$this$getMainModule.getUserData(CommonAndroidUtil.LINKED_ANDROID_MODULE_GROUP);
        if (linkedAndroidModuleGroup == null || (linkedAndroidModuleGroup = linkedAndroidModuleGroup.getMain()) == null) {
            linkedAndroidModuleGroup = $this$getMainModule;
        }
        return linkedAndroidModuleGroup;
    }

    public static final boolean isMainModule(@NotNull Module $this$isMainModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isMainModule, (String)"<this>");
        return Intrinsics.areEqual((Object)ModuleSystemUtil.getMainModule($this$isMainModule), (Object)$this$isMainModule);
    }

    @Nullable
    public static final Module getUnitTestModule(@NotNull Module $this$getUnitTestModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getUnitTestModule, (String)"<this>");
        LinkedAndroidModuleGroup linkedAndroidModuleGroup = (LinkedAndroidModuleGroup)$this$getUnitTestModule.getUserData(CommonAndroidUtil.LINKED_ANDROID_MODULE_GROUP);
        if (linkedAndroidModuleGroup == null) {
            return $this$getUnitTestModule;
        }
        LinkedAndroidModuleGroup linkedGroup = linkedAndroidModuleGroup;
        return linkedGroup.getUnitTest();
    }

    public static final boolean isUnitTestModule(@NotNull Module $this$isUnitTestModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnitTestModule, (String)"<this>");
        return Intrinsics.areEqual((Object)ModuleSystemUtil.getUnitTestModule($this$isUnitTestModule), (Object)$this$isUnitTestModule);
    }

    @Nullable
    public static final Module getAndroidTestModule(@NotNull Module $this$getAndroidTestModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getAndroidTestModule, (String)"<this>");
        LinkedAndroidModuleGroup linkedAndroidModuleGroup = (LinkedAndroidModuleGroup)$this$getAndroidTestModule.getUserData(CommonAndroidUtil.LINKED_ANDROID_MODULE_GROUP);
        if (linkedAndroidModuleGroup == null) {
            return $this$getAndroidTestModule;
        }
        LinkedAndroidModuleGroup linkedGroup = linkedAndroidModuleGroup;
        return linkedGroup.getAndroidTest();
    }

    public static final boolean isAndroidTestModule(@NotNull Module $this$isAndroidTestModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isAndroidTestModule, (String)"<this>");
        return Intrinsics.areEqual((Object)ModuleSystemUtil.getAndroidTestModule($this$isAndroidTestModule), (Object)$this$isAndroidTestModule);
    }

    @Nullable
    public static final Module getTestFixturesModule(@NotNull Module $this$getTestFixturesModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getTestFixturesModule, (String)"<this>");
        LinkedAndroidModuleGroup linkedAndroidModuleGroup = (LinkedAndroidModuleGroup)$this$getTestFixturesModule.getUserData(CommonAndroidUtil.LINKED_ANDROID_MODULE_GROUP);
        if (linkedAndroidModuleGroup == null) {
            return null;
        }
        LinkedAndroidModuleGroup linkedGroup = linkedAndroidModuleGroup;
        return linkedGroup.getTestFixtures();
    }

    public static final boolean isLinkedAndroidModule(@NotNull Module $this$isLinkedAndroidModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkedAndroidModule, (String)"<this>");
        return $this$isLinkedAndroidModule.getUserData(CommonAndroidUtil.LINKED_ANDROID_MODULE_GROUP) != null;
    }

    @NotNull
    public static final AndroidModuleSystem.Type androidProjectType(@NotNull Module $this$androidProjectType) {
        Intrinsics.checkNotNullParameter((Object)$this$androidProjectType, (String)"<this>");
        return ProjectSystemUtil.getModuleSystem($this$androidProjectType).getType();
    }

    @NotNull
    public static final Sequence<AndroidFacet> androidFacetsForNonHolderModules(@NotNull Project $this$androidFacetsForNonHolderModules) {
        Intrinsics.checkNotNullParameter((Object)$this$androidFacetsForNonHolderModules, (String)"<this>");
        List list2 = ProjectFacetManager.getInstance((Project)$this$androidFacetsForNonHolderModules).getModulesWithFacet(AndroidFacet.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInstance(this).getMod\u2026ithFacet(AndroidFacet.ID)");
        Sequence it = CollectionsKt.asSequence((Iterable)list2);
        boolean bl = false;
        return SequencesKt.mapNotNull((Sequence)(ApplicationManager.getApplication().isUnitTestMode() ? it : SequencesKt.filter((Sequence)it, (Function1)androidFacetsForNonHolderModules.1.1.INSTANCE)), (Function1)androidFacetsForNonHolderModules.2.INSTANCE);
    }
}

