/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem;

import com.google.common.base.Strings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidProjectRootUtil {
    private AndroidProjectRootUtil() {
    }

    @Nullable
    public static @SystemIndependent String getModuleDirPath(@NotNull Module module2) {
        String linkedProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module2);
        if (!Strings.isNullOrEmpty((String)linkedProjectPath)) {
            return linkedProjectPath;
        }
        @SystemIndependent String moduleFilePath = module2.getModuleFilePath();
        return VfsUtil.getParentDir((String)moduleFilePath);
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module2, String relativePath, boolean lookInContentRoot) {
        if (module2.isDisposed() || relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(module2);
        if (moduleDirPath != null) {
            String absPath = FileUtil.toSystemIndependentName((String)(moduleDirPath + relativePath));
            ProgressManager.checkCanceled();
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(absPath);
            if (file2 != null) {
                return file2;
            }
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (lookInContentRoot) {
            for (VirtualFile contentRoot : contentRoots) {
                String absPath = FileUtil.toSystemIndependentName((String)(contentRoot.getPath() + relativePath));
                ProgressManager.checkCanceled();
                VirtualFile file3 = LocalFileSystem.getInstance().findFileByPath(absPath);
                if (file3 == null) continue;
                return file3;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        String path2 = facet2.getProperties().GEN_FOLDER_RELATIVE_PATH_APT;
        if (path2.isEmpty()) {
            return null;
        }
        @SystemIndependent String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(facet2.getModule());
        return moduleDirPath != null ? moduleDirPath + path2 : null;
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAidlGenSourceRootPath(@NotNull AndroidFacet facet2) {
        String path2 = facet2.getProperties().GEN_FOLDER_RELATIVE_PATH_AIDL;
        if (path2.isEmpty()) {
            return null;
        }
        @SystemIndependent String moduleDirPath = AndroidProjectRootUtil.getModuleDirPath(facet2.getModule());
        return moduleDirPath != null ? moduleDirPath + path2 : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAidlGenDir(@NotNull AndroidFacet facet2) {
        String genPath = AndroidProjectRootUtil.getAidlGenSourceRootPath(facet2);
        return genPath != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Deprecated
    @Nullable
    public static String getRenderscriptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getAidlGenSourceRootPath(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getRenderscriptGenDir(@NotNull AndroidFacet facet2) {
        String path2 = AndroidProjectRootUtil.getRenderscriptGenSourceRootPath(facet2);
        return path2 != null ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getFileByRelativeModulePath(facet2.getModule(), facet2.getProperties().ASSETS_FOLDER_RELATIVE_PATH, false);
    }
}

