/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.facet.Facet;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectInfo {
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidProjectInfo getInstance(@NotNull Project project) {
        return (AndroidProjectInfo)project.getService(AndroidProjectInfo.class);
    }

    public AndroidProjectInfo(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<Module> getAllModulesOfProjectType(int projectType) {
        return ProjectSystemUtil.getAndroidFacets(this.myProject).stream().filter(f -> ((AndroidFacetConfiguration)f.getConfiguration()).getProjectType() == projectType).map(Facet::getModule).collect(Collectors.toList());
    }

    public boolean isApkProject() {
        if (ApkDebugging.isMarkedAsApkDebuggingProject(this.myProject)) {
            return true;
        }
        if (ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(ApkFacet.getFacetTypeId())) {
            ApkDebugging.markAsApkDebuggingProject(this.myProject);
            return true;
        }
        return false;
    }

    public boolean requiredAndroidModelMissing() {
        List<AndroidFacet> androidFacets = ProjectSystemUtil.getAndroidFacets(this.myProject);
        return ContainerUtil.exists(androidFacets, f -> AndroidModel.isRequired(f) && AndroidModel.get(f) == null);
    }

    public boolean isLegacyIdeaAndroidProject() {
        List<AndroidFacet> androidFacets = ProjectSystemUtil.getAndroidFacets(this.myProject);
        return ContainerUtil.exists(androidFacets, f -> !AndroidModel.isRequired(f));
    }
}

