/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonManager;
import com.android.tools.idea.transport.DeployableFile;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\rH\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager;", "Lcom/intellij/openapi/Disposable;", "ticker", "Lcom/google/common/base/Ticker;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/google/common/base/Ticker;Ljava/util/concurrent/ExecutorService;)V", "<set-?>", "", "daemonPort", "getDaemonPort", "()I", "disposed", "", "process", "Ljava/lang/Process;", "dispose", "", "makeSureDaemonIsRunning", "tracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "processIsRunning", "Companion", "DaemonStatus", "TPDStdoutListener", "intellij.android.profilersAndroid"})
public final class TraceProcessorDaemonManager
implements Disposable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Ticker ticker;
    @NotNull
    private final ExecutorService executorService;
    @Nullable
    private Process process;
    private boolean disposed;
    private int daemonPort;
    @Deprecated
    @NotNull
    private static final Logger LOGGER;
    @Deprecated
    private static final long TPD_SPAWN_TIMEOUT;
    @Deprecated
    private static final Pattern SERVER_STARTED;
    @Deprecated
    @NotNull
    private static final String SERVER_PORT_BIND_FAILED = "Server failed to start. A port number wasn't bound.";
    @Deprecated
    @NotNull
    private static final Lazy<String> TPD_DEV_PATH$delegate;
    @Deprecated
    @NotNull
    private static final String TPD_RELEASE_PATH;
    @Deprecated
    @NotNull
    private static final Lazy<String> TPD_EXECUTABLE$delegate;
    @Deprecated
    @NotNull
    private static final DeployableFile TPD_BINARY;

    public TraceProcessorDaemonManager(@NotNull Ticker ticker, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.ticker = ticker;
        this.executorService = executorService;
    }

    public /* synthetic */ TraceProcessorDaemonManager(Ticker ticker, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(ticker, executorService);
    }

    public final int getDaemonPort() {
        return this.daemonPort;
    }

    @VisibleForTesting
    public final boolean processIsRunning() {
        Process process2 = this.process;
        return process2 != null ? process2.isAlive() : false;
    }

    public final synchronized void makeSureDaemonIsRunning(@NotNull FeatureTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (!this.processIsRunning() && !this.disposed) {
            Stopwatch spawnStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
            LOGGER.info("TPD Manager: Starting new instance of TPD");
            String[] stringArray = new String[]{TraceProcessorDaemonManager.Companion.getExecutablePath(), "--llvm_symbolizer_path", NativeSymbolizerKt.getLlvmSymbolizerPath()};
            Process newProcess = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
            TPDStdoutListener stdoutListener = new TPDStdoutListener(new BufferedReader(new InputStreamReader(newProcess.getInputStream())));
            this.executorService.execute(stdoutListener);
            stdoutListener.waitForStatusChangeOrTerminated(TPD_SPAWN_TIMEOUT);
            spawnStopwatch.stop();
            long timeToSpawnMs = spawnStopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (stdoutListener.getStatus() == DaemonStatus.RUNNING) {
                tracker.trackTraceProcessorDaemonSpawnAttempt(true, timeToSpawnMs);
                this.daemonPort = stdoutListener.getSelectedPort();
                this.process = newProcess;
                LOGGER.info("TPD Manager: TPD instance ready on port " + this.daemonPort + ".");
            } else {
                tracker.trackTraceProcessorDaemonSpawnAttempt(false, timeToSpawnMs);
                LOGGER.info("TPD Manager: Unable to start TPD instance.");
                Process process2 = newProcess;
                if (process2 != null && (process2 = process2.destroyForcibly()) != null) {
                    process2.waitFor();
                }
                throw new RuntimeException("Unable to start TPD instance.");
            }
        }
    }

    public synchronized void dispose() {
        block0: {
            this.disposed = true;
            Process process2 = this.process;
            if (process2 == null || (process2 = process2.destroyForcibly()) == null) break block0;
            process2.waitFor();
        }
    }

    static {
        Logger logger2 = Logger.getInstance(TraceProcessorDaemonManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(TraceProcess\u2026aemonManager::class.java)");
        LOGGER = logger2;
        TPD_SPAWN_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
        SERVER_STARTED = Pattern.compile("^Server listening on (?:127.0.0.1|localhost):(?<port>\\d+)\n*$");
        TPD_DEV_PATH$delegate = LazyKt.lazy((Function0)Companion.TPD_DEV_PATH.2.INSTANCE);
        TPD_RELEASE_PATH = "plugins/android/resources/trace_processor_daemon";
        TPD_EXECUTABLE$delegate = LazyKt.lazy((Function0)Companion.TPD_EXECUTABLE.2.INSTANCE);
        DeployableFile deployableFile = new DeployableFile.Builder(TraceProcessorDaemonManager.Companion.getTPD_EXECUTABLE()).setReleaseDir(TPD_RELEASE_PATH).setDevDir(TraceProcessorDaemonManager.Companion.getTPD_DEV_PATH()).setExecutable(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)deployableFile, (String)"Builder(TPD_EXECUTABLE)\n\u2026able(true)\n      .build()");
        TPD_BINARY = deployableFile;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0015\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SERVER_PORT_BIND_FAILED", "", "SERVER_STARTED", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "TPD_BINARY", "Lcom/android/tools/idea/transport/DeployableFile;", "TPD_DEV_PATH", "getTPD_DEV_PATH", "()Ljava/lang/String;", "TPD_DEV_PATH$delegate", "Lkotlin/Lazy;", "TPD_EXECUTABLE", "getTPD_EXECUTABLE", "TPD_EXECUTABLE$delegate", "TPD_RELEASE_PATH", "TPD_SPAWN_TIMEOUT", "", "getExecutablePath", "intellij.android.profilersAndroid"})
    private static final class Companion {
        private Companion() {
        }

        private final String getTPD_DEV_PATH() {
            Lazy lazy = TPD_DEV_PATH$delegate;
            return (String)lazy.getValue();
        }

        private final String getTPD_EXECUTABLE() {
            Lazy lazy = TPD_EXECUTABLE$delegate;
            return (String)lazy.getValue();
        }

        private final String getExecutablePath() {
            String string = new File(TPD_BINARY.getDir(), TPD_BINARY.getFileName()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(TPD_BINARY.dir, TPD\u2026RY.fileName).absolutePath");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "", "(Ljava/lang/String;I)V", "STARTING", "RUNNING", "FAILED", "END_OF_STREAM", "intellij.android.profilersAndroid"})
    public static final class DaemonStatus
    extends Enum<DaemonStatus> {
        public static final /* enum */ DaemonStatus STARTING = new DaemonStatus();
        public static final /* enum */ DaemonStatus RUNNING = new DaemonStatus();
        public static final /* enum */ DaemonStatus FAILED = new DaemonStatus();
        public static final /* enum */ DaemonStatus END_OF_STREAM = new DaemonStatus();
        private static final /* synthetic */ DaemonStatus[] $VALUES;

        public static DaemonStatus[] values() {
            return (DaemonStatus[])$VALUES.clone();
        }

        public static DaemonStatus valueOf(String value2) {
            return Enum.valueOf(DaemonStatus.class, value2);
        }

        static {
            $VALUES = daemonStatusArray = new DaemonStatus[]{DaemonStatus.STARTING, DaemonStatus.RUNNING, DaemonStatus.FAILED, DaemonStatus.END_OF_STREAM};
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$TPDStdoutListener;", "Ljava/lang/Runnable;", "outputReader", "Ljava/io/BufferedReader;", "(Ljava/io/BufferedReader;)V", "<set-?>", "", "selectedPort", "getSelectedPort", "()I", "newStatus", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "status", "getStatus", "()Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;", "setStatus", "(Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager$DaemonStatus;)V", "statusLock", "Ljava/lang/Object;", "run", "", "terminated", "", "waitForStatusChangeOrTerminated", "timeout", "", "waitUntilTerminated", "intellij.android.profilersAndroid"})
    public static final class TPDStdoutListener
    implements Runnable {
        @NotNull
        private final BufferedReader outputReader;
        @NotNull
        private final Object statusLock;
        @NotNull
        private DaemonStatus status;
        private int selectedPort;

        public TPDStdoutListener(@NotNull BufferedReader outputReader) {
            Intrinsics.checkNotNullParameter((Object)outputReader, (String)"outputReader");
            this.outputReader = outputReader;
            this.statusLock = new Object();
            this.status = DaemonStatus.STARTING;
        }

        @NotNull
        public final DaemonStatus getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setStatus(DaemonStatus newStatus) {
            Object object = this.statusLock;
            synchronized (object) {
                boolean bl = false;
                LOGGER.debug("TPD Manager: Daemon status: " + newStatus);
                this.status = newStatus;
                this.statusLock.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }

        public final int getSelectedPort() {
            return this.selectedPort;
        }

        @Override
        public void run() {
            block3: {
                while (true) {
                    String line2;
                    if ((line2 = this.outputReader.readLine()) == null) {
                        LOGGER.debug("TPD Manager: [TPD Log] EOF");
                        this.setStatus(DaemonStatus.END_OF_STREAM);
                        break block3;
                    }
                    LOGGER.debug("TPD Manager: [TPD Log] " + line2);
                    Matcher serverOkMatcher = SERVER_STARTED.matcher(line2);
                    if (serverOkMatcher.matches()) {
                        String string = serverOkMatcher.group("port");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serverOkMatcher.group(\"port\")");
                        this.selectedPort = Integer.parseInt(string);
                        this.setStatus(DaemonStatus.RUNNING);
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)line2, (String)TraceProcessorDaemonManager.SERVER_PORT_BIND_FAILED, (boolean)false, (int)2, null)) break;
                }
                this.setStatus(DaemonStatus.FAILED);
            }
        }

        @VisibleForTesting
        public final void waitUntilTerminated(long timeout) {
            while (!this.terminated()) {
                this.waitForStatusChangeOrTerminated(timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitForStatusChangeOrTerminated(long timeout) {
            Object object = this.statusLock;
            synchronized (object) {
                boolean bl = false;
                if (!this.terminated()) {
                    this.statusLock.wait(timeout);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private final boolean terminated() {
            return this.status == DaemonStatus.END_OF_STREAM || this.status == DaemonStatus.FAILED;
        }
    }
}

