/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.netty.NettyChannelBuilder;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonManager;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonQueryResult;
import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profiler.perfetto.proto.TraceProcessorServiceGrpc;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015J;\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H 0\u0017\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010 2\u0006\u0010\u001d\u001a\u0002H!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H 0#H\u0002\u00a2\u0006\u0002\u0010$R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonClient;", "Lcom/intellij/openapi/Disposable;", "ticker", "Lcom/google/common/base/Ticker;", "stubForTesting", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessorServiceGrpc$TraceProcessorServiceBlockingStub;", "(Lcom/google/common/base/Ticker;Lcom/android/tools/profiler/perfetto/proto/TraceProcessorServiceGrpc$TraceProcessorServiceBlockingStub;)V", "(Lcom/google/common/base/Ticker;)V", "cachedChannel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "cachedChannelPort", "", "cachedStub", "daemonManager", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonManager;", "disposed", "", "dispose", "", "getStub", "tracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "loadTrace", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonQueryResult;", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$LoadTraceResponse;", "requestProto", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$LoadTraceRequest;", "queryBatchRequest", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryBatchResponse;", "request", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryBatchRequest;", "retry", "B", "A", "rpc", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonQueryResult;", "Companion", "intellij.android.profilersAndroid"})
public final class TraceProcessorDaemonClient
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TraceProcessorDaemonManager daemonManager;
    private int cachedChannelPort;
    @Nullable
    private ManagedChannel cachedChannel;
    @Nullable
    private TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub cachedStub;
    @Nullable
    private TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub stubForTesting;
    private boolean disposed;
    @NotNull
    private static final Logger LOGGER;

    public TraceProcessorDaemonClient(@NotNull Ticker ticker) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        this.daemonManager = new TraceProcessorDaemonManager(ticker, null, 2, null);
        Disposer.register((Disposable)this, (Disposable)this.daemonManager);
    }

    @VisibleForTesting
    public TraceProcessorDaemonClient(@NotNull Ticker ticker, @Nullable TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub stubForTesting) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        this(ticker);
        this.stubForTesting = stubForTesting;
    }

    public /* synthetic */ TraceProcessorDaemonClient(Ticker ticker, TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub traceProcessorServiceBlockingStub, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            traceProcessorServiceBlockingStub = null;
        }
        this(ticker, traceProcessorServiceBlockingStub);
    }

    private final synchronized TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub getStub(FeatureTracker tracker) {
        TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub traceProcessorServiceBlockingStub = this.stubForTesting;
        if (traceProcessorServiceBlockingStub != null) {
            TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub it = traceProcessorServiceBlockingStub;
            boolean bl = false;
            return it;
        }
        this.daemonManager.makeSureDaemonIsRunning(tracker);
        ManagedChannel previousChannel = this.cachedChannel;
        if (previousChannel == null || previousChannel.isShutdown() || previousChannel.isTerminated() || this.cachedChannelPort != this.daemonManager.getDaemonPort()) {
            ManagedChannel managedChannel = previousChannel;
            if (managedChannel != null) {
                managedChannel.shutdownNow();
            }
            this.cachedChannelPort = this.daemonManager.getDaemonPort();
            LOGGER.debug("TPD Client: building new channel to localhost:" + this.cachedChannelPort);
            this.cachedChannel = NettyChannelBuilder.forAddress((String)"localhost", (int)this.cachedChannelPort).usePlaintext().maxInboundMessageSize(0x20000000).build();
        }
        if (this.cachedStub == null || !Intrinsics.areEqual((Object)previousChannel, (Object)this.cachedChannel)) {
            LOGGER.debug("TPD Client: building new stub");
            this.cachedStub = TraceProcessorServiceGrpc.newBlockingStub((Channel)((Channel)this.cachedChannel));
        }
        TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub traceProcessorServiceBlockingStub2 = this.cachedStub;
        Intrinsics.checkNotNull((Object)traceProcessorServiceBlockingStub2);
        return traceProcessorServiceBlockingStub2;
    }

    @NotNull
    public final TraceProcessorDaemonQueryResult<TraceProcessor.LoadTraceResponse> loadTrace(@NotNull TraceProcessor.LoadTraceRequest requestProto, @NotNull FeatureTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)requestProto, (String)"requestProto");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        return this.retry(requestProto, (Function1)new Function1<TraceProcessor.LoadTraceRequest, TraceProcessor.LoadTraceResponse>(this, tracker){
            final /* synthetic */ TraceProcessorDaemonClient this$0;
            final /* synthetic */ FeatureTracker $tracker;
            {
                this.this$0 = $receiver;
                this.$tracker = $tracker;
                super(1);
            }

            @NotNull
            public final TraceProcessor.LoadTraceResponse invoke(@NotNull TraceProcessor.LoadTraceRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TraceProcessor.LoadTraceResponse loadTraceResponse = TraceProcessorDaemonClient.access$getStub(this.this$0, this.$tracker).loadTrace(it);
                Intrinsics.checkNotNullExpressionValue((Object)loadTraceResponse, (String)"getStub(tracker).loadTrace(it)");
                return loadTraceResponse;
            }
        });
    }

    @NotNull
    public final TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryBatchRequest(@NotNull TraceProcessor.QueryBatchRequest request2, @NotNull FeatureTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        return this.retry(request2, (Function1)new Function1<TraceProcessor.QueryBatchRequest, TraceProcessor.QueryBatchResponse>(this, tracker){
            final /* synthetic */ TraceProcessorDaemonClient this$0;
            final /* synthetic */ FeatureTracker $tracker;
            {
                this.this$0 = $receiver;
                this.$tracker = $tracker;
                super(1);
            }

            @NotNull
            public final TraceProcessor.QueryBatchResponse invoke(@NotNull TraceProcessor.QueryBatchRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TraceProcessor.QueryBatchResponse queryBatchResponse = TraceProcessorDaemonClient.access$getStub(this.this$0, this.$tracker).queryBatch(it);
                Intrinsics.checkNotNullExpressionValue((Object)queryBatchResponse, (String)"getStub(tracker).queryBatch(it)");
                return queryBatchResponse;
            }
        });
    }

    private final <A, B> TraceProcessorDaemonQueryResult<B> retry(A request2, Function1<? super A, ? extends B> rpc) {
        Exception lastException = null;
        for (int i = 1; i < 4; ++i) {
            try {
                if (this.disposed) continue;
                return new TraceProcessorDaemonQueryResult<Object>(rpc.invoke(request2));
            }
            catch (Exception e) {
                LOGGER.debug("TPD Client: Attempt " + i + " of RPC failed (`" + e.getMessage() + "`).");
                lastException = e;
                Thread.sleep(200L);
            }
        }
        return new TraceProcessorDaemonQueryResult(new RuntimeException("Unable to reach TPDaemon.", lastException));
    }

    public void dispose() {
        block0: {
            this.disposed = true;
            ManagedChannel managedChannel = this.cachedChannel;
            if (managedChannel == null) break block0;
            managedChannel.shutdownNow();
        }
    }

    public static final /* synthetic */ TraceProcessorServiceGrpc.TraceProcessorServiceBlockingStub access$getStub(TraceProcessorDaemonClient $this, FeatureTracker tracker) {
        return $this.getStub(tracker);
    }

    static {
        Logger logger2 = Logger.getInstance(TraceProcessorDaemonClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(TraceProcess\u2026DaemonClient::class.java)");
        LOGGER = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonClient$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

