/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.commands;

import androidx.tracing.perfetto.PerfettoHandshake;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.io.IdeFileService;
import com.android.tools.idea.profilers.commands.Artifact;
import com.android.tools.idea.profilers.commands.CpuTraceInterceptCommandHandler;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.PerfettoSdkHandshakeMetadata;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.assertj.core.util.VisibleForTesting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00108\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/profilers/commands/CpuTraceInterceptCommandHandler;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "device", "Lcom/android/ddmlib/IDevice;", "transportStub", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;)V", "getDevice", "()Lcom/android/ddmlib/IDevice;", "<set-?>", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "lastMetricsEvent", "getLastMetricsEvent$annotations", "()V", "getLastMetricsEvent", "()Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "", "lastResponseCode", "getLastResponseCode$annotations", "getLastResponseCode", "()I", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "enableTrackingCompose", "", "command", "Lcom/android/tools/profiler/proto/Commands$Command;", "execute", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "resolveArtifact", "Ljava/nio/file/Path;", "artifactVersion", "", "shouldHandle", "", "intellij.android.profilersAndroid"})
public final class CpuTraceInterceptCommandHandler
implements TransportProxy.ProxyCommandHandler {
    @NotNull
    private final IDevice device;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub transportStub;
    private int lastResponseCode;
    @Nullable
    private AndroidStudioEvent.Builder lastMetricsEvent;
    @NotNull
    private final Logger log;

    public CpuTraceInterceptCommandHandler(@NotNull IDevice device2, @NotNull TransportServiceGrpc.TransportServiceBlockingStub transportStub) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)transportStub, (String)"transportStub");
        this.device = device2;
        this.transportStub = transportStub;
        this.lastResponseCode = -1;
        Logger logger2 = Logger.getInstance(CpuTraceInterceptCommandHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(CpuTraceInte\u2026mmandHandler::class.java)");
        this.log = logger2;
    }

    @NotNull
    public final IDevice getDevice() {
        return this.device;
    }

    public final int getLastResponseCode() {
        return this.lastResponseCode;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLastResponseCode$annotations() {
    }

    @Nullable
    public final AndroidStudioEvent.Builder getLastMetricsEvent() {
        return this.lastMetricsEvent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLastMetricsEvent$annotations() {
    }

    @Override
    public boolean shouldHandle(@NotNull Commands.Command command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Commands.Command.CommandType commandType = command2.getType();
        return (commandType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) == 1 ? ProfilingConfiguration.TraceType.from((Trace.TraceConfiguration)command2.getStartCpuTrace().getConfiguration()) == ProfilingConfiguration.TraceType.PERFETTO : false;
    }

    @Override
    @NotNull
    public Transport.ExecuteResponse execute(@NotNull Commands.Command command2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        boolean bl2 = bl = command2.getType() == Commands.Command.CommandType.START_CPU_TRACE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.enableTrackingCompose(command2);
        Transport.ExecuteResponse executeResponse = this.transportStub.execute(Transport.ExecuteRequest.newBuilder().setCommand(command2).build());
        Intrinsics.checkNotNullExpressionValue((Object)executeResponse, (String)"transportStub.execute(Tr\u2026                .build())");
        return executeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void enableTrackingCompose(Commands.Command command2) {
        PerfettoSdkHandshakeMetadata.HandshakeResult handshakeResult = null;
        handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.UNKNOWN_RESULT;
        try {
            Object object;
            AndroidStudioEvent.Builder builder2;
            String string = command2.getStartCpuTrace().getConfiguration().getAppName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command.startCpuTrace.configuration.appName");
            PerfettoHandshake handshake2 = new PerfettoHandshake(string, (Function1)enableTrackingCompose.handshake.1.INSTANCE, (Function1)new Function1<String, String>(this){
                final /* synthetic */ CpuTraceInterceptCommandHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    CountDownLatch latch = new CountDownLatch(1);
                    CollectingOutputReceiver receiver2 = new CollectingOutputReceiver(latch);
                    this.this$0.getDevice().executeShellCommand(it, (IShellOutputReceiver)receiver2);
                    latch.await(5L, TimeUnit.SECONDS);
                    String string = receiver2.getOutput();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"receiver.output");
                    return string;
                }
            });
            AndroidStudioEvent.Builder it = handshake2.enableTracing(null);
            boolean bl = false;
            if (it.getExitCode() == 11) {
                Path path2 = this.resolveArtifact(it.getRequiredVersion());
                if (path2 == null) {
                    handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.ERROR_BINARY_UNAVAILABLE;
                    this.log.warn("Failed to download tracing-perfetto-binary ");
                    return;
                }
                File baseApk = new File(path2.toUri());
                PerfettoHandshake.ExternalLibraryProvider libraryProvider2 = new PerfettoHandshake.ExternalLibraryProvider(baseApk, new File(FileUtilRt.getTempDirectory()), (Function2)new Function2<File, File, Unit>(this){
                    final /* synthetic */ CpuTraceInterceptCommandHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull File tmpFile, @NotNull File dstFile) {
                        Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
                        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
                        this.this$0.getDevice().pushFile(tmpFile.getAbsolutePath(), dstFile.getAbsolutePath());
                    }
                });
                builder2 = handshake2.enableTracing(libraryProvider2);
            } else {
                builder2 = it;
            }
            AndroidStudioEvent.Builder response2 = builder2;
            this.lastResponseCode = response2.getExitCode();
            switch (response2.getExitCode()) {
                case 0: {
                    object = "The broadcast to enable tracing was not received. This most likely means that the app does not contain the `androidx.tracing.tracing-perfetto` library as its dependency.";
                    break;
                }
                case 1: {
                    object = null;
                    break;
                }
                case 2: {
                    object = "Perfetto SDK already enabled.";
                    break;
                }
                case 11: {
                    object = "Perfetto SDK binary dependencies missing. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + ".";
                    break;
                }
                case 12: {
                    object = "Perfetto SDK binary mismatch. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + ".";
                    break;
                }
                case 13: {
                    object = "Perfetto SDK binary verification failed. Required version: " + response2.getRequiredVersion() + ". Error: " + response2.getMessage() + ". If working with an unreleased snapshot, ensure all modules are built against the same snapshot (e.g. clear caches and rebuild).";
                    break;
                }
                case 99: {
                    object = "Error: " + response2.getMessage() + ".";
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized exit code: " + response2.getExitCode() + ".");
                }
            }
            String error = object;
            if (error != null) {
                this.log.warn(error);
            }
            switch (response2.getExitCode()) {
                case 0: {
                    handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.UNSUPPORTED;
                    return;
                }
                case 1: {
                    handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.SUCCESS;
                    return;
                }
                case 2: {
                    handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.ALREADY_ENABLED;
                    return;
                }
                case 12: {
                    handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.ERROR_BINARY_VERSION_MISMATCH;
                    return;
                }
                case 13: {
                    handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.ERROR_BINARY_VERIFICATION_ERROR;
                    return;
                }
                case 99: {
                    handshakeResult = PerfettoSdkHandshakeMetadata.HandshakeResult.ERROR_OTHER;
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            if (t.getMessage() != null) {
                String string = t.getMessage();
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"result=0", (boolean)false, (int)2, null)) return;
            }
            this.log.warn(t);
            return;
        }
        finally {
            AndroidStudioEvent.Builder builder3;
            AndroidStudioEvent.Builder it = builder3 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(this.device)).setAndroidProfilerEvent(AndroidProfilerEvent.newBuilder().setType(AndroidProfilerEvent.Type.PERFETTO_SDK_HANDSHAKE).setPerfettoSdkHandshakeMetadata(PerfettoSdkHandshakeMetadata.newBuilder().setHandshakeResult(handshakeResult)));
            boolean bl = false;
            this.lastMetricsEvent = it;
            AndroidStudioEvent.Builder builder4 = builder3;
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"newBuilder()\n          .\u2026{ lastMetricsEvent = it }");
            UsageTracker.log((AndroidStudioEvent.Builder)builder4);
        }
    }

    private final Path resolveArtifact(String artifactVersion) {
        Path path2;
        Artifact artifact2 = new Artifact("androidx.tracing", "tracing-perfetto-binary", artifactVersion);
        try {
            Path tmpDir = new IdeFileService("profiler-artifacts").getOrCreateTempDir("http-tmp");
            Path tmpFile = tmpDir.resolve(artifact2.getFileName());
            this.log.debug("StudioDownloader downloading: " + artifact2.getFileName());
            new StudioDownloader().downloadFullyWithCaching(artifact2.toGMavenUrl(), tmpFile, null, (ProgressIndicator)new ConsoleProgressIndicator());
            path2 = tmpFile;
        }
        catch (IOException e) {
            path2 = null;
        }
        return path2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Commands.Command.CommandType.values().length];
            nArray[Commands.Command.CommandType.START_CPU_TRACE.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

