/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.capture;

import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerCaptureEditor
implements FileEditor {
    private final JPanel myPanel;
    private final Project myProject;
    private final VirtualFile myFile;

    public AndroidProfilerCaptureEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        this.myProject = project;
        this.myFile = file2;
        this.myPanel = new JPanel(new BorderLayout());
        AndroidProfilerCaptureEditor.importFileIntoAndroidProfiler(this.myProject, this.myFile);
    }

    private static void importFileIntoAndroidProfiler(@NotNull Project project, VirtualFile file2) {
        ToolWindow window2 = ToolWindowManager.getInstance((Project)project).getToolWindow("Android Profiler");
        if (window2 != null) {
            AndroidProfilerToolWindow profilerToolWindow;
            window2.setShowStripeButton(true);
            if (!window2.isVisible()) {
                window2.show(null);
            }
            if ((profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project)) != null) {
                profilerToolWindow.openFile(file2);
            }
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "AndroidProfilerCaptureEditor";
    }

    public void setState(@NotNull FileEditorState state2) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (FileEditorManager.getInstance((Project)this.myProject).isFileOpen(this.myFile)) {
            ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)this.myProject).closeFile(this.myFile));
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
    }
}

