/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.datastore.poller.MemoryDataPoller;
import com.android.tools.idea.profilers.LegacyAllocationTracker;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class StudioLegacyAllocationTracker
implements LegacyAllocationTracker {
    private IDevice myDevice;
    private int myPid;
    private boolean myOngoingTracking;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryDataPoller.class);
    }

    public StudioLegacyAllocationTracker(@NotNull IDevice device2, int processId) {
        this.myDevice = device2;
        this.myPid = processId;
    }

    @Override
    public boolean trackAllocations(boolean enabled, Executor executor2, Consumer<byte[]> allocationConsumer) {
        Client client2 = this.getClient(this.myPid);
        if (client2 == null) {
            return false;
        }
        if (enabled == this.myOngoingTracking) {
            return false;
        }
        this.myOngoingTracking = enabled;
        if (!enabled) {
            assert (executor2 != null);
            this.getAllocationTrackingDump(client2, executor2, data2 -> {
                assert (allocationConsumer != null);
                allocationConsumer.accept((byte[])data2);
            });
        }
        client2.enableAllocationTracker(enabled);
        return true;
    }

    private void getAllocationTrackingDump(final @NotNull Client callingClient, final @NotNull Executor executor2, final @NotNull Consumer<byte[]> consumer) {
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client2, int changeMask) {
                if (callingClient == client2 && (changeMask & 0x200) != 0) {
                    byte[] data2 = client2.getClientData().getAllocationsData();
                    executor2.execute(() -> consumer.accept(data2));
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                }
            }
        });
        callingClient.requestAllocationDetails();
    }

    private Client getClient(int processId) {
        if (!this.myDevice.isOnline()) {
            return null;
        }
        Client client2 = this.myDevice.getClient(this.myDevice.getClientName(processId));
        if (client2 == null) {
            StudioLegacyAllocationTracker.getLogger().info("StudioLegacyAllocationTracker unable to find application with process Id: " + processId);
        }
        return client2;
    }
}

