/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.StudioProgramRunner;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.profilers.StudioProfilers;
import com.google.wireless.android.sdk.stats.RunWithProfilingMetadata;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/profilers/ProfilerProgramRunner;", "Lcom/android/tools/idea/run/StudioProgramRunner;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "canRunWithMultipleDevices", "checkProfileableSupportAndExecute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "doExecute", "doExecuteInternal", "getRunnerId", "Companion", "intellij.android.profilersAndroid"})
public final class ProfilerProgramRunner
extends StudioProgramRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getRunnerId() {
        return "ProfilerProgramRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return super.canRun(executorId, profile) && ProfilerProgramRunner.Companion.canRunByProfiler(executorId, (AndroidRunConfigurationBase)profile);
    }

    @Override
    protected boolean canRunWithMultipleDevices(@NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        return false;
    }

    @Override
    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunContentDescriptor runContentDescriptor;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"environment.executor.id");
        String executorId = string;
        if (Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId)) {
            runContentDescriptor = this.doExecuteInternal(state2, environment);
        } else {
            AbstractProfilerExecutorGroup.AbstractProfilerSetting abstractProfilerSetting = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executorId);
            ProfilingMode profilingMode = abstractProfilerSetting != null ? abstractProfilerSetting.getProfilingMode() : null;
            switch (profilingMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[profilingMode.ordinal()]) {
                case 1: 
                case 2: {
                    runContentDescriptor = this.doExecuteInternal(state2, environment);
                    break;
                }
                case 3: {
                    runContentDescriptor = this.checkProfileableSupportAndExecute(state2, environment);
                    break;
                }
                default: {
                    runContentDescriptor = null;
                }
            }
        }
        return runContentDescriptor;
    }

    private final RunContentDescriptor doExecuteInternal(RunProfileState state2, ExecutionEnvironment environment) {
        RunContentDescriptor descriptor2 = super.doExecute(state2, environment);
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        Companion.createProfilerToolWindow(project, environment.getRunnerAndConfigurationSettings(), environment.getUserData(SwapInfo.SWAP_INFO_KEY) != null, environment.getExecutor().getId());
        return descriptor2;
    }

    private final RunContentDescriptor checkProfileableSupportAndExecute(RunProfileState state2, ExecutionEnvironment environment) {
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        if (ProfilerProgramRunner.Companion.isAgpVersionSupported(project) && ProfilerProgramRunner.Companion.isDeviceSupported(environment)) {
            return this.doExecuteInternal(state2, environment);
        }
        Project project2 = environment.getProject();
        DialogWrapper dialog2 = new DialogWrapper(project2){
            {
                this.setTitle("Confirmation");
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                JPanel jPanel;
                JPanel $this$createCenterPanel_u24lambda_u2d0 = jPanel = new JPanel(new BorderLayout());
                boolean bl = false;
                $this$createCenterPanel_u24lambda_u2d0.add((Component)new JBLabel("<html>Profiling with Low Overhead requires Android Gradle Plugin 7.3 or higher, a device with API level 29 or higher,<br>and a system that is not debuggable (e.g., a Google Play enabled emulator system image).<br>Do you want to Profile with Complete Data instead?</html>"), "Center");
                return jPanel;
            }
        };
        if (dialog2.showAndGet()) {
            return this.doExecuteInternal(state2, environment);
        }
        return null;
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution, @Nullable String executorId) {
        Companion.createProfilerToolWindow(project, settings, isSwapExecution, executorId);
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution) {
        Companion.createProfilerToolWindow(project, settings, isSwapExecution);
    }

    @JvmStatic
    @JvmOverloads
    public static final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
        Companion.createProfilerToolWindow(project, settings);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/profilers/ProfilerProgramRunner$Companion;", "", "()V", "canRunByProfiler", "", "executorId", "", "androidRunConfig", "Lcom/android/tools/idea/run/AndroidRunConfigurationBase;", "createProfilerToolWindow", "", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isSwapExecution", "isAgpVersionSupported", "isDeviceSupported", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution, @Nullable String executorId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApplicationManager.getApplication().assertIsDispatchThread();
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
            if (runnerAndConfigurationSettings != null) {
                runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(false);
            }
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Android Profiler");
            if (toolWindow != null) {
                object = toolWindow;
                ToolWindow $this$createProfilerToolWindow_u24lambda_u2d0 = object;
                boolean bl = false;
                if (!$this$createProfilerToolWindow_u24lambda_u2d0.isVisible()) {
                    project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
                    $this$createProfilerToolWindow_u24lambda_u2d0.setAvailable(true);
                    $this$createProfilerToolWindow_u24lambda_u2d0.show(null);
                }
            }
            AndroidProfilerToolWindow androidProfilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project);
            if (androidProfilerToolWindow != null) {
                Object $this$createProfilerToolWindow_u24lambda_u2d1 = object = androidProfilerToolWindow;
                boolean bl = false;
                ((AndroidProfilerToolWindow)$this$createProfilerToolWindow_u24lambda_u2d1).disableAutoProfiling();
                if (!isSwapExecution) {
                    StudioProfilers studioProfilers = ((AndroidProfilerToolWindow)$this$createProfilerToolWindow_u24lambda_u2d1).getProfilers();
                    Intrinsics.checkNotNull((Object)studioProfilers);
                    studioProfilers.getSessionsManager().endCurrentSession();
                }
            }
            StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
            RunWithProfilingMetadata.Builder metadataBuilder = RunWithProfilingMetadata.newBuilder();
            Object t = StudioFlags.PROFILEABLE_BUILDS.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"PROFILEABLE_BUILDS.get()");
            if (((Boolean)t).booleanValue() && executorId != null) {
                Object object2 = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(executorId);
                if (object2 == null || (object2 = ((AbstractProfilerExecutorGroup.AbstractProfilerSetting)object2).getProfilingMode()) == null) {
                    object2 = ProfilingMode.NOT_SET;
                }
                Object profilingMode = object2;
                metadataBuilder.setProfilingMode(((ProfilingMode)((Object)profilingMode)).getAnalyticsProtoType());
            }
            featureTracker.trackRunWithProfiling(metadataBuilder.build());
        }

        public static /* synthetic */ void createProfilerToolWindow$default(Companion companion, Project project, RunnerAndConfigurationSettings runnerAndConfigurationSettings, boolean bl, String string, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            companion.createProfilerToolWindow(project, runnerAndConfigurationSettings, bl, string);
        }

        private final boolean canRunByProfiler(String executorId, AndroidRunConfigurationBase androidRunConfig) {
            if (androidRunConfig.isProfilable()) {
                Object t = StudioFlags.PROFILEABLE_BUILDS.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"PROFILEABLE_BUILDS.get()");
                if (((Boolean)t).booleanValue()) {
                    AbstractProfilerExecutorGroup<?> abstractProfilerExecutorGroup = AbstractProfilerExecutorGroup.Companion.getInstance();
                    if ((abstractProfilerExecutorGroup != null ? (AbstractProfilerExecutorGroup.AbstractProfilerSetting)abstractProfilerExecutorGroup.getRegisteredSettings(executorId) : null) != null) {
                        return true;
                    }
                }
                return Intrinsics.areEqual((Object)"Android Profiler", (Object)executorId);
            }
            return false;
        }

        private final boolean isAgpVersionSupported(Project project) {
            AgpVersion agpVersion;
            String string = GradleUtil.getLastKnownAndroidGradlePluginVersion(project);
            if (string != null) {
                String it = string;
                boolean bl = false;
                agpVersion = AgpVersion.Companion.tryParse(it);
            } else {
                agpVersion = null;
            }
            AgpVersion agpVersion2 = agpVersion;
            return agpVersion2 != null && agpVersion2.isAtLeastIncludingPreviews(7, 3, 0);
        }

        private final boolean isDeviceSupported(ExecutionEnvironment env) {
            List targetDevices;
            DeviceFutures deviceFutures;
            DeviceFutures deviceFutures2 = deviceFutures = (DeviceFutures)env.getCopyableUserData(DeviceFutures.KEY);
            List list2 = deviceFutures2 != null ? deviceFutures2.getDevices() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if (!((Collection)(targetDevices = list2)).isEmpty()) {
                AndroidDevice device2 = (AndroidDevice)targetDevices.get(0);
                return device2.getVersion().isGreaterOrEqualThan(29) && !device2.isDebuggable();
            }
            return false;
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings, boolean isSwapExecution) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            com.android.tools.idea.profilers.ProfilerProgramRunner$Companion.createProfilerToolWindow$default(this, project, settings, isSwapExecution, null, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void createProfilerToolWindow(@NotNull Project project, @Nullable RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            com.android.tools.idea.profilers.ProfilerProgramRunner$Companion.createProfilerToolWindow$default(this, project, settings, false, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProfilingMode.values().length];
            nArray[ProfilingMode.DEBUGGABLE.ordinal()] = 1;
            nArray[ProfilingMode.NOT_SET.ordinal()] = 2;
            nArray[ProfilingMode.PROFILEABLE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

