/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ExecutorIconProvider;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.DefaultExecutorGroup;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup;", "Lcom/android/tools/idea/run/profiler/AbstractProfilerExecutorGroup;", "Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$ProfilerSetting;", "Lcom/android/tools/idea/run/ExecutorIconProvider;", "()V", "createExecutorGroupWrapper", "Lcom/intellij/execution/impl/DefaultExecutorGroup$ExecutorGroupWrapper;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getActionName", "", "getContextActionId", "getDescription", "getDisabledIcon", "Ljavax/swing/Icon;", "getExecutorIcon", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Lcom/intellij/execution/Executor;", "getHelpId", "getIcon", "getId", "getRunToolbarActionText", "param", "getRunToolbarChooserText", "getStartActionText", "getToolWindowIcon", "getToolWindowId", "isApplicable", "", "Companion", "GroupWrapper", "ProfilerSetting", "intellij.android.profilersAndroid"})
public final class ProfileRunExecutorGroup
extends AbstractProfilerExecutorGroup<ProfilerSetting>
implements ExecutorIconProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Icon PROFILEABLE_ICON = StudioIcons.Shell.Toolbar.PROFILER_LOW_OVERHEAD;
    private static final Icon DEBUGGABLE_ICON = StudioIcons.Shell.Toolbar.PROFILER_DETAILED;

    public ProfileRunExecutorGroup() {
        this.registerSettings(new ProfilerSetting(ProfilingMode.PROFILEABLE));
        this.registerSettings(new ProfilerSetting(ProfilingMode.DEBUGGABLE));
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = PROFILEABLE_ICON;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PROFILEABLE_ICON");
        return icon2;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return this.getToolWindowIcon();
    }

    @NotNull
    public String getDescription() {
        return "Profile selected configuration";
    }

    @NotNull
    public String getActionName() {
        return "Profile";
    }

    @NotNull
    public String getId() {
        return "Android Profiler Group";
    }

    @NotNull
    public String getStartActionText() {
        return "Profile";
    }

    @NotNull
    public String getContextActionId() {
        return "ProfileGroupRunClass";
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    @Override
    @NotNull
    public Icon getExecutorIcon(@NotNull Project project, @NotNull Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        AndroidProfilerToolWindow androidProfilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project);
        if (androidProfilerToolWindow != null && (androidProfilerToolWindow = androidProfilerToolWindow.getProfilers()) != null) {
            AndroidProfilerToolWindow it = androidProfilerToolWindow;
            boolean bl = false;
            if (SessionsManager.isSessionAlive((Common.Session)it.getSessionsManager().getProfilingSession())) {
                Icon icon2 = ExecutionUtil.getLiveIndicator((Icon)this.getIcon());
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getLiveIndicator(icon)");
                return icon2;
            }
        }
        return this.getIcon();
    }

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return AndroidUtils.hasAndroidFacets(project);
    }

    @NotNull
    public String getRunToolbarActionText(@NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return "Profile";
    }

    @NotNull
    public String getRunToolbarChooserText() {
        return "Profile";
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon2 = StudioIcons.Shell.ToolWindows.ANDROID_PROFILER;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ANDROID_PROFILER");
        return icon2;
    }

    @NotNull
    public String getToolWindowId() {
        return "Run";
    }

    @NotNull
    protected DefaultExecutorGroup.ExecutorGroupWrapper createExecutorGroupWrapper(@NotNull ActionGroup actionGroup) {
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        return new GroupWrapper(actionGroup);
    }

    @JvmStatic
    @Nullable
    public static final ProfileRunExecutorGroup getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$ProfilerSetting;", "Lcom/android/tools/idea/run/profiler/AbstractProfilerExecutorGroup$AbstractProfilerSetting;", "profilingMode", "Lcom/android/tools/idea/run/profiler/ProfilingMode;", "(Lcom/android/tools/idea/run/profiler/ProfilingMode;)V", "actionName", "", "getActionName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "startActionText", "getStartActionText", "canRun", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "configurationName", "isApplicable", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.profilersAndroid"})
    public static final class ProfilerSetting
    extends AbstractProfilerExecutorGroup.AbstractProfilerSetting {
        @NotNull
        private final String startActionText;

        public ProfilerSetting(@NotNull ProfilingMode profilingMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilingMode), (String)"profilingMode");
            super(profilingMode);
            this.startActionText = "Profile";
        }

        @NotNull
        public String getActionName() {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                case 1: {
                    string = "Profile with low overhead";
                    break;
                }
                case 2: {
                    string = "Profile with complete data";
                    break;
                }
                default: {
                    string = "Profile";
                }
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                case 1: {
                    Icon icon3 = PROFILEABLE_ICON;
                    icon2 = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PROFILEABLE_ICON");
                    break;
                }
                case 2: {
                    Icon icon4 = DEBUGGABLE_ICON;
                    icon2 = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"DEBUGGABLE_ICON");
                    break;
                }
                default: {
                    Icon icon5 = StudioIcons.Shell.Toolbar.PROFILER;
                    icon2 = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"PROFILER");
                }
            }
            return icon2;
        }

        @NotNull
        public String getStartActionText() {
            return this.startActionText;
        }

        public boolean canRun(@NotNull RunProfile profile) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            return true;
        }

        public boolean isApplicable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return true;
        }

        @NotNull
        public String getStartActionText(@NotNull String configurationName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            switch (WhenMappings.$EnumSwitchMapping$0[this.getProfilingMode().ordinal()]) {
                case 1: {
                    string = "Profile '" + configurationName + "' with low overhead";
                    break;
                }
                case 2: {
                    string = "Profile '" + configurationName + "' with complete data";
                    break;
                }
                default: {
                    string = "Profile '" + configurationName + "'";
                }
            }
            return string;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProfilingMode.values().length];
                nArray[ProfilingMode.PROFILEABLE.ordinal()] = 1;
                nArray[ProfilingMode.DEBUGGABLE.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$GroupWrapper;", "Lcom/intellij/execution/impl/DefaultExecutorGroup$ExecutorGroupWrapper;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "(Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "groupShouldBeVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateDisabledActionPresentation", "", "eventPresentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "intellij.android.profilersAndroid"})
    private static final class GroupWrapper
    extends DefaultExecutorGroup.ExecutorGroupWrapper {
        public GroupWrapper(@NotNull ActionGroup actionGroup) {
            Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
            super(actionGroup);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean groupShouldBeVisible(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Object object = project;
            if (project == null) return false;
            AndroidProjectSystem androidProjectSystem = ProjectSystemUtil.getProjectSystem((Project)object);
            object = androidProjectSystem;
            if (androidProjectSystem == null) return false;
            boolean bl = object.supportsProfilingMode();
            boolean isProfilingModeSupported = bl;
            if (!isProfilingModeSupported) return false;
            Object t = StudioFlags.PROFILEABLE_BUILDS.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"PROFILEABLE_BUILDS.get()");
            if ((Boolean)t == false) return false;
            return true;
        }

        public void updateDisabledActionPresentation(@NotNull Presentation eventPresentation) {
            Intrinsics.checkNotNullParameter((Object)eventPresentation, (String)"eventPresentation");
            eventPresentation.setIcon(PROFILEABLE_ICON);
            eventPresentation.setText("Profile");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup$Companion;", "", "()V", "DEBUGGABLE_ICON", "Ljavax/swing/Icon;", "kotlin.jvm.PlatformType", "PROFILEABLE_ICON", "getInstance", "Lcom/android/tools/idea/profilers/ProfileRunExecutorGroup;", "intellij.android.profilersAndroid"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ProfileRunExecutorGroup getInstance() {
            Executor executor2 = ExecutorRegistry.getInstance().getExecutorById("Android Profiler Group");
            return executor2 instanceof ProfileRunExecutorGroup ? (ProfileRunExecutorGroup)executor2 : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

