/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerService;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.ToolWindowWrapperImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import icons.StudioIcons;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    public static final String ID = "Android Profiler";
    private static final String PROFILER_TOOL_WINDOW_TITLE = "Profiler";
    private static final Map<Content, AndroidProfilerToolWindow> PROJECT_PROFILER_MAP = new HashMap<Content, AndroidProfilerToolWindow>();

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow window2 = toolWindowManager.getToolWindow(AndroidProfilerToolWindowFactory.ID);
                if (window2 == null) {
                    return;
                }
                AndroidProfilerToolWindow profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project);
                if (window2.isVisible() && profilerToolWindow == null) {
                    AndroidProfilerToolWindowFactory.createContent(project, window2);
                }
            }
        });
    }

    public void init(@NotNull ToolWindow toolWindow) {
        toolWindow.setStripeTitle(PROFILER_TOOL_WINDOW_TITLE);
        toolWindow.setShowStripeButton(true);
        AndroidProfilerService.getInstance();
    }

    private static void createContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        ToolWindowWrapperImpl wrapper = new ToolWindowWrapperImpl(project, toolWindow);
        AndroidProfilerToolWindow view = new AndroidProfilerToolWindow(wrapper, project);
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content2 = contentFactory.createContent(view.getComponent(), "", false);
        Disposer.register((Disposable)project, (Disposable)view);
        toolWindow.getContentManager().addContent(content2);
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
        PROJECT_PROFILER_MAP.put(content2, view);
        Disposer.register((Disposable)content2, () -> PROJECT_PROFILER_MAP.remove(content2));
        toolWindow.show(null);
    }

    @Nullable
    public static AndroidProfilerToolWindow getProfilerToolWindow(@NotNull Project project) {
        ToolWindow window2 = ToolWindowManager.getInstance((Project)project).getToolWindow(ID);
        if (window2 == null) {
            return null;
        }
        ContentManager contentManager = window2.getContentManager();
        if (contentManager == null || contentManager.getContentCount() == 0) {
            return null;
        }
        return PROJECT_PROFILER_MAP.get(contentManager.getContent(0));
    }

    public static void removeContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow.getContentManager().getContentCount() > 0) {
            Content content2 = toolWindow.getContentManager().getContent(0);
            PROJECT_PROFILER_MAP.remove(content2);
            toolWindow.getContentManager().removeAllContents(true);
        }
    }
}

