/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.profilers.StudioLegacyAllocationTracker;
import com.android.tools.idea.profilers.commands.CpuTraceInterceptCommandHandler;
import com.android.tools.idea.profilers.commands.GcCommandHandler;
import com.android.tools.idea.profilers.commands.LegacyAllocationCommandHandler;
import com.android.tools.idea.profilers.commands.LegacyCpuTraceCommandHandler;
import com.android.tools.idea.profilers.eventpreprocessor.EnergyUsagePreprocessor;
import com.android.tools.idea.profilers.eventpreprocessor.SimpleperfPipelinePreprocessor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.transport.FailedToStartServerException;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfSampleReporter;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.application.ApplicationManager;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerService
implements TransportDeviceManager.TransportDeviceManagerListener {
    private final int LIVE_ALLOCATION_STACK_DEPTH = Integer.getInteger("profiler.alloc.stack.depth", 50);
    @NotNull
    private static final String MEMORY_PROXY_EXECUTOR_NAME = "MemoryAllocationDataFetchExecutor";

    public static AndroidProfilerService getInstance() {
        return (AndroidProfilerService)ApplicationManager.getApplication().getService(AndroidProfilerService.class);
    }

    AndroidProfilerService() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TransportDeviceManager.TOPIC, (Object)this);
    }

    @Override
    public void onPreTransportDaemonStart(@NotNull Common.Device device2) {
    }

    @Override
    public void onTransportDaemonException(@NotNull Common.Device device2, @NotNull Exception exception) {
    }

    @Override
    public void onTransportProxyCreationFail(@NotNull Common.Device device2, @NotNull Exception exception) {
    }

    @Override
    public void onStartTransportDaemonServerFail(@NotNull Common.Device device2, @NotNull FailedToStartServerException exception) {
    }

    @Override
    public void customizeProxyService(@NotNull TransportProxy proxy) {
        TransportProxy.ProxyCommandHandler cpuTraceHandler;
        IDevice device2 = proxy.getDevice();
        proxy.registerProxyCommandHandler(Commands.Command.CommandType.GC, new GcCommandHandler(device2));
        if (device2.getVersion().getFeatureLevel() < 26) {
            LegacyAllocationCommandHandler trackAllocationHandler = new LegacyAllocationCommandHandler(device2, proxy.getEventQueue(), proxy.getBytesCache(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(MEMORY_PROXY_EXECUTOR_NAME).build()), StudioLegacyAllocationTracker::new);
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.START_ALLOC_TRACKING, trackAllocationHandler);
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.STOP_ALLOC_TRACKING, trackAllocationHandler);
        }
        if (device2.getVersion().getFeatureLevel() < 26) {
            cpuTraceHandler = new LegacyCpuTraceCommandHandler(device2, TransportServiceGrpc.newBlockingStub((Channel)proxy.getTransportChannel()), proxy.getEventQueue(), proxy.getBytesCache());
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.START_CPU_TRACE, cpuTraceHandler);
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.STOP_CPU_TRACE, cpuTraceHandler);
        } else if (((Boolean)StudioFlags.PERFETTO_SDK_TRACING.get()).booleanValue() && device2.getVersion().getFeatureLevel() >= 30) {
            cpuTraceHandler = new CpuTraceInterceptCommandHandler(device2, TransportServiceGrpc.newBlockingStub((Channel)proxy.getTransportChannel()));
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.START_CPU_TRACE, cpuTraceHandler);
        }
        if (((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()) {
            proxy.registerEventPreprocessor(new EnergyUsagePreprocessor(TransportService.getInstance().getLogService()));
        }
        SimpleperfPipelinePreprocessor traceProcessor = new SimpleperfPipelinePreprocessor((TracePreProcessor)new SimpleperfSampleReporter(AndroidStudioUsageTracker.deviceToDeviceInfo(device2)));
        proxy.registerEventPreprocessor(traceProcessor);
        proxy.registerDataPreprocessor(traceProcessor);
    }

    @Override
    public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder configBuilder) {
        configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()).setProfilerCustomEventVisualization(((Boolean)StudioFlags.PROFILER_CUSTOM_EVENT_VISUALIZATION.get()).booleanValue())).setCpu(Transport.DaemonConfig.CpuConfig.newBuilder().setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC).setUsePerfetto(true));
    }

    @Override
    public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder configBuilder, @Nullable AndroidRunConfigurationBase runConfig) {
        int liveAllocationSamplingRate = BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
        configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()).setProfilerCustomEventVisualization(((Boolean)StudioFlags.PROFILER_CUSTOM_EVENT_VISUALIZATION.get()).booleanValue()).setProfilerKeyboardEvent(((Boolean)StudioFlags.PROFILER_KEYBOARD_EVENT.get()).booleanValue())).setMem(Agent.AgentConfig.MemoryConfig.newBuilder().setMaxStackDepth(this.LIVE_ALLOCATION_STACK_DEPTH).setTrackGlobalJniRefs(true).setSamplingRate(Memory.MemoryAllocSamplingData.newBuilder().setSamplingNumInterval(liveAllocationSamplingRate).build()).build()).setCpuApiTracingEnabled(true);
        if (runConfig != null && runConfig.getProfilerState().isNativeMemoryStartupProfilingEnabled()) {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.ON_COMMAND);
            configBuilder.setAttachCommand(Commands.Command.CommandType.STOP_NATIVE_HEAP_SAMPLE);
        } else if (runConfig != null && runConfig.getProfilerState().isCpuStartupProfilingEnabled()) {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.ON_COMMAND);
            configBuilder.setAttachCommand(Commands.Command.CommandType.STOP_CPU_TRACE);
        } else {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.INSTANT);
        }
    }
}

