/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.core;

import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.ObservableObject;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.google.common.base.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectProperty<T>
extends AbstractProperty<T>
implements ObservableObject<T> {
    public static <T> ObjectProperty<T> wrap(@NotNull OptionalProperty<T> optionalProperty) {
        return new OptionalWrapper<T>(optionalProperty, null);
    }

    public static <T> ObjectProperty<T> wrap(@NotNull OptionalProperty<T> optionalProperty, @NotNull String id2) {
        return new OptionalWrapper<T>(optionalProperty, id2);
    }

    private static final class OptionalWrapper<U>
    extends ObjectProperty<U>
    implements InvalidationListener {
        @NotNull
        private final OptionalProperty<U> myOptionalProperty;
        @Nullable
        private String myId;

        OptionalWrapper(@NotNull OptionalProperty<U> optionalProperty, @Nullable String id2) {
            this.myOptionalProperty = optionalProperty;
            this.myId = id2;
            this.myOptionalProperty.addWeakListener(this);
        }

        @Override
        protected void setDirectly(@NotNull U value2) {
            this.myOptionalProperty.setValue(value2);
        }

        @Override
        @NotNull
        public U get() {
            U value2 = this.myOptionalProperty.getValueOrNull();
            if (value2 != null) {
                return value2;
            }
            throw new IllegalStateException("Wrapped optional property " + (String)(this.myId == null ? "" : this.myId + " ") + "doesn't contain a value");
        }

        @Override
        public void onInvalidated() {
            this.notifyInvalidated();
        }

        @Override
        protected boolean isValueEqual(@Nullable U value2) {
            return Objects.equal(this.myOptionalProperty.getValueOrNull(), value2);
        }
    }
}

