/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.BatchInvoker;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BindingsManager {
    private final List<OneWayBinding<?>> myOneWayBindings = new ArrayList();
    private final List<TwoWayBinding<?>> myTwoWayBindings = new ArrayList();
    private final BatchInvoker myInvoker;

    public BindingsManager() {
        this.myInvoker = new BatchInvoker();
    }

    public BindingsManager(@NotNull BatchInvoker.Strategy invokeStrategy) {
        this.myInvoker = new BatchInvoker(invokeStrategy);
    }

    public <T> void bind(@NotNull SettableValue<T> dest, @NotNull ObservableValue<T> src) {
        this.bind(dest, src, ObservableBool.TRUE);
    }

    public <T> void bind(@NotNull SettableValue<T> dest, @NotNull ObservableValue<T> src, @NotNull ObservableValue<Boolean> enabled) {
        this.release(dest);
        this.myOneWayBindings.add(new OneWayBinding<T>(dest, src, enabled));
    }

    public <T> void bindTwoWay(@NotNull SettableValue<T> first, @NotNull SettableValue<T> second) {
        this.releaseTwoWay(first, second);
        this.myTwoWayBindings.add(new TwoWayBinding<T>(first, second));
    }

    public void release(@NotNull SettableValue<?> dest) {
        Iterator<OneWayBinding<?>> i = this.myOneWayBindings.iterator();
        while (i.hasNext()) {
            OneWayBinding<?> binding = i.next();
            if (binding.myDest != dest) continue;
            binding.dispose();
            i.remove();
            return;
        }
    }

    public <T> void releaseTwoWay(@NotNull SettableValue<T> first, @NotNull SettableValue<T> second) {
        Iterator<TwoWayBinding<?>> i = this.myTwoWayBindings.iterator();
        while (i.hasNext()) {
            TwoWayBinding<?> binding = i.next();
            if (binding.myLhs != first || binding.myRhs != second) continue;
            binding.dispose();
            i.remove();
            return;
        }
    }

    public <T> void releaseTwoWay(@NotNull SettableValue<T> value2) {
        Iterator<TwoWayBinding<?>> i = this.myTwoWayBindings.iterator();
        while (i.hasNext()) {
            TwoWayBinding<?> binding = i.next();
            if (binding.myLhs != value2 && binding.myRhs != value2) continue;
            binding.dispose();
            i.remove();
        }
    }

    public void releaseAll() {
        for (OneWayBinding<?> oneWayBinding : this.myOneWayBindings) {
            oneWayBinding.dispose();
        }
        this.myOneWayBindings.clear();
        for (TwoWayBinding twoWayBinding : this.myTwoWayBindings) {
            twoWayBinding.dispose();
        }
        this.myTwoWayBindings.clear();
    }

    private static final class DestUpdater<T>
    implements Runnable {
        private final SettableValue<T> myDest;
        private final ObservableValue<T> mySrc;

        public DestUpdater(SettableValue<T> dest, ObservableValue<T> src) {
            this.myDest = dest;
            this.mySrc = src;
        }

        @Override
        public void run() {
            this.myDest.set(this.mySrc.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DestUpdater that = (DestUpdater)o;
            return Objects.equal(this.myDest, that.myDest) && Objects.equal(this.mySrc, that.mySrc);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myDest, this.mySrc});
        }
    }

    private final class TwoWayBinding<T> {
        private final SettableValue<T> myLhs;
        private final SettableValue<T> myRhs;
        private final InvalidationListener myLeftChangedListener;
        private final InvalidationListener myRightChangedListener;

        public TwoWayBinding(SettableValue<T> lhs, SettableValue<T> rhs) {
            this.myLhs = lhs;
            this.myRhs = rhs;
            this.myLeftChangedListener = () -> BindingsManager.this.myInvoker.enqueue(new DestUpdater<T>(this.myRhs, this.myLhs));
            this.myRightChangedListener = () -> BindingsManager.this.myInvoker.enqueue(new DestUpdater<T>(this.myLhs, this.myRhs));
            this.myLhs.addListener(this.myLeftChangedListener);
            this.myRhs.addListener(this.myRightChangedListener);
            this.myRightChangedListener.onInvalidated();
        }

        public void dispose() {
            this.myLhs.removeListener(this.myLeftChangedListener);
            this.myRhs.removeListener(this.myRightChangedListener);
        }
    }

    private final class OneWayBinding<T>
    implements InvalidationListener {
        private final SettableValue<T> myDest;
        private final ObservableValue<T> mySrc;
        private final ObservableValue<Boolean> myEnabled;

        @Override
        public void onInvalidated() {
            if (this.myEnabled.get().booleanValue()) {
                BindingsManager.this.myInvoker.enqueue(new DestUpdater<T>(this.myDest, this.mySrc));
            }
        }

        public OneWayBinding(SettableValue<T> dest, ObservableValue<T> src, ObservableValue<Boolean> enabled) {
            this.myDest = dest;
            this.mySrc = src;
            this.myEnabled = enabled;
            this.mySrc.addListener(this);
            this.myEnabled.addListener(this);
            this.onInvalidated();
        }

        public void dispose() {
            this.mySrc.removeListener(this);
            this.myEnabled.removeListener(this);
        }
    }
}

