/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.GradleVersionCatalogDetector;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.npw.project.SourceProviderAdapter;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u00a8\u0006\u0011"}, d2={"determineAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "project", "Lcom/intellij/openapi/project/Project;", "isNewProject", "", "determineVersionCatalogUse", "getContainingModule", "Lcom/intellij/openapi/module/Module;", "file", "Ljava/io/File;", "setGradleWrapperExecutable", "", "projectRoot", "getSourceProvider", "Lcom/android/tools/idea/npw/project/SourceProviderAdapter;", "Lcom/android/tools/idea/projectsystem/NamedModuleTemplate;", "intellij.android.newProjectWizard"})
@JvmName(name="AndroidGradleModuleUtils")
public final class AndroidGradleModuleUtils {
    @NotNull
    public static final SourceProviderAdapter getSourceProvider(@NotNull NamedModuleTemplate $this$getSourceProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$getSourceProvider, (String)"<this>");
        return new SourceProviderAdapter($this$getSourceProvider.getName(), $this$getSourceProvider.getPaths());
    }

    @Nullable
    public static final Module getContainingModule(@Nullable File file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.isDisposed()) {
            return null;
        }
        File file3 = file2;
        Intrinsics.checkNotNull((Object)file3);
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file3, (boolean)false);
        return vFile == null || vFile.isDirectory() ? null : ProjectFileIndex.getInstance((Project)project).getModuleForFile(vFile, false);
    }

    public static final void setGradleWrapperExecutable(@NotNull File projectRoot) throws IOException {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        if (!SystemInfo.isUnix) {
            return;
        }
        File gradlewFile = new File(projectRoot, "gradlew");
        if (!gradlewFile.isFile()) {
            throw new IOException("Could not find gradle wrapper. Command line builds may not work properly.");
        }
        FileUtil.setExecutable((File)gradlewFile);
    }

    @Slow
    @NotNull
    public static final AgpVersion determineAgpVersion(@NotNull Project project, boolean isNewProject) {
        AndroidPluginInfo androidPluginInfo;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = LatestKnownPluginVersionProvider.INSTANCE.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
        AgpVersion defaultAgpVersion = AgpVersion.Companion.parse(string);
        if (isNewProject) {
            return defaultAgpVersion;
        }
        AgpVersion versionInUse = GradleProjectSystemUtil.getAndroidGradleModelVersionInUse(project);
        if (versionInUse != null) {
            return versionInUse;
        }
        AndroidPluginInfo androidPluginInfo2 = androidPluginInfo = AndroidPluginInfo.findFromBuildFiles(project);
        Object object = androidPluginInfo2 != null ? androidPluginInfo2.getPluginVersion() : null;
        if (object == null) {
            object = defaultAgpVersion;
        }
        return object;
    }

    @Slow
    public static final boolean determineVersionCatalogUse(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradleVersionCatalogDetector.Companion.getInstance(project).isVersionCatalogProject();
    }
}

