/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module.recipes.macrobenchmarkModule;

import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.BuildTypeModel;
import com.android.tools.idea.gradle.dsl.api.android.SigningConfigModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.ext.SigningConfigPropertyModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.npw.module.recipes.GitignoreKt;
import com.android.tools.idea.npw.module.recipes.KotlinMacrosKt;
import com.android.tools.idea.npw.module.recipes.macrobenchmarkModule.AppAndroidManifestKt;
import com.android.tools.idea.npw.module.recipes.macrobenchmarkModule.BuildGradleKt;
import com.android.tools.idea.npw.module.recipes.macrobenchmarkModule.src.main.AndroidManifestXmlKt;
import com.android.tools.idea.npw.module.recipes.macrobenchmarkModule.src.main.ExampleMacrobenchmarkJavaKt;
import com.android.tools.idea.npw.module.recipes.macrobenchmarkModule.src.main.ExampleMacrobenchmarkKtKt;
import com.android.tools.idea.templates.recipe.DefaultRecipeExecutor;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.android.tools.idea.wizard.template.ApiTemplateData;
import com.android.tools.idea.wizard.template.ApiVersion;
import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.ModuleTemplateData;
import com.android.tools.idea.wizard.template.ProjectTemplateData;
import com.android.tools.idea.wizard.template.RecipeExecutor;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0007*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\"\u0010\r\u001a\u00020\u0007*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"exampleBenchmarkName", "", "minRev", "generateUniqueBenchmarkBuildTypeName", "targetModule", "Lcom/intellij/openapi/module/Module;", "addBuildType", "", "name", "debuggable", "", "addProfileableToTargetManifest", "Lcom/android/tools/idea/wizard/template/RecipeExecutor;", "generateMacrobenchmarkModule", "moduleData", "Lcom/android/tools/idea/wizard/template/ModuleTemplateData;", "useGradleKts", "intellij.android.newProjectWizard"})
public final class MacrobenchmarkModuleRecipeKt {
    @NotNull
    private static final String minRev = "1.1.0-beta04";
    @NotNull
    private static final String exampleBenchmarkName = "ExampleStartupBenchmark";

    public static final void generateMacrobenchmarkModule(@NotNull RecipeExecutor $this$generateMacrobenchmarkModule, @NotNull ModuleTemplateData moduleData, boolean useGradleKts, @NotNull Module targetModule) {
        Object object;
        String benchmarkBuildTypeName;
        Language language;
        ApiVersion minApi;
        ApiVersion targetApi;
        ApiVersion buildApi;
        File moduleOut;
        String packageName2;
        File srcOut;
        ProjectTemplateData projectData;
        block7: {
            block6: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)$this$generateMacrobenchmarkModule, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
                Intrinsics.checkNotNullParameter((Object)targetModule, (String)"targetModule");
                projectData = moduleData.getProjectTemplateData();
                srcOut = moduleData.getSrcDir();
                packageName2 = moduleData.getPackageName();
                moduleOut = moduleData.getRootDir();
                ApiTemplateData apiTemplateData = moduleData.getApis();
                buildApi = apiTemplateData.component1();
                targetApi = apiTemplateData.component2();
                minApi = apiTemplateData.component3();
                language = projectData.getLanguage();
                benchmarkBuildTypeName = "benchmark";
                if ($this$generateMacrobenchmarkModule instanceof DefaultRecipeExecutor) {
                    benchmarkBuildTypeName = MacrobenchmarkModuleRecipeKt.generateUniqueBenchmarkBuildTypeName(targetModule);
                    MacrobenchmarkModuleRecipeKt.addBuildType(targetModule, benchmarkBuildTypeName, false);
                    MacrobenchmarkModuleRecipeKt.addProfileableToTargetManifest($this$generateMacrobenchmarkModule, targetModule);
                }
                if ((object = AndroidModel.get(targetModule)) == null || (object = object.getApplicationId()) == null) break block6;
                Object it = object2 = object;
                boolean bl = false;
                object = !Intrinsics.areEqual((Object)it, (Object)"uninitialized.application.id") ? object2 : null;
                if (object != null) break block7;
            }
            object = "com.example.application";
        }
        Object targetApplicationId = object;
        $this$generateMacrobenchmarkModule.addIncludeToSettings(moduleData.getName());
        String bg = BuildGradleKt.buildGradle(packageName2, buildApi.getApiString(), minApi.getApiString(), targetApi.getApiString(), language, projectData.getGradlePluginVersion(), useGradleKts, targetModule, benchmarkBuildTypeName);
        String buildFile = useGradleKts ? "build.gradle.kts" : "build.gradle";
        $this$generateMacrobenchmarkModule.save(bg, FilesKt.resolve((File)moduleOut, (String)buildFile));
        RecipeExecutor.applyPlugin$default((RecipeExecutor)$this$generateMacrobenchmarkModule, (String)"com.android.test", (String)projectData.getGradlePluginVersion(), null, (int)4, null);
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$generateMacrobenchmarkModule, (String)"androidx.test.ext:junit:+", (String)"implementation", null, null, (boolean)false, (int)28, null);
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$generateMacrobenchmarkModule, (String)"androidx.test.espresso:espresso-core:3.+", (String)"implementation", null, null, (boolean)false, (int)28, null);
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$generateMacrobenchmarkModule, (String)"androidx.test.uiautomator:uiautomator:2.+", (String)"implementation", null, null, (boolean)false, (int)28, null);
        RecipeExecutor.addDependency$default((RecipeExecutor)$this$generateMacrobenchmarkModule, (String)"androidx.benchmark:benchmark-macro-junit4:+", (String)"implementation", (String)minRev, null, (boolean)false, (int)24, null);
        $this$generateMacrobenchmarkModule.save(AndroidManifestXmlKt.androidManifestXml((String)targetApplicationId), FilesKt.resolve((File)moduleOut, (String)"src/main/AndroidManifest.xml"));
        $this$generateMacrobenchmarkModule.save(GitignoreKt.gitignore(), FilesKt.resolve((File)moduleOut, (String)".gitignore"));
        if (language == Language.Kotlin) {
            $this$generateMacrobenchmarkModule.save(ExampleMacrobenchmarkKtKt.exampleMacrobenchmarkKt(exampleBenchmarkName, packageName2, (String)targetApplicationId), FilesKt.resolve((File)srcOut, (String)"ExampleStartupBenchmark.kt"));
            $this$generateMacrobenchmarkModule.open(FilesKt.resolve((File)srcOut, (String)"ExampleStartupBenchmark.kt"));
        } else {
            $this$generateMacrobenchmarkModule.save(ExampleMacrobenchmarkJavaKt.exampleMacrobenchmarkJava(exampleBenchmarkName, packageName2, (String)targetApplicationId), FilesKt.resolve((File)srcOut, (String)"ExampleStartupBenchmark.java"));
            $this$generateMacrobenchmarkModule.open(FilesKt.resolve((File)srcOut, (String)"ExampleStartupBenchmark.java"));
        }
        KotlinMacrosKt.addKotlinIfNeeded($this$generateMacrobenchmarkModule, projectData, targetApi.getApi(), true);
    }

    private static final String generateUniqueBenchmarkBuildTypeName(Module targetModule) {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog(targetModule.getProject());
        if (projectBuildModel2 == null) {
            return "benchmark";
        }
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        GradleDslModel gradleDslModel = projectBuildModel3.getModuleBuildModel(targetModule);
        if (gradleDslModel == null || (gradleDslModel = gradleDslModel.android()) == null) {
            return "benchmark";
        }
        GradleDslModel androidBuildModel = gradleDslModel;
        Integer benchmarkBuildTypeSuffix = null;
        String benchmarkBuildTypeName = null;
        benchmarkBuildTypeName = "benchmark" + "";
        while (true) {
            boolean bl;
            block6: {
                List<SigningConfigModel> list2 = androidBuildModel.signingConfigs();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"androidBuildModel.signingConfigs()");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SigningConfigModel it = (SigningConfigModel)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)benchmarkBuildTypeName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) break;
            Integer n = benchmarkBuildTypeSuffix;
            benchmarkBuildTypeSuffix = n != null ? Integer.valueOf(n + 1) : Integer.valueOf(1);
            benchmarkBuildTypeName = "benchmark" + benchmarkBuildTypeSuffix;
        }
        return benchmarkBuildTypeName;
    }

    private static final void addProfileableToTargetManifest(RecipeExecutor $this$addProfileableToTargetManifest, Module targetModule) {
        AndroidModel androidModel = AndroidModel.get(targetModule);
        if (androidModel == null) {
            return;
        }
        AndroidModel androidModel2 = androidModel;
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)targetModule);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet androidFacet2 = androidFacet;
        String string = AndroidRootUtil.getModuleDirPath(targetModule);
        if (string == null) {
            return;
        }
        String targetModuleRootDir = string;
        File targetModuleManifest = new File(targetModuleRootDir, androidFacet2.getProperties().MANIFEST_FILE_RELATIVE_PATH);
        if (!targetModuleManifest.exists()) {
            return;
        }
        boolean needsTargetFlag = !androidModel2.getMinSdkVersion().isGreaterOrEqualThan(29);
        $this$addProfileableToTargetManifest.mergeXml(AppAndroidManifestKt.appAndroidManifest(needsTargetFlag), targetModuleManifest);
    }

    private static final void addBuildType(Module $this$addBuildType, String name, boolean debuggable2) {
        boolean hasReleaseFallback;
        BuildTypeModel benchmarkBuildType;
        ProjectBuildModel projectBuildModel2;
        block12: {
            boolean bl;
            List<GradlePropertyModel> existingMatchingFallbacks;
            SigningConfigModel debugSignConfigBuildModel;
            Object v4;
            block11: {
                ProjectBuildModel projectBuildModel3 = ProjectBuildModel.getOrLog($this$addBuildType.getProject());
                if (projectBuildModel3 == null) {
                    return;
                }
                projectBuildModel2 = projectBuildModel3;
                GradleDslModel gradleDslModel = projectBuildModel2.getModuleBuildModel($this$addBuildType);
                if (gradleDslModel == null || (gradleDslModel = gradleDslModel.android()) == null) {
                    return;
                }
                GradleDslModel androidBuildModel = gradleDslModel;
                BuildTypeModel buildTypeModel = androidBuildModel.addBuildType(name);
                Intrinsics.checkNotNullExpressionValue((Object)buildTypeModel, (String)"androidBuildModel.addBuildType(name)");
                benchmarkBuildType = buildTypeModel;
                List<SigningConfigModel> list2 = androidBuildModel.signingConfigs();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"androidBuildModel.signingConfigs()");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SigningConfigModel it = (SigningConfigModel)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)"debug")) continue;
                    v4 = element$iv;
                    break block11;
                }
                v4 = null;
            }
            SigningConfigModel signingConfigModel = debugSignConfigBuildModel = (SigningConfigModel)v4;
            if (signingConfigModel != null) {
                SigningConfigModel it = signingConfigModel;
                boolean bl3 = false;
                SigningConfigPropertyModel signingConfigPropertyModel = benchmarkBuildType.signingConfig();
                Intrinsics.checkNotNullExpressionValue((Object)signingConfigPropertyModel, (String)"benchmarkBuildType.signingConfig()");
                SigningConfigPropertyModel benchmarkSigningConfigModel = signingConfigPropertyModel;
                benchmarkSigningConfigModel.setValue(new ReferenceTo(debugSignConfigBuildModel, benchmarkSigningConfigModel));
            }
            List<GradlePropertyModel> list3 = existingMatchingFallbacks = benchmarkBuildType.matchingFallbacks().toList();
            if (list3 != null) {
                Iterable $this$any$iv = list3;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GradlePropertyModel it = (GradlePropertyModel)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.valueAsString(), (Object)"release")) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            } else {
                bl = hasReleaseFallback = false;
            }
        }
        if (!hasReleaseFallback) {
            GradlePropertyModel fallback;
            GradlePropertyModel gradlePropertyModel = fallback = benchmarkBuildType.matchingFallbacks().addListValue();
            if (gradlePropertyModel != null) {
                gradlePropertyModel.setValue("release");
            }
        }
        benchmarkBuildType.debuggable().setValue(debuggable2);
        projectBuildModel2.applyChanges();
    }
}

