/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.npw.importing.ImportUIUtil;
import com.android.tools.idea.npw.importing.ModuleImportSettings;
import com.android.tools.idea.npw.importing.ModuleImportSettingsPane;
import com.android.tools.idea.npw.importing.ModuleListModel;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import org.jetbrains.annotations.Nullable;

public final class ModulesTable
extends JBPanel
implements Scrollable {
    public static final String PROPERTY_SELECTED_MODULES = "selectedModules";
    private final Map<VirtualFile, ModuleImportSettingsPane> panes = Maps.newHashMap();
    private ModuleImportSettings myPrimaryModuleSettings;
    private JComponent myDependenciesLabel;
    private ModuleListModel myListModel;
    private boolean isRefreshing = false;

    private static GridConstraints createGridConstraints(int row2, boolean growVertically) {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(row2);
        constraints.setFill(1);
        constraints.setHSizePolicy(4);
        if (growVertically) {
            constraints.setVSizePolicy(6);
        }
        return constraints;
    }

    @Nullable
    private ModuleImportSettingsPane createPanel(final ModuleToImport module2, boolean isFirst) {
        VirtualFile location2 = module2.location;
        if (location2 != null) {
            ModuleImportSettingsPane pane = this.panes.get(location2);
            if (pane != null) {
                return pane;
            }
            final ModuleImportSettingsPane newPane = new ModuleImportSettingsPane();
            if (!isFirst) {
                newPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JBColor.border()));
            }
            newPane.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModulesTable.this.updateModule(newPane, module2);
                }
            });
            this.panes.put(location2, newPane);
            return newPane;
        }
        return null;
    }

    private void refreshModulesList() {
        this.removeAll();
        Collection<ModuleImportSettingsPane> panes = this.updateModuleEditors();
        if (!panes.isEmpty()) {
            this.setLayout((LayoutManager)new GridLayoutManager(panes.size(), 1));
            int row2 = 0;
            for (ModuleImportSettingsPane pane : panes) {
                this.add(pane, ModulesTable.createGridConstraints(row2++, false));
            }
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ModuleImportSettingsPane> updateModuleEditors() {
        this.isRefreshing = true;
        try {
            ModuleToImport primary = this.myListModel.getPrimary();
            this.setModuleNameVisibility(primary != null, this.myListModel.getAllModules().size() > 1);
            if (primary != null) {
                this.apply(this.myPrimaryModuleSettings, primary);
            }
            boolean isFirst = true;
            LinkedList editors = Lists.newLinkedList();
            TreeSet allModules = Sets.newTreeSet((Comparator)new ModuleComparator(this.myListModel.getCurrentPath()));
            Iterables.addAll((Collection)allModules, (Iterable)Iterables.filter(this.myListModel.getAllModules(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)this.myListModel.getPrimary()))));
            for (ModuleToImport module2 : allModules) {
                ModuleImportSettingsPane pane = this.createModuleSetupPanel(module2, isFirst);
                if (pane == null) continue;
                isFirst = false;
                editors.add(pane);
            }
            LinkedList linkedList = editors;
            return linkedList;
        }
        finally {
            this.isRefreshing = false;
        }
    }

    private void updateModule(ModuleImportSettings pane, @Nullable ModuleToImport module2) {
        if (!this.isRefreshing && module2 != null) {
            boolean isSelected = pane.isModuleSelected();
            if (this.myListModel.isSelected(module2) != isSelected) {
                this.myListModel.setSelected(module2, isSelected);
            }
            String moduleName2 = pane.getModuleName();
            if (!Objects.equal((Object)this.myListModel.getModuleName(module2), (Object)moduleName2)) {
                this.myListModel.setModuleName(module2, moduleName2);
            }
            this.updateModuleEditors();
        }
        this.firePropertyChange(PROPERTY_SELECTED_MODULES, null, null);
    }

    private void setModuleNameVisibility(boolean visible, boolean hasMoreDependencies) {
        this.myPrimaryModuleSettings.setVisible(visible);
        this.myDependenciesLabel.setVisible(visible && hasMoreDependencies);
    }

    @Nullable
    private ModuleImportSettingsPane createModuleSetupPanel(ModuleToImport module2, boolean isFirst) {
        ModuleImportSettingsPane pane = this.createPanel(module2, isFirst);
        if (pane != null) {
            this.apply(pane, module2);
        }
        return pane;
    }

    private void apply(ModuleImportSettings pane, ModuleToImport module2) {
        pane.setModuleName(this.myListModel.getModuleName(module2));
        pane.setModuleSourcePath(ImportUIUtil.relativeTo(module2.location, this.myListModel.getCurrentPath()));
        pane.setModuleSelected(this.myListModel.isSelected(module2));
        pane.setCanToggleModuleSelection(this.myListModel.canToggleModuleSelection(module2));
        pane.setCanRenameModule(this.myListModel.canRename(module2));
        pane.setValidationStatus(this.myListModel.getStatusSeverity(module2), this.myListModel.getStatusDescription(module2));
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 && this.getComponentCount() >= 2 ? this.getComponent(1).getHeight() + 5 : 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Set<ModuleToImport> getSelectedModules() {
        return this.myListModel.getSelectedModules();
    }

    public Map<String, VirtualFile> getSelectedModulesMap() {
        Set<ModuleToImport> modules2 = this.myListModel.getSelectedModules();
        if (modules2.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap selectedModules = Maps.newHashMap();
        for (ModuleToImport module2 : modules2) {
            selectedModules.put(this.myListModel.getModuleName(module2), module2.location);
        }
        return selectedModules;
    }

    public void setModules(@Nullable Project project, @Nullable VirtualFile currentPath, @Nullable Iterable<ModuleToImport> modules2) {
        if (this.myListModel == null) {
            this.myListModel = new ModuleListModel(project);
        }
        this.myListModel.setContents(currentPath, (Iterable<ModuleToImport>)(modules2 == null ? ImmutableSet.of() : modules2));
        this.refreshModulesList();
    }

    public void bindPrimaryModuleEntryComponents(final ModuleImportSettings primaryModulePane, JComponent shownIfThereAreDependencies) {
        this.myPrimaryModuleSettings = primaryModulePane;
        this.myDependenciesLabel = shownIfThereAreDependencies;
        this.setModuleNameVisibility(false, false);
        primaryModulePane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModulesTable.this.updateModule(primaryModulePane, ModulesTable.this.myListModel.getPrimary());
            }
        });
    }

    public boolean canImport() {
        for (ModuleToImport moduleToImport : this.myListModel.getSelectedModules()) {
            if (!Objects.equal((Object)this.myListModel.getStatusSeverity(moduleToImport), (Object)MessageType.ERROR)) continue;
            return false;
        }
        return true;
    }

    public String getModuleName(ModuleToImport module2) {
        return this.myListModel.getModuleName(module2);
    }

    private static class ModuleComparator
    implements Comparator<ModuleToImport> {
        @Nullable
        private final VirtualFile myImportPath;

        public ModuleComparator(@Nullable VirtualFile importPath) {
            this.myImportPath = importPath;
        }

        @Override
        public int compare(ModuleToImport o1, ModuleToImport o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            VirtualFile l1 = o1.location;
            VirtualFile l2 = o2.location;
            Collator collator = Collator.getInstance();
            int namesComparison = collator.compare(o1.name, o2.name);
            if (l1 == null) {
                return l2 == null ? namesComparison : 1;
            }
            if (l2 == null) {
                return -1;
            }
            if (Objects.equal((Object)l1, (Object)this.myImportPath)) {
                return Objects.equal((Object)l2, (Object)this.myImportPath) ? namesComparison : -1;
            }
            if (Objects.equal((Object)l2, (Object)this.myImportPath)) {
                return 1;
            }
            int pathComparison = collator.compare(l1.getPath(), l2.getPath());
            return pathComparison == 0 ? namesComparison : pathComparison;
        }
    }
}

