/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.util.FormatUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleListModel {
    @Nullable
    private final Project myProject;
    private Map<ModuleToImport, ModuleValidationState> myModules;
    private Multimap<ModuleToImport, ModuleToImport> myRequiredModules;
    @Nullable
    private VirtualFile mySelectedDirectory;
    private Map<ModuleToImport, String> myNameOverrides = Maps.newHashMap();
    private ModuleToImport myPrimaryModule;
    private Map<ModuleToImport, Boolean> myExplicitSelection = Maps.newHashMap();

    public ModuleListModel(@Nullable Project project) {
        this.myProject = project;
    }

    @Nullable
    private static ModuleToImport findPrimaryModule(@Nullable VirtualFile directory, @NotNull Iterable<ModuleToImport> modules2) {
        if (directory == null) {
            return null;
        }
        for (ModuleToImport module2 : modules2) {
            if (!Objects.equal((Object)module2.location, (Object)directory)) continue;
            return module2;
        }
        return null;
    }

    private static boolean isValidModuleName(String moduleName2) {
        if (StringUtil.isEmpty((String)moduleName2)) {
            return false;
        }
        int previousSegmentStart = 0;
        int segmentSeparator = moduleName2.indexOf(58, previousSegmentStart);
        while (segmentSeparator >= 0) {
            if (!ModuleListModel.isValidPathSegment(moduleName2, previousSegmentStart, segmentSeparator)) {
                return false;
            }
            previousSegmentStart = segmentSeparator + 1;
            segmentSeparator = moduleName2.indexOf(58, previousSegmentStart);
        }
        return ModuleListModel.isValidPathSegment(moduleName2, previousSegmentStart, moduleName2.length());
    }

    private static boolean isValidPathSegment(String string, int segmentStart, int segmentEnd) {
        if (segmentEnd == segmentStart) {
            return segmentStart == 0;
        }
        String segment = string.substring(segmentStart, segmentEnd);
        return !StringUtil.isEmpty((String)segment) && GradleUtil.isValidGradlePath(segment) < 0;
    }

    private static String getNameErrorMessage(String moduleName2) {
        if (StringUtil.isEmptyOrSpaces((String)moduleName2)) {
            return "Module name is empty";
        }
        return "Module name is not valid";
    }

    private Multimap<ModuleToImport, ModuleToImport> computeRequiredModules(Set<ModuleToImport> modules2) {
        HashMap namesToModules = Maps.newHashMapWithExpectedSize((int)modules2.size());
        for (ModuleToImport module2 : modules2) {
            namesToModules.put(module2.name, module2);
        }
        LinkedListMultimap requiredModules = LinkedListMultimap.create();
        LinkedList queue = Lists.newLinkedList();
        for (ModuleToImport module3 : modules2) {
            if (!Objects.equal((Object)module3, (Object)this.myPrimaryModule) && this.isUnselected(module3, false)) continue;
            queue.add(module3);
        }
        while (!queue.isEmpty()) {
            ModuleToImport moduleToImport = (ModuleToImport)queue.remove();
            for (ModuleToImport dep : Iterables.transform(moduleToImport.getDependencies(), (Function)Functions.forMap((Map)namesToModules, null))) {
                if (dep == null) continue;
                if (!requiredModules.containsKey((Object)dep)) {
                    queue.add(dep);
                }
                requiredModules.put((Object)dep, (Object)moduleToImport);
            }
        }
        return requiredModules;
    }

    private boolean isUnselected(ModuleToImport module2, boolean isSelected) {
        if (module2.location == null) {
            return true;
        }
        if (Objects.equal((Object)this.myPrimaryModule, (Object)module2)) {
            return false;
        }
        if (this.myModules.get(module2) == ModuleValidationState.ALREADY_EXISTS) {
            return !Objects.equal((Object)true, (Object)this.myExplicitSelection.get(module2));
        }
        return !isSelected && this.isExplicitlyUnselected(module2);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath) {
        if (project == null) {
            return false;
        }
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            GradleProjectPath moduleGradlePath = GradleProjectPathKt.getGradleProjectPath(module2);
            if (moduleGradlePath == null || !gradlePath.equals(moduleGradlePath.getPath())) continue;
            return true;
        }
        File location2 = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
        if (location2.isFile()) {
            return true;
        }
        if (location2.isDirectory()) {
            File[] children = location2.listFiles();
            return children == null || children.length > 0;
        }
        return false;
    }

    private ModuleValidationState validateModule(ModuleToImport module2) {
        VirtualFile location2 = module2.location;
        if (location2 == null || !location2.exists()) {
            return ModuleValidationState.NOT_FOUND;
        }
        String moduleName2 = this.getModuleName(module2);
        if (!ModuleListModel.isValidModuleName(moduleName2)) {
            return ModuleValidationState.INVALID_NAME;
        }
        if (ModuleListModel.hasModule(this.myProject, moduleName2)) {
            return ModuleValidationState.ALREADY_EXISTS;
        }
        return ModuleValidationState.OK;
    }

    public void setContents(@Nullable VirtualFile selectedDirectory, @NotNull Iterable<ModuleToImport> modules2) {
        this.mySelectedDirectory = selectedDirectory;
        this.myPrimaryModule = ModuleListModel.findPrimaryModule(selectedDirectory, modules2);
        this.revalidate(modules2);
    }

    private void checkForDuplicateNames() {
        Set<ModuleToImport> modules2 = this.getSelectedModules();
        ImmutableMultiset names = ImmutableMultiset.copyOf((Iterable)Iterables.transform(modules2, (Function)new Function<ModuleToImport, String>(){

            public String apply(@Nullable ModuleToImport input2) {
                return input2 == null ? null : ModuleListModel.this.getModuleName(input2);
            }
        }));
        for (ModuleToImport module2 : modules2) {
            ModuleValidationState state2 = this.myModules.get(module2);
            if (state2 != ModuleValidationState.OK || names.count((Object)this.getModuleName(module2)) <= 1) continue;
            this.myModules.put(module2, ModuleValidationState.DUPLICATE_MODULE_NAME);
        }
    }

    public Set<ModuleToImport> getSelectedModules() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.myModules.keySet(), (Predicate)new Predicate<ModuleToImport>(){

            public boolean apply(@Nullable ModuleToImport input2) {
                assert (input2 != null);
                return ModuleListModel.this.isSelected(input2);
            }
        }));
    }

    public boolean hasPrimary() {
        return this.myPrimaryModule != null;
    }

    public String getModuleName(ModuleToImport module2) {
        if (this.myNameOverrides.containsKey(module2) && !this.isRequiredModule(module2)) {
            return this.myNameOverrides.get(module2);
        }
        return module2.name;
    }

    @VisibleForTesting
    public ModuleValidationState getModuleState(ModuleToImport module2) {
        if (module2 == null) {
            return ModuleValidationState.NULL;
        }
        ModuleValidationState state2 = this.myModules.get(module2);
        if (state2 == ModuleValidationState.OK && this.isRequiredModule(module2)) {
            return ModuleValidationState.REQUIRED;
        }
        return state2;
    }

    private boolean isRequiredModule(ModuleToImport module2) {
        return this.myRequiredModules.containsKey((Object)module2);
    }

    private Map<ModuleToImport, ModuleValidationState> validateModules(Iterable<ModuleToImport> modules2) {
        HashMap result2 = Maps.newHashMap();
        for (ModuleToImport module2 : modules2) {
            result2.put(module2, this.validateModule(module2));
        }
        return result2;
    }

    public void setSelected(ModuleToImport module2, boolean isSelected) {
        this.myExplicitSelection.put(module2, isSelected);
        this.revalidate(this.myModules.keySet());
    }

    private void revalidate(Iterable<ModuleToImport> modules2) {
        this.myModules = this.validateModules(modules2);
        this.myRequiredModules = this.computeRequiredModules(this.myModules.keySet());
        for (ModuleToImport module2 : this.myRequiredModules.keySet()) {
            this.myNameOverrides.remove(module2);
        }
        this.checkForDuplicateNames();
    }

    public void setModuleName(ModuleToImport module2, @Nullable String newName2) {
        if (!this.isExplicitlyUnselected(module2)) {
            if (newName2 == null) {
                this.myNameOverrides.remove(module2);
            } else {
                this.myNameOverrides.put(module2, newName2);
            }
            this.revalidate(this.myModules.keySet());
        }
    }

    private boolean isExplicitlyUnselected(ModuleToImport module2) {
        return Objects.equal((Object)false, (Object)this.myExplicitSelection.get(module2));
    }

    @Nullable
    public MessageType getStatusSeverity(ModuleToImport module2) {
        ModuleValidationState state2 = this.getModuleState(module2);
        switch (state2) {
            case OK: 
            case NULL: {
                return null;
            }
            case NOT_FOUND: 
            case DUPLICATE_MODULE_NAME: 
            case INVALID_NAME: {
                return MessageType.ERROR;
            }
            case ALREADY_EXISTS: {
                return this.getSelectedModules().contains(module2) ? MessageType.ERROR : MessageType.WARNING;
            }
            case REQUIRED: {
                return MessageType.INFO;
            }
        }
        throw new IllegalArgumentException(state2.name());
    }

    @Nullable
    public String getStatusDescription(@NotNull ModuleToImport module2) {
        ModuleValidationState state2 = this.getModuleState(module2);
        switch (state2) {
            case OK: 
            case NULL: {
                return null;
            }
            case NOT_FOUND: {
                return "Module sources not found";
            }
            case ALREADY_EXISTS: {
                if (this.isSelected(module2) && this.isRequiredModule(module2)) {
                    return "Cannot rename module required by another";
                }
                return "Project already contains module with this name";
            }
            case DUPLICATE_MODULE_NAME: {
                return "More then one module with this name is selected";
            }
            case REQUIRED: {
                Iterable requiredBy = Iterables.transform((Iterable)this.myRequiredModules.get((Object)module2), (Function)new Function<ModuleToImport, String>(){

                    public String apply(ModuleToImport input2) {
                        return "'" + ModuleListModel.this.getModuleName(input2) + "'";
                    }
                });
                return FormatUtil.formatElementListString(requiredBy, "Required by module %s", "Required by modules %s and %s", "Required by modules %s and %d more");
            }
            case INVALID_NAME: {
                return ModuleListModel.getNameErrorMessage(this.getModuleName(module2));
            }
        }
        throw new IllegalStateException(state2.name());
    }

    @Nullable
    public ModuleToImport getPrimary() {
        return this.myPrimaryModule;
    }

    @Nullable
    public VirtualFile getCurrentPath() {
        return this.mySelectedDirectory;
    }

    public Collection<ModuleToImport> getAllModules() {
        return ImmutableList.copyOf(this.myModules.keySet());
    }

    public boolean isSelected(@NotNull ModuleToImport module2) {
        return !this.isUnselected(module2, this.isRequiredModule(module2));
    }

    public boolean canToggleModuleSelection(ModuleToImport module2) {
        ModuleValidationState state2 = this.getModuleState(module2);
        return state2 != ModuleValidationState.NOT_FOUND && !this.isRequiredModule(module2);
    }

    public boolean canRename(ModuleToImport module2) {
        return !this.isRequiredModule(module2) && this.isSelected(module2);
    }

    @VisibleForTesting
    public static enum ModuleValidationState {
        OK,
        NULL,
        NOT_FOUND,
        ALREADY_EXISTS,
        REQUIRED,
        DUPLICATE_MODULE_NAME,
        INVALID_NAME;

    }
}

