/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.assetstudio.ui.PreviewIconsPanel;
import com.android.utils.Pair;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class LauncherIconsPreviewPanel
extends PreviewIconsPanel {
    LauncherIconsPreviewPanel() {
        super("", PreviewIconsPanel.Theme.TRANSPARENT);
    }

    @Override
    public void showPreviewImages(@NotNull IconGeneratorResult result2) {
        Collection<GeneratedIcon> generatedIcons = result2.getIcons();
        List<Pair<String, BufferedImage>> list2 = generatedIcons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> this.filterPreviewIcon((GeneratedImageIcon)icon2, ((LauncherIconGenerator.LauncherIconOptions)result2.getOptions()).previewDensity)).map(icon2 -> Pair.of((Object)((Object)LauncherIconsPreviewPanel.getPreviewShapeFromId(icon2.getName())), (Object)icon2.getImage())).sorted((pair1, pair2) -> LauncherIconsPreviewPanel.comparePreviewShapes((LauncherIconGenerator.PreviewShape)((Object)((Object)pair1.getFirst())), (LauncherIconGenerator.PreviewShape)((Object)((Object)pair2.getFirst())))).map(pair -> Pair.of((Object)((LauncherIconGenerator.PreviewShape)((Object)((Object)pair.getFirst()))).displayName, (Object)((BufferedImage)pair.getSecond()))).collect(Collectors.toList());
        this.showPreviewImagesImpl(list2);
    }

    protected boolean filterPreviewIcon(@NotNull GeneratedImageIcon icon2, @NotNull Density density) {
        return icon2.getCategory() == IconCategory.PREVIEW && icon2.getDensity() == density;
    }

    private static int comparePreviewShapes(@NotNull LauncherIconGenerator.PreviewShape x, @NotNull LauncherIconGenerator.PreviewShape y) {
        return Integer.compare(LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(x), LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(y));
    }

    private static int getPreviewShapeDisplayOrder(@NotNull LauncherIconGenerator.PreviewShape previewShape) {
        switch (previewShape) {
            case CIRCLE: {
                return 1;
            }
            case SQUIRCLE: {
                return 2;
            }
            case ROUNDED_SQUARE: {
                return 3;
            }
            case SQUARE: {
                return 4;
            }
            case FULL_BLEED: {
                return 5;
            }
            case LEGACY: {
                return 6;
            }
            case LEGACY_ROUND: {
                return 7;
            }
            case PLAY_STORE: {
                return 8;
            }
        }
        return 1000;
    }

    @NotNull
    private static LauncherIconGenerator.PreviewShape getPreviewShapeFromId(@NotNull String previewShapeId) {
        for (LauncherIconGenerator.PreviewShape shape : LauncherIconGenerator.PreviewShape.values()) {
            if (!Objects.equals(shape.id, previewShapeId)) continue;
            return shape;
        }
        return LauncherIconGenerator.PreviewShape.SQUARE;
    }
}

