/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.adtui.common.ProposedFileTreeCellRenderer;
import com.android.tools.adtui.common.ProposedFileTreeModel;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.FalseValidator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.ProportionalImageScaler;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.android.actions.widgets.SourceSetCellRenderer;
import org.jetbrains.android.actions.widgets.SourceSetItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfirmGenerateIconsStep
extends ModelWizardStep<GenerateIconsModel> {
    private static final int MAX_ICON_HEIGHT = 24;
    private final List<NamedModuleTemplate> myTemplates;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private JPanel myRootPanel;
    private JComboBox<SourceSetItem> myPathsComboBox;
    private Tree myOutputPreviewTree;
    private ObjectProperty<SourceSetItem> mySelectedSourceSetItem;
    private final SourceSetItem myInitialSelectedItem;
    private final BoolProperty myFilesAlreadyExist;
    private ProposedFileTreeModel myProposedFileTreeModel;

    public ConfirmGenerateIconsStep(@NotNull GenerateIconsModel model2, @NotNull List<NamedModuleTemplate> templates) {
        super(model2, "Confirm Icon Path");
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myFilesAlreadyExist = new BoolValueProperty();
        Preconditions.checkArgument((!templates.isEmpty() ? 1 : 0) != 0);
        this.myTemplates = templates;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        SourceSetItem[] resDirs = (SourceSetItem[])AssetStudioUtils.orderTemplates(templates).stream().flatMap(template -> template.getPaths().getResDirectories().stream().map(folder -> SourceSetItem.create(template, folder))).filter(Objects::nonNull).toArray(SourceSetItem[]::new);
        this.myInitialSelectedItem = Arrays.stream(resDirs).filter(item2 -> item2.getSourceSetName().equals(model2.getTemplate().getName()) && item2.getResDirUrl().equals(model2.getResFolder().getAbsolutePath())).findFirst().orElse(null);
        DefaultComboBoxModel<SourceSetItem> moduleTemplatesModel = new DefaultComboBoxModel<SourceSetItem>(resDirs);
        this.myPathsComboBox.setModel(moduleTemplatesModel);
        this.myPathsComboBox.setRenderer((ListCellRenderer<SourceSetItem>)((Object)new SourceSetCellRenderer()));
        DefaultTreeModel emptyModel = new DefaultTreeModel(null);
        this.myOutputPreviewTree.setModel((TreeModel)emptyModel);
        this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)new ProposedFileTreeCellRenderer());
        this.myOutputPreviewTree.setBorder(BorderFactory.createLineBorder(UIUtil.getBoundsColor()));
        this.myOutputPreviewTree.setRowHeight(-1);
        this.myOutputPreviewTree.getEmptyText().setText("No resource folder defined in project");
        String alreadyExistsError = WizardUtils.toHtmlString("Some files (shown in red) will overwrite existing files.");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myFilesAlreadyExist, (Validator)new FalseValidator(Validator.Severity.WARNING, alreadyExistsError), new ObservableValue[0]);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        this.mySelectedSourceSetItem = ObjectProperty.wrap(new SelectedItemProperty(this.myPathsComboBox));
        if (this.myInitialSelectedItem != null) {
            this.mySelectedSourceSetItem.set(this.myInitialSelectedItem);
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        SourceSetItem item2 = (SourceSetItem)this.mySelectedSourceSetItem.get();
        NamedModuleTemplate template = this.findTemplateByName(item2.getSourceSetName());
        if (template == null) {
            return;
        }
        GenerateIconsModel model2 = (GenerateIconsModel)this.getModel();
        model2.setTemplate(template);
        model2.setResFolder(new File(item2.getResDirUrl()));
        model2.setFilesToDelete(this.myProposedFileTreeModel.getShadowConflictedFiles());
    }

    @Override
    protected void onEntering() {
        this.myListeners.release(this.mySelectedSourceSetItem);
        this.myListeners.listenAndFire(this.mySelectedSourceSetItem, sourceSetItem -> {
            IconGenerator iconGenerator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
            File resDirectory = new File(sourceSetItem.getResDirUrl());
            if (iconGenerator == null || resDirectory.getParentFile() == null) {
                return;
            }
            Map<File, BufferedImage> pathToUnscaledImage = iconGenerator.generateIntoFileMap(resDirectory);
            TreeMap pathToIcon = Maps.newTreeMap((file1, file2) -> {
                Density density2;
                String path1 = file1.getAbsolutePath();
                String path2 = file2.getAbsolutePath();
                Density density1 = IconGenerator.pathToDensity(path1);
                int cmp = Boolean.compare(density1 != null, (density2 = IconGenerator.pathToDensity(path2)) != null);
                if (cmp != 0) {
                    return cmp;
                }
                if (density1 != null && density1 != density2) {
                    return Integer.compare(density2.getDpiValue(), density1.getDpiValue());
                }
                BufferedImage image1 = (BufferedImage)pathToUnscaledImage.get(file1);
                BufferedImage image2 = (BufferedImage)pathToUnscaledImage.get(file2);
                cmp = Integer.compare(image2.getHeight(), image1.getHeight());
                return cmp != 0 ? cmp : path2.compareTo(path1);
            });
            ProportionalImageScaler imageScaler = ProportionalImageScaler.forImages(pathToUnscaledImage.values());
            for (Map.Entry<File, BufferedImage> entry : pathToUnscaledImage.entrySet()) {
                Image image = imageScaler.scale(entry.getValue(), 24);
                pathToIcon.put(entry.getKey(), new ImageIcon(image));
            }
            this.myProposedFileTreeModel = new ProposedFileTreeModel(resDirectory, (Map)pathToIcon);
            this.myFilesAlreadyExist.set(this.myProposedFileTreeModel.hasConflicts());
            this.myOutputPreviewTree.setModel((TreeModel)this.myProposedFileTreeModel);
            for (int i = 0; i < this.myOutputPreviewTree.getRowCount(); ++i) {
                this.myOutputPreviewTree.expandRow(i);
            }
        });
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myPathsComboBox;
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }

    @Nullable
    private NamedModuleTemplate findTemplateByName(@NotNull String name) {
        return this.myTemplates.stream().filter(template -> name.equals(template.getName())).findFirst().orElse(null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree2;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Source set:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Output directories:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myPathsComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputPreviewTree = tree2 = new Tree();
        tree2.setOpaque(false);
        tree2.setToolTipText("A preview rendering of the output tree");
        jBScrollPane.setViewportView((Component)tree2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

