/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.utils.SdkUtils;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public final class ImageAssetBrowser
extends TextFieldWithBrowseButton
implements AssetComponent<ImageAsset> {
    private static final String[] IMAGE_FILE_SUFFIXES = ImageAssetBrowser.getImageFileSuffixes();
    @NotNull
    private final ImageAsset myImageAsset = new ImageAsset();
    @NotNull
    private final BindingsManager myBindings = new BindingsManager();
    @NotNull
    private final List<ActionListener> myListeners = new ArrayList<ActionListener>(1);

    public ImageAssetBrowser() {
        this.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(ImageAssetBrowser::isImageFile));
        TextProperty imagePathText = new TextProperty(this.getTextField());
        this.myBindings.bind(imagePathText, this.myImageAsset.imagePath().transform(file2 -> file2.map(File::getAbsolutePath).orElse("")));
        this.myBindings.bind(this.myImageAsset.imagePath(), imagePathText.transform(s -> StringUtil.isEmptyOrSpaces((String)s) ? Optional.empty() : Optional.of(new File(s.trim()))));
        InvalidationListener onImageChanged = () -> {
            ActionEvent event = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myListeners) {
                listener2.actionPerformed(event);
            }
        };
        this.myImageAsset.imagePath().addListener(onImageChanged);
    }

    @Override
    @NotNull
    public ImageAsset getAsset() {
        return this.myImageAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myListeners.add(listener2);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }

    private static boolean isImageFile(@NotNull VirtualFile file2) {
        String path2 = file2.getPath();
        for (String suffix : IMAGE_FILE_SUFFIXES) {
            if (!SdkUtils.endsWithIgnoreCase((String)path2, (String)suffix) || path2.length() <= suffix.length() || path2.charAt(path2.length() - suffix.length() - 1) != '.') continue;
            return true;
        }
        return false;
    }

    private static String[] getImageFileSuffixes() {
        String[] rasterSuffixes = ImageIO.getReaderFileSuffixes();
        String[] suffixes = new String[rasterSuffixes.length + 2];
        suffixes[0] = "svg";
        suffixes[1] = "xml";
        System.arraycopy(rasterSuffixes, 0, suffixes, 2, rasterSuffixes.length);
        return suffixes;
    }
}

