/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.npw.assetstudio.MaterialVdIconsProvider;
import com.android.tools.idea.npw.assetstudio.material.icons.MaterialVdIcons;
import com.android.tools.idea.npw.assetstudio.material.icons.common.MaterialIconsMetadataUrlProvider;
import com.android.tools.idea.npw.assetstudio.material.icons.common.MaterialIconsUrlProvider;
import com.android.tools.idea.npw.assetstudio.ui.IconPickerCellRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconPickerDialog
extends DialogWrapper
implements DataProvider {
    private final Logger LOG;
    private static final String MATERIAL_ICONS_PREFIX = "Material Icons";
    private static final int COLUMN_NUMBER = 6;
    private static final int ICON_ROW_HEIGHT = JBUI.scale((int)64);
    private static final int EXPECTED_NUMBER_OF_ICONS = 1100;
    private MaterialVdIcons myIcons;
    private final List<VdIcon> myIconList;
    private final List<VdIcon> myFilteredIconList;
    private final AbstractTableModel myModel;
    private final JBTable myIconTable;
    private JPanel myContentPanel;
    private JPanel myIconsPanel;
    private JPanel myLicensePanel;
    private HyperlinkLabel myLicenseLabel;
    private SearchTextField mySearchField;
    private JComboBox<String> myCategoriesBox;
    private JComboBox<String> myStylesBox;
    @Nullable
    private VdIcon mySelectedIcon;
    @Nullable
    private VdIcon myIconToSelectInTable;
    private ItemListener myStylesBoxListener;
    private ItemListener myCategoriesBoxListener;

    public IconPickerDialog(@Nullable VdIcon selectedIcon) {
        this(selectedIcon, null, null);
    }

    @VisibleForTesting
    public IconPickerDialog(@Nullable VdIcon selectedIcon, @Nullable MaterialIconsMetadataUrlProvider metadataUrlProvider, @Nullable MaterialIconsUrlProvider iconsUrlProvider) {
        super(false);
        this.$$$setupUI$$$();
        this.LOG = Logger.getInstance(IconPickerDialog.class);
        this.myIcons = MaterialVdIcons.EMPTY;
        this.myIconList = new ArrayList<VdIcon>(1100);
        this.myFilteredIconList = new ArrayList<VdIcon>(1100);
        this.myModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column2) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return VdIcon.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                int index2 = rowIndex * 6 + columnIndex;
                if (index2 < 0) {
                    return null;
                }
                return IconPickerDialog.this.myFilteredIconList.size() > index2 ? IconPickerDialog.this.myFilteredIconList.get(index2) : null;
            }

            @Override
            public int getRowCount() {
                return IconPickerDialog.this.myFilteredIconList.size() / 6 + (IconPickerDialog.this.myFilteredIconList.size() % 6 == 0 ? 0 : 1);
            }

            @Override
            public int getColumnCount() {
                return 6;
            }
        };
        this.myIconTable = new JBTable((TableModel)this.myModel);
        this.myStylesBoxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 || e.getItem() == null) {
                    return;
                }
                int categoryCurrentIndex = IconPickerDialog.this.myCategoriesBox.getSelectedIndex();
                IconPickerDialog.this.setCategoriesBoxModel(IconPickerDialog.this.myStylesBox.getSelectedIndex());
                if (categoryCurrentIndex >= 0 && categoryCurrentIndex < IconPickerDialog.this.myCategoriesBox.getItemCount()) {
                    IconPickerDialog.this.myCategoriesBox.setSelectedIndex(categoryCurrentIndex);
                }
            }
        };
        this.myCategoriesBoxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 || e.getItem() == null) {
                    return;
                }
                IconPickerDialog.this.updateIconList();
            }
        };
        this.myIconToSelectInTable = selectedIcon;
        this.setTitle("Select Icon");
        Color iconBackgroundColor = UIUtil.getListBackground();
        this.myIconTable.setBackground(iconBackgroundColor);
        this.myIconTable.setDefaultRenderer(VdIcon.class, (TableCellRenderer)new IconPickerCellRenderer());
        this.myIconTable.setTableHeader(null);
        this.myIconTable.setRowHeight(ICON_ROW_HEIGHT);
        this.myIconTable.setSelectionMode(0);
        this.myIconTable.setCellSelectionEnabled(true);
        this.myIconsPanel.add((Component)new JBScrollPane((Component)this.myIconTable));
        TableHoverListener.DEFAULT.removeFrom((JComponent)this.myIconTable);
        this.myIconTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                    IconPickerDialog.this.mySearchField.setText(Character.toString(keyChar));
                    IconPickerDialog.this.mySearchField.requestFocus();
                }
                super.keyPressed(e);
            }
        });
        this.myLicenseLabel.setHyperlinkText("These icons are available under the ", "Apache License Version 2.0", "");
        this.myLicenseLabel.setHyperlinkTarget("http://www.apache.org/licenses/LICENSE-2.0.txt");
        ListSelectionModel selModel = this.myIconTable.getSelectionModel();
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.myIconTable.setGridColor(iconBackgroundColor);
        this.myIconTable.setIntercellSpacing((Dimension)JBUI.size((int)3, (int)3));
        this.myIconTable.setRowMargin(0);
        ListSelectionListener listener2 = e -> {
            VdIcon icon2;
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row2 = this.myIconTable.getSelectedRow();
            int col = this.myIconTable.getSelectedColumn();
            this.mySelectedIcon = icon2 = row2 != -1 && col != -1 ? (VdIcon)this.myIconTable.getValueAt(row2, col) : null;
            if (icon2 != null) {
                this.myIconToSelectInTable = icon2;
            }
            this.setOKActionEnabled(icon2 != null);
        };
        selModel.addListSelectionListener(listener2);
        ListSelectionModel colSelModel = this.myIconTable.getColumnModel().getSelectionModel();
        colSelModel.addListSelectionListener(listener2);
        selModel.setSelectionMode(0);
        selModel.setSelectionInterval(0, 0);
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.requestFocusInWindow();
        DataManager.registerDataProvider((JComponent)this.myContentPanel, (DataProvider)this);
        AnAction action2 = ActionManager.getInstance().getAction("Find");
        if (action2 != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(action2.getShortcutSet(), (JComponent)this.getRootPane(), this.myDisposable);
        }
        this.init();
        this.myIconTable.getEmptyText().setText("Loading icons...");
        this.myIconTable.setPaintBusy(true);
        this.myStylesBox.setEnabled(false);
        this.myCategoriesBox.setEnabled(false);
        MaterialVdIconsProvider.loadMaterialVdIcons((Function2<? super MaterialVdIcons, ? super MaterialVdIconsProvider.Status, Unit>)((Function2)(materialVdIcons, status2) -> {
            assert (ApplicationManager.getApplication().isDispatchThread());
            this.myIconTable.getEmptyText().setText(StatusText.getDefaultEmptyText());
            this.populateIcons((MaterialVdIcons)materialVdIcons);
            if (status2 == MaterialVdIconsProvider.Status.FINISHED) {
                this.myIconTable.setPaintBusy(false);
                this.myStylesBox.setEnabled(true);
                this.myCategoriesBox.setEnabled(true);
                this.myStylesBox.addItemListener(this.myStylesBoxListener);
                this.myCategoriesBox.addItemListener(this.myCategoriesBoxListener);
            }
            return null;
        }), metadataUrlProvider, iconsUrlProvider, this.getDisposable());
    }

    private void createUIComponents() {
        this.mySearchField = new SearchTextField(false);
        this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                IconPickerDialog.this.updateFilter();
            }
        });
    }

    private void updateFilter() {
        String text2 = this.mySearchField.getText().trim();
        this.myFilteredIconList.clear();
        for (VdIcon icon2 : this.myIconList) {
            if (!text2.isEmpty() && !StringUtil.containsIgnoreCase((String)icon2.getDisplayName(), (String)text2)) continue;
            this.myFilteredIconList.add(icon2);
        }
        this.myModel.fireTableDataChanged();
    }

    private boolean tryToSelectIcon() {
        VdIcon iconToSelect = this.myIconToSelectInTable;
        this.myIconToSelectInTable = null;
        if (iconToSelect == null) {
            return false;
        }
        for (int r = 0; r < this.myIconTable.getRowCount(); ++r) {
            for (int c = 0; c < this.myIconTable.getColumnCount(); ++c) {
                VdIcon icon2 = (VdIcon)this.myIconTable.getValueAt(r, c);
                if (icon2 == null || !icon2.getDisplayName().equals(iconToSelect.getDisplayName())) continue;
                this.myIconTable.changeSelection(r, c, false, false);
                return true;
            }
        }
        return false;
    }

    private void populateIcons(MaterialVdIcons icons) {
        boolean shouldUpdateIconList = this.myIcons == null || this.myIcons == MaterialVdIcons.EMPTY;
        this.myIcons = icons;
        this.setStylesBoxModel();
        this.setCategoriesBoxModel(0);
        this.myStylesBox.setSelectedIndex(0);
        this.myCategoriesBox.setSelectedIndex(0);
        if (shouldUpdateIconList) {
            this.updateIconList();
        }
    }

    private void setStylesBoxModel() {
        String[] stylesArray = (String[])Arrays.stream(this.myIcons.getStyles()).map(styleName -> {
            if (styleName.startsWith(MATERIAL_ICONS_PREFIX)) {
                String styleShortened = styleName.substring(MATERIAL_ICONS_PREFIX.length()).trim();
                if (styleShortened.isEmpty()) {
                    return "Filled";
                }
                return styleShortened;
            }
            return styleName;
        }).toArray(String[]::new);
        this.myStylesBox.setModel(new DefaultComboBoxModel<String>(stylesArray));
    }

    private void setCategoriesBoxModel(int styleIndex) {
        ArrayList categoriesArray = Arrays.stream(this.myIcons.getCategories(this.myIcons.getStyles()[styleIndex])).map(categoryName -> categoryName.equals("av") ? "Audio/Video" : StringUtil.capitalize((String)categoryName)).collect(Collectors.toCollection(ArrayList::new));
        categoriesArray.add(0, "All");
        this.myCategoriesBox.setModel((ComboBoxModel<String>)new CollectionComboBoxModel((List)categoriesArray, null));
    }

    @Nullable
    public VdIcon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    @VisibleForTesting
    public JTable getTable() {
        return this.myIconTable;
    }

    @VisibleForTesting
    public void setFilter(String text2) {
        this.mySearchField.setText(text2);
    }

    private void updateIconList() {
        this.myIconList.clear();
        String style = this.myIcons.getStyles()[this.myStylesBox.getSelectedIndex()];
        Object categoryItem = this.myCategoriesBox.getSelectedItem();
        if (categoryItem instanceof String && categoryItem.equals("All")) {
            this.myIconList.addAll(Arrays.asList(this.myIcons.getAllIcons(style)));
        } else {
            String category = this.myIcons.getCategories(style)[this.myCategoriesBox.getSelectedIndex() - 1];
            this.myIconList.addAll(Arrays.asList(this.myIcons.getIcons(style, category)));
        }
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.updateFilter();
        if (!this.tryToSelectIcon()) {
            this.myIconTable.setColumnSelectionInterval(0, 0);
            this.myIconTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @NotNull
    public JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return SearchTextField.KEY.is(dataId) ? this.mySearchField : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(20, 10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel4, "North");
        SearchTextField searchTextField2 = this.mySearchField;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)searchTextField2, gridBagConstraints);
        JComboBox jComboBox = new JComboBox();
        this.myCategoriesBox = jComboBox;
        jComboBox.setMinimumSize(new Dimension(140, 30));
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        jPanel4.add(jComboBox, gridBagConstraints2);
        JComboBox jComboBox2 = new JComboBox();
        this.myStylesBox = jComboBox2;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        jPanel4.add(jComboBox2, gridBagConstraints3);
        this.myIconsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setMinimumSize(new Dimension(300, 400));
        jPanel3.add((Component)jPanel2, "Center");
        this.myLicensePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, "South");
        this.myLicenseLabel = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

