/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.TvChannelIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.ClipartIconButton;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.MultiLineTextAssetEditor;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.expressions.string.FormatExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAdaptiveIconPanel
extends JPanel
implements Disposable,
ConfigureIconView,
PersistentStateComponent<PersistentState> {
    private static final boolean HIDE_INAPPLICABLE_CONTROLS = false;
    private static final File DEFAULT_FOREGROUND_IMAGE = AssetStudioUtils.getBundledImage("asset_studio", "ic_launcher_foreground.xml");
    private static final File DEFAULT_BACKGROUND_IMAGE = AssetStudioUtils.getBundledImage("asset_studio", "ic_launcher_background.xml");
    private static final ForegroundAssetType DEFAULT_FOREGROUND_ASSET_TYPE = ForegroundAssetType.IMAGE;
    private static final BackgroundAssetType DEFAULT_BACKGROUND_ASSET_TYPE = BackgroundAssetType.IMAGE;
    private static final Density DEFAULT_PREVIEW_DENSITY = Density.XHIGH;
    private static final IconGenerator.Shape DEFAULT_ICON_SHAPE = IconGenerator.Shape.SQUARE;
    private static final String FOREGROUND_ASSET_TYPE_PROPERTY = "foregroundAssetType";
    private static final String BACKGROUND_ASSET_TYPE_PROPERTY = "backgroundAssetType";
    private static final String BACKGROUND_COLOR_PROPERTY = "backgroundColor";
    private static final String GENERATE_LEGACY_ICON_PROPERTY = "generateLegacyIcon";
    private static final String GENERATE_ROUND_ICON_PROPERTY = "generateRoundIcon";
    private static final String GENERATE_PLAY_STORE_ICON_PROPERTY = "generatePlayStoreIcon";
    private static final String LEGACY_ICON_SHAPE_PROPERTY = "legacyIconShape";
    private static final String SHOW_GRID_PROPERTY = "showGrid";
    private static final String SHOW_SAFE_ZONE_PROPERTY = "showSafeZone";
    private static final String PREVIEW_DENSITY_PROPERTY = "previewDensity";
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String FOREGROUND_LAYER_NAME_PROPERTY = "foregroundLayerName";
    private static final String BACKGROUND_LAYER_NAME_PROPERTY = "backgroundLayerName";
    private static final String BACKGROUND_IMAGE_PROPERTY = "backgroundImage";
    private static final String FOREGROUND_CLIPART_ASSET_PROPERTY = "foregroundClipartAsset";
    private static final String FOREGROUND_TEXT_ASSET_PROPERTY = "foregroundTextAsset";
    private JPanel myRootPanel;
    private JBLabel myOutputNameLabel;
    private JTextField myOutputNameTextField;
    private JPanel myForegroundAllOptionsPanel;
    private JRadioButton myForegroundClipartRadioButton;
    private JRadioButton myForegroundTextRadioButton;
    private JRadioButton myForegroundImageRadioButton;
    private JRadioButton myForegroundTrimYesRadioButton;
    private JRadioButton myForegroundTrimNoRadioButton;
    private JPanel myForegroundTrimOptionsPanel;
    private JSlider myForegroundResizeSlider;
    private JLabel myForegroundResizeValueLabel;
    private JPanel myForegroundAssetRadioButtonsPanel;
    private JPanel myForegroundResizeSliderPanel;
    private JTextField myForegroundLayerNameTextField;
    private JPanel myForegroundColorRowPanel;
    private ColorPanel myForegroundColorPanel;
    private JPanel mGenerateLegacyIconRadioButtonsPanel;
    private JRadioButton myGenerateLegacyIconYesRadioButton;
    private JBScrollPane myForegroundScrollPane;
    private JPanel myForegroundImageAssetRowPanel;
    private JPanel myForegroundClipartAssetRowPanel;
    private JPanel myForegroundTextAssetRowPanel;
    private ImageAssetBrowser myForegroundImageAssetBrowser;
    private ClipartIconButton myForegroundClipartAssetButton;
    private MultiLineTextAssetEditor myForegroundTextAssetEditor;
    private JBLabel myForegroundLayerNameLabel;
    private JLabel myForegroundAssetTypeLabel;
    private JBLabel myForegroundImagePathLabel;
    private JBLabel myForegroundClipartLabel;
    private JBLabel myForegroundTextLabel;
    private JBLabel myForegroundTrimLabel;
    private JBLabel myForegroundResizeLabel;
    private JBLabel myForegroundColorLabel;
    private JBLabel myGenerateLegacyIconLabel;
    private JPanel myBackgroundAllOptionsPanel;
    private JRadioButton myBackgroundImageRadioButton;
    private JRadioButton myBackgroundColorRadioButton;
    private JRadioButton myBackgroundTrimYesRadioButton;
    private JPanel myBackgroundTrimOptionsPanel;
    private JSlider myBackgroundResizeSlider;
    private JLabel myBackgroundResizeValueLabel;
    private JPanel myBackgroundAssetRadioButtonsPanel;
    private JPanel myBackgroundResizeSliderPanel;
    private JTextField myBackgroundLayerNameTextField;
    private JPanel myBackgroundTrimRowPanel;
    private JPanel myBackgroundResizeRowPanel;
    private JPanel myBackgroundColorRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private TitledSeparator myGenerateRoundIconTitle;
    private JPanel myGenerateRoundIconRowPanel;
    private JPanel myGenerateRoundIconRadioButtonsPanel;
    private JRadioButton myGenerateRoundIconYesRadioButton;
    private JComboBox<IconGenerator.Shape> myLegacyIconShapeComboBox;
    private JBScrollPane myBackgroundScrollPane;
    private JPanel myBackgroundImageAssetRowPanel;
    private ImageAssetBrowser myBackgroundImageAssetBrowser;
    private JBLabel myBackgroundLayerNameLabel;
    private JLabel myBackgroundAssetTypeLabel;
    private JBLabel myBackgroundImagePathLabel;
    private JBLabel myBackgroundTrimLabel;
    private JBLabel myBackgroundResizeLabel;
    private JBLabel myGenerateRoundIconLabel;
    private JBLabel myBackgroundColorLabel;
    private JBLabel myLegacyIconShapeLabel;
    private JBScrollPane myOtherIconsScrollPane;
    private JPanel myOtherIconsAllOptionsPanel;
    private JPanel myForegroundAssetTypePanel;
    private JPanel myForegroundLayerNamePanel;
    private JPanel myForegroundAssetTypeSourcePanel;
    private JPanel myForegroundImageOptionsPanel;
    private JPanel myBackgroundLayerNamePanel;
    private JPanel myBackgroundAssetTypePanel;
    private JPanel myBackgroundAssetTypeSourcePanel;
    private JPanel myBackgroundImageOptionsPanel;
    private JPanel myLegacyIconShapeRowPanel;
    private JPanel myOutputNamePanelRow;
    private TitledSeparator myForegroundScalingTitleSeparator;
    private TitledSeparator mySourceAssetTitleSeparator;
    private JPanel myForegroundResizePanel;
    private TitledSeparator myBackgroundScalingTitleSeparator;
    private TitledSeparator myBackgroundSourceAssetTitleSeparator;
    private JPanel myGenerateLegacyIconRowPanel;
    private JPanel myForegroundTrimPanel;
    private JPanel myLegacyIconShapePanel;
    private TitledSeparator myGeneratePlayStoreIconTitle;
    private JPanel myGeneratePlayStoreIconRowPanel;
    private JBLabel myGeneratePlayStoreIconLabel;
    private JPanel myGeneratePlayStoreIconRadioButtonsPanel;
    private JRadioButton myGeneratePlayStoreIconYesRadioButton;
    private JRadioButton myBackgroundTrimNoRadioButton;
    @NotNull
    private final AndroidIconType myIconType;
    @NotNull
    private final String myDefaultOutputName;
    private static final Map<IconGenerator.Shape, String> myShapeNames = ImmutableMap.of((Object)((Object)IconGenerator.Shape.NONE), (Object)"None", (Object)((Object)IconGenerator.Shape.CIRCLE), (Object)"Circle", (Object)((Object)IconGenerator.Shape.SQUARE), (Object)"Square", (Object)((Object)IconGenerator.Shape.VRECT), (Object)"Vertical", (Object)((Object)IconGenerator.Shape.HRECT), (Object)"Horizontal");
    @NotNull
    private final AndroidVersion myBuildSdkVersion;
    @NotNull
    private final AdaptiveIconGenerator myIconGenerator;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myGeneralBindings;
    @NotNull
    private final BindingsManager myForegroundActiveAssetBindings;
    @NotNull
    private final BindingsManager myBackgroundActiveAssetBindings;
    @NotNull
    private final ListenerManager myListeners;
    @NotNull
    private final List<ActionListener> myAssetListeners;
    @NotNull
    private final ImmutableMap<ForegroundAssetType, AssetComponent<?>> myForegroundAssetPanelMap;
    @NotNull
    private final StringProperty myOutputName;
    @NotNull
    private final StringProperty myForegroundLayerName;
    @NotNull
    private final StringProperty myBackgroundLayerName;
    @NotNull
    private final ObjectProperty<BaseAsset> myForegroundActiveAsset;
    @NotNull
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    @NotNull
    private final ObjectProperty<Validator.Result> myForegroundAssetValidityState;
    @NotNull
    private final ObjectProperty<Validator.Result> myBackgroundAssetValidityState;
    @NotNull
    private final AbstractProperty<ForegroundAssetType> myForegroundAssetType;
    @NotNull
    private final AbstractProperty<BackgroundAssetType> myBackgroundAssetType;
    @NotNull
    private final BoolProperty myShowGrid;
    @NotNull
    private final BoolProperty myShowSafeZone;
    @NotNull
    private final AbstractProperty<Density> myPreviewDensity;
    private ColorProperty myForegroundColor;
    private AbstractProperty<Color> myBackgroundColor;
    private BoolProperty myForegroundTrimmed;
    private BoolProperty myBackgroundTrimmed;
    private IntProperty myForegroundResizePercent;
    private IntProperty myBackgroundResizePercent;
    private BoolProperty myGenerateLegacyIcon;
    private BoolProperty myGenerateRoundIcon;
    private BoolProperty myGeneratePlayStoreIcon;
    private AbstractProperty<IconGenerator.Shape> myLegacyIconShape;

    public ConfigureAdaptiveIconPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet2, @NotNull AndroidIconType iconType, @NotNull BoolProperty showGrid, @NotNull BoolProperty showSafeZone, @NotNull AbstractProperty<Density> previewDensity, @NotNull ValidatorPanel validatorPanel2, @Nullable DrawableRenderer renderer2) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myGeneralBindings = new BindingsManager();
        this.myForegroundActiveAssetBindings = new BindingsManager();
        this.myBackgroundActiveAssetBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myAssetListeners = new ArrayList<ActionListener>(1);
        this.myForegroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
        this.myBackgroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
        this.myIconType = iconType;
        this.myDefaultOutputName = this.myIconType.toOutputName("");
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(facet2);
        AndroidVersion buildSdkVersion = androidModuleInfo.getBuildSdkVersion();
        this.myBuildSdkVersion = buildSdkVersion != null ? buildSdkVersion : new AndroidVersion(26);
        this.myShowGrid = showGrid;
        this.myShowSafeZone = showSafeZone;
        this.myPreviewDensity = previewDensity;
        this.myIconGenerator = this.myIconType == AndroidIconType.LAUNCHER ? new LauncherIconGenerator(facet2.getModule().getProject(), androidModuleInfo.getMinSdkVersion().getApiLevel(), renderer2) : new TvChannelIconGenerator(facet2.getModule().getProject(), androidModuleInfo.getMinSdkVersion().getApiLevel(), renderer2);
        this.myValidatorPanel = validatorPanel2;
        this.myForegroundImageAssetBrowser.getAsset().setDefaultImagePath(DEFAULT_FOREGROUND_IMAGE);
        this.myBackgroundImageAssetBrowser.getAsset().setDefaultImagePath(DEFAULT_BACKGROUND_IMAGE);
        this.myForegroundTextAssetEditor.getAsset().setDefaultText("Aa");
        DefaultComboBoxModel<IconGenerator.Shape> legacyShapesModel = new DefaultComboBoxModel<IconGenerator.Shape>();
        for (IconGenerator.Shape shape : myShapeNames.keySet()) {
            legacyShapesModel.addElement(shape);
        }
        this.myLegacyIconShapeComboBox.setRenderer((ListCellRenderer<IconGenerator.Shape>)SimpleListCellRenderer.create((String)"", myShapeNames::get));
        this.myLegacyIconShapeComboBox.setModel(legacyShapesModel);
        this.myLegacyIconShapeComboBox.setSelectedItem((Object)IconGenerator.Shape.SQUARE);
        this.myForegroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myForegroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myBackgroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myBackgroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOtherIconsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myOtherIconsScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myForegroundLayerName = new TextProperty(this.myForegroundLayerNameTextField);
        this.myBackgroundLayerName = new TextProperty(this.myBackgroundLayerNameTextField);
        this.myListeners.listen(this.myForegroundLayerName, name -> {
            if (name.equals(this.defaultForegroundLayerName())) {
                this.myGeneralBindings.bind(this.myForegroundLayerName, Expression.create(this::defaultForegroundLayerName, this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myForegroundLayerName);
            }
        });
        this.myListeners.listen(this.myBackgroundLayerName, name -> {
            if (name.equals(this.defaultBackgroundLayerName())) {
                this.myGeneralBindings.bind(this.myBackgroundLayerName, Expression.create(this::defaultBackgroundLayerName, this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myBackgroundLayerName);
            }
        });
        this.myForegroundAssetPanelMap = ImmutableMap.of((Object)((Object)ForegroundAssetType.IMAGE), (Object)this.myForegroundImageAssetBrowser, (Object)((Object)ForegroundAssetType.CLIP_ART), (Object)this.myForegroundClipartAssetButton, (Object)((Object)ForegroundAssetType.TEXT), (Object)this.myForegroundTextAssetEditor);
        this.myForegroundImageAssetBrowser.getAsset().imagePath().setValue(DEFAULT_FOREGROUND_IMAGE);
        this.myBackgroundImageAssetBrowser.getAsset().imagePath().setValue(DEFAULT_BACKGROUND_IMAGE);
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myForegroundLayerNameLabel.setLabelFor((Component)this.myForegroundLayerNameTextField);
        this.myForegroundAssetTypeLabel.setLabelFor(this.myForegroundAssetRadioButtonsPanel);
        this.myForegroundImagePathLabel.setLabelFor((Component)((Object)this.myForegroundImageAssetBrowser));
        this.myForegroundClipartLabel.setLabelFor((Component)this.myForegroundClipartAssetButton);
        this.myForegroundTextLabel.setLabelFor((Component)this.myForegroundTextAssetEditor);
        this.myForegroundTrimLabel.setLabelFor((Component)this.myForegroundTrimOptionsPanel);
        this.myForegroundResizeLabel.setLabelFor((Component)this.myForegroundResizeSliderPanel);
        this.myForegroundColorLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myGenerateLegacyIconLabel.setLabelFor((Component)this.mGenerateLegacyIconRadioButtonsPanel);
        this.myBackgroundLayerNameLabel.setLabelFor((Component)this.myBackgroundLayerNameTextField);
        this.myBackgroundAssetTypeLabel.setLabelFor(this.myBackgroundAssetRadioButtonsPanel);
        this.myBackgroundImagePathLabel.setLabelFor((Component)((Object)this.myBackgroundImageAssetBrowser));
        this.myBackgroundTrimLabel.setLabelFor((Component)this.myBackgroundTrimOptionsPanel);
        this.myBackgroundResizeLabel.setLabelFor((Component)this.myBackgroundResizeSliderPanel);
        this.myBackgroundColorLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myGenerateRoundIconLabel.setLabelFor((Component)this.myGenerateRoundIconRadioButtonsPanel);
        this.myLegacyIconShapeLabel.setLabelFor(this.myLegacyIconShapeComboBox);
        this.myForegroundAssetType = new SelectedRadioButtonProperty<ForegroundAssetType>(DEFAULT_FOREGROUND_ASSET_TYPE, (T[])ForegroundAssetType.values(), this.myForegroundImageRadioButton, this.myForegroundClipartRadioButton, this.myForegroundTextRadioButton);
        this.myForegroundActiveAsset = new ObjectValueProperty<ImageAsset>(this.myForegroundImageAssetBrowser.getAsset());
        this.myForegroundImageAssetBrowser.getAsset().setRole("foreground image");
        this.myForegroundColorPanel.setSelectedColor(LauncherIconGenerator.DEFAULT_FOREGROUND_COLOR);
        this.myBackgroundAssetType = new SelectedRadioButtonProperty<BackgroundAssetType>(DEFAULT_BACKGROUND_ASSET_TYPE, (T[])BackgroundAssetType.values(), this.myBackgroundImageRadioButton, this.myBackgroundColorRadioButton);
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>(this.myBackgroundImageAssetBrowser.getAsset());
        this.myBackgroundImageAssetBrowser.getAsset().setRole("background image");
        this.myBackgroundColorPanel.setSelectedColor((Color)this.myIconGenerator.backgroundColor().get());
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            Disposer.register((Disposable)this, (Disposable)assetComponent);
        }
        Disposer.register((Disposable)this, (Disposable)this.myBackgroundImageAssetBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.add(this.myRootPanel);
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state2 = new PersistentState();
        state2.set(FOREGROUND_ASSET_TYPE_PROPERTY, (ForegroundAssetType)((Object)this.myForegroundAssetType.get()), DEFAULT_FOREGROUND_ASSET_TYPE);
        state2.set(BACKGROUND_ASSET_TYPE_PROPERTY, (BackgroundAssetType)((Object)this.myBackgroundAssetType.get()), DEFAULT_BACKGROUND_ASSET_TYPE);
        for (Map.Entry entry : this.myForegroundAssetPanelMap.entrySet()) {
            state2.setChild("foreground" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey()), ((BaseAsset)((AssetComponent)entry.getValue()).getAsset()).getState());
        }
        state2.setChild(BACKGROUND_IMAGE_PROPERTY, this.myBackgroundImageAssetBrowser.getAsset().getState());
        state2.set(BACKGROUND_COLOR_PROPERTY, (Color)this.myBackgroundColor.get(), AdaptiveIconGenerator.DEFAULT_BACKGROUND_COLOR);
        state2.set(GENERATE_LEGACY_ICON_PROPERTY, (Boolean)this.myGenerateLegacyIcon.get(), true);
        state2.set(GENERATE_ROUND_ICON_PROPERTY, (Boolean)this.myGenerateRoundIcon.get(), true);
        state2.set(GENERATE_PLAY_STORE_ICON_PROPERTY, (Boolean)this.myGeneratePlayStoreIcon.get(), true);
        state2.set(LEGACY_ICON_SHAPE_PROPERTY, (IconGenerator.Shape)((Object)this.myLegacyIconShape.get()), DEFAULT_ICON_SHAPE);
        state2.set(SHOW_GRID_PROPERTY, (Boolean)this.myShowGrid.get(), false);
        state2.set(SHOW_SAFE_ZONE_PROPERTY, (Boolean)this.myShowSafeZone.get(), true);
        state2.set(PREVIEW_DENSITY_PROPERTY, (Density)this.myPreviewDensity.get(), DEFAULT_PREVIEW_DENSITY);
        state2.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), this.myDefaultOutputName);
        state2.set(FOREGROUND_LAYER_NAME_PROPERTY, (String)this.myForegroundLayerName.get(), this.defaultForegroundLayerName());
        state2.set(BACKGROUND_LAYER_NAME_PROPERTY, (String)this.myBackgroundLayerName.get(), this.defaultBackgroundLayerName());
        state2.setChild(FOREGROUND_CLIPART_ASSET_PROPERTY, this.myForegroundClipartAssetButton.getState());
        state2.setChild(FOREGROUND_TEXT_ASSET_PROPERTY, this.myForegroundTextAssetEditor.getAsset().getState());
        return state2;
    }

    public void loadState(@NotNull PersistentState state2) {
        this.myForegroundAssetType.set(state2.get(FOREGROUND_ASSET_TYPE_PROPERTY, DEFAULT_FOREGROUND_ASSET_TYPE));
        this.myBackgroundAssetType.set(state2.get(BACKGROUND_ASSET_TYPE_PROPERTY, DEFAULT_BACKGROUND_ASSET_TYPE));
        for (Map.Entry entry : this.myForegroundAssetPanelMap.entrySet()) {
            PersistentStateUtil.load(((AssetComponent)entry.getValue()).getAsset(), state2.getChild("foreground" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey())));
        }
        PersistentStateUtil.load(this.myBackgroundImageAssetBrowser.getAsset(), state2.getChild(BACKGROUND_IMAGE_PROPERTY));
        this.myBackgroundColor.set(state2.get(BACKGROUND_COLOR_PROPERTY, AdaptiveIconGenerator.DEFAULT_BACKGROUND_COLOR));
        this.myGenerateLegacyIcon.set(state2.get(GENERATE_LEGACY_ICON_PROPERTY, true));
        this.myGenerateRoundIcon.set(state2.get(GENERATE_ROUND_ICON_PROPERTY, true));
        this.myGeneratePlayStoreIcon.set(state2.get(GENERATE_PLAY_STORE_ICON_PROPERTY, true));
        this.myLegacyIconShape.set(state2.get(LEGACY_ICON_SHAPE_PROPERTY, DEFAULT_ICON_SHAPE));
        this.myShowGrid.set(state2.get(SHOW_GRID_PROPERTY, false));
        this.myShowSafeZone.set(state2.get(SHOW_SAFE_ZONE_PROPERTY, true));
        this.myPreviewDensity.set(state2.get(PREVIEW_DENSITY_PROPERTY, DEFAULT_PREVIEW_DENSITY));
        this.myOutputName.set(state2.get(OUTPUT_NAME_PROPERTY, this.myDefaultOutputName));
        this.myForegroundLayerName.set(state2.get(FOREGROUND_LAYER_NAME_PROPERTY, this.defaultForegroundLayerName()));
        this.myBackgroundLayerName.set(state2.get(BACKGROUND_LAYER_NAME_PROPERTY, this.defaultBackgroundLayerName()));
        PersistentStateUtil.load(this.myForegroundClipartAssetButton, state2.getChild(FOREGROUND_CLIPART_ASSET_PROPERTY));
        PersistentStateUtil.load(this.myForegroundTextAssetEditor.getAsset(), state2.getChild(FOREGROUND_TEXT_ASSET_PROPERTY));
    }

    private void createUIComponents() {
    }

    private void initializeListenersAndBindings() {
        this.myForegroundTrimmed = new SelectedProperty(this.myForegroundTrimYesRadioButton);
        this.myBackgroundTrimmed = new SelectedProperty(this.myBackgroundTrimYesRadioButton);
        this.myForegroundResizePercent = new SliderValueProperty(this.myForegroundResizeSlider);
        TextProperty foregroundResizeValueString = new TextProperty(this.myForegroundResizeValueLabel);
        this.myGeneralBindings.bind(foregroundResizeValueString, new FormatExpression("%d %%", this.myForegroundResizePercent));
        this.myBackgroundResizePercent = new SliderValueProperty(this.myBackgroundResizeSlider);
        TextProperty backgroundResizeValueString = new TextProperty(this.myBackgroundResizeValueLabel);
        this.myGeneralBindings.bind(backgroundResizeValueString, new FormatExpression("%d %%", this.myBackgroundResizePercent));
        this.myForegroundColor = new ColorProperty(this.myForegroundColorPanel);
        this.myBackgroundColor = ObjectProperty.wrap(new ColorProperty(this.myBackgroundColorPanel));
        this.myGenerateLegacyIcon = new SelectedProperty(this.myGenerateLegacyIconYesRadioButton);
        this.myGenerateRoundIcon = new SelectedProperty(this.myGenerateRoundIconYesRadioButton);
        this.myGeneratePlayStoreIcon = new SelectedProperty(this.myGeneratePlayStoreIconYesRadioButton);
        this.myLegacyIconShape = ObjectProperty.wrap(new SelectedItemProperty(this.myLegacyIconShapeComboBox));
        this.updateBindingsAndUiForActiveIconType();
        this.myForegroundAssetType.addListener(() -> {
            AssetComponent assetComponent = (AssetComponent)this.myForegroundAssetPanelMap.get(this.myForegroundAssetType.get());
            this.myForegroundActiveAsset.set((BaseAsset)assetComponent.getAsset());
        });
        this.myBackgroundAssetType.addListener(() -> {
            if (this.myBackgroundAssetType.get() == BackgroundAssetType.IMAGE) {
                this.myBackgroundImageAsset.setValue(this.myBackgroundImageAssetBrowser.getAsset());
            } else {
                this.myBackgroundImageAsset.clear();
            }
        });
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            assetComponent.addAssetListener(assetPanelListener);
        }
        this.myBackgroundImageAssetBrowser.addAssetListener(assetPanelListener);
        Runnable onAssetModified = this::fireAssetListeners;
        this.myListeners.listenAll(this.myForegroundTrimmed, this.myForegroundResizePercent, this.myForegroundColor, this.myBackgroundTrimmed, this.myBackgroundResizePercent, this.myBackgroundColor, this.myGenerateLegacyIcon, this.myLegacyIconShape, this.myGenerateRoundIcon, this.myGeneratePlayStoreIcon).with(onAssetModified);
        BoolValueProperty foregroundIsResizable = new BoolValueProperty();
        this.myListeners.listenAndFire(this.myForegroundActiveAsset, () -> {
            this.myForegroundActiveAssetBindings.releaseAll();
            BaseAsset asset = (BaseAsset)this.myForegroundActiveAsset.get();
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundTrimmed, asset.trimmed());
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundResizePercent, asset.scalingPercent());
            OptionalValueProperty<Color> assetColor = asset.color();
            if (assetColor.getValueOrNull() == null) {
                assetColor.setNullableValue((Color)this.myForegroundColor.getValueOrNull());
            }
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundColor, assetColor);
            this.myForegroundActiveAssetBindings.bind(foregroundIsResizable, asset.isResizable());
            if (asset instanceof ImageAsset) {
                this.myForegroundActiveAssetBindings.bind(this.myForegroundAssetValidityState, ((ImageAsset)asset).getValidityState());
            } else {
                this.myForegroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().sourceAsset().setValue(asset);
            onAssetModified.run();
        });
        BoolValueProperty backgroundIsResizable = new BoolValueProperty();
        Runnable onBackgroundAssetModified = () -> {
            this.myBackgroundActiveAssetBindings.releaseAll();
            ImageAsset asset = this.myBackgroundImageAsset.getValueOrNull();
            if (asset != null) {
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundTrimmed, asset.trimmed());
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundResizePercent, asset.scalingPercent());
                this.myBackgroundActiveAssetBindings.bind(backgroundIsResizable, asset.isResizable());
                this.myBackgroundActiveAssetBindings.bind(this.myBackgroundAssetValidityState, asset.getValidityState());
            } else {
                backgroundIsResizable.set(false);
                this.myBackgroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().backgroundImageAsset().setNullableValue(asset);
            onAssetModified.run();
        };
        this.myListeners.listenAndFire(this.myBackgroundImageAsset, onBackgroundAssetModified::run);
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundImageAssetRowPanel), (Object)new SelectedProperty(this.myForegroundImageRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundClipartAssetRowPanel), (Object)new SelectedProperty(this.myForegroundClipartRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundTextAssetRowPanel), (Object)new SelectedProperty(this.myForegroundTextRadioButton));
        Expression<Boolean> isForegroundIsNotImage = Expression.create(() -> this.myForegroundAssetType.get() != ForegroundAssetType.IMAGE, this.myForegroundAssetType);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundColorRowPanel), isForegroundIsNotImage);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimYesRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimNoRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundResizeSlider), (Object)foregroundIsResizable);
        SelectedProperty backgroundIsImage = new SelectedProperty(this.myBackgroundImageRadioButton);
        SelectedProperty backgroundIsColor = new SelectedProperty(this.myBackgroundColorRadioButton);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundImageAssetRowPanel), (Object)backgroundIsImage);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundColorRowPanel), (Object)backgroundIsColor);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimYesRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimNoRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundResizeSlider), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myLegacyIconShapeComboBox), (Object)new SelectedProperty(this.myGenerateLegacyIconYesRadioButton));
        BoolValueProperty isLauncherIcon = new BoolValueProperty(this.myIconType == AndroidIconType.LAUNCHER);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myLegacyIconShapeRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty((JComponent)this.myGenerateRoundIconTitle), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myGenerateRoundIconRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty((JComponent)this.myGeneratePlayStoreIconTitle), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myGeneratePlayStoreIconRowPanel), (Object)isLauncherIcon);
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry entry : layoutProperties.entrySet()) {
            ((BoolProperty)entry.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)entry.getKey(), (ObservableValue)entry.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> {
            SwingUtilities.updateComponentTreeUI(this.myForegroundAllOptionsPanel);
            SwingUtilities.updateComponentTreeUI(this.myBackgroundAllOptionsPanel);
            SwingUtilities.updateComponentTreeUI(this.myOtherIconsAllOptionsPanel);
        });
    }

    private void initializeValidators() {
        VisibleProperty isActive = new VisibleProperty(this);
        this.myValidatorPanel.registerTest(Expression.create(() -> isActive.get() == false || this.myBuildSdkVersion.getFeatureLevel() >= 26, isActive), "Project must be built with SDK 26 or later to use adaptive icons");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.nameIsNotEmptyExpression(isActive, this.myForegroundLayerName), "Foreground layer name must be set");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.nameIsNotEmptyExpression(isActive, this.myBackgroundLayerName), "Background layer name must be set");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myForegroundLayerName), "Foreground layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myBackgroundLayerName), "Background layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureAdaptiveIconPanel.namesAreDistinctExpression(isActive, this.myForegroundLayerName, this.myBackgroundLayerName), "Background and foreground layers must have distinct names");
        this.myValidatorPanel.registerValidator(this.myForegroundAssetValidityState, validity -> validity, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(this.myBackgroundAssetValidityState, validity -> validity, new ObservableValue[0]);
    }

    @NotNull
    private static Expression<Boolean> nameIsNotEmptyExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.isEmptyOrSpaces((String)((String)name.get())), isActive, name);
    }

    @NotNull
    private static Expression<Boolean> namesAreDistinctExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name1, @NotNull StringProperty name2) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)name1.get()), (CharSequence)((CharSequence)name2.get())), isActive, name1, name2);
    }

    @Override
    @NotNull
    public AdaptiveIconGenerator getIconGenerator() {
        return this.myIconGenerator;
    }

    @Override
    @NotNull
    public JComponent getRootComponent() {
        return this;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myAssetListeners.add(listener2);
    }

    @Override
    @NotNull
    public StringProperty outputName() {
        return this.myOutputName;
    }

    private void fireAssetListeners() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(e);
        }
    }

    private void updateBindingsAndUiForActiveIconType() {
        this.myOutputName.set(this.myDefaultOutputName);
        this.myForegroundLayerName.set(this.defaultForegroundLayerName());
        this.myBackgroundLayerName.set(this.defaultBackgroundLayerName());
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>((ObservableValue<BaseAsset>)this.myForegroundActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundImageAsset(), this.myBackgroundImageAsset);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundColor(), this.myBackgroundColor);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.showSafeZone(), this.myShowSafeZone);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.generateLegacyIcon(), this.myGenerateLegacyIcon);
        if (this.myIconGenerator instanceof LauncherIconGenerator) {
            LauncherIconGenerator iconGenerator = (LauncherIconGenerator)this.myIconGenerator;
            this.myGeneralBindings.bindTwoWay(iconGenerator.generateRoundIcon(), this.myGenerateRoundIcon);
            this.myGeneralBindings.bindTwoWay(iconGenerator.generatePlayStoreIcon(), this.myGeneratePlayStoreIcon);
            this.myGeneralBindings.bindTwoWay(iconGenerator.legacyIconShape(), this.myLegacyIconShape);
            this.myGeneralBindings.bindTwoWay(iconGenerator.showGrid(), this.myShowGrid);
            this.myGeneralBindings.bindTwoWay(iconGenerator.previewDensity(), this.myPreviewDensity);
        }
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.foregroundLayerName(), this.myForegroundLayerName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundLayerName(), this.myBackgroundLayerName);
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myForegroundActiveAssetBindings.releaseAll();
        this.myBackgroundActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
    }

    @NotNull
    private String defaultForegroundLayerName() {
        return (String)this.myOutputName.get() + "_foreground";
    }

    @NotNull
    private String defaultBackgroundLayerName() {
        return (String)this.myOutputName.get() + "_background";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        TitledSeparator titledSeparator;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JBLabel jBLabel2;
        JPanel jPanel4;
        TitledSeparator titledSeparator2;
        JPanel jPanel5;
        JBLabel jBLabel3;
        JPanel jPanel6;
        JRadioButton jRadioButton3;
        JPanel jPanel7;
        JBLabel jBLabel4;
        JPanel jPanel8;
        JPanel jPanel9;
        JBScrollPane jBScrollPane;
        JLabel jLabel;
        JSlider jSlider;
        JPanel jPanel10;
        JBLabel jBLabel5;
        JPanel jPanel11;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel12;
        JBLabel jBLabel6;
        JPanel jPanel13;
        JPanel jPanel14;
        TitledSeparator titledSeparator3;
        ColorPanel colorPanel;
        JBLabel jBLabel7;
        JPanel jPanel15;
        ImageAssetBrowser imageAssetBrowser;
        JBLabel jBLabel8;
        JPanel jPanel16;
        JPanel jPanel17;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JPanel jPanel18;
        JLabel jLabel2;
        JPanel jPanel19;
        TitledSeparator titledSeparator4;
        JTextField jTextField;
        JBLabel jBLabel9;
        JPanel jPanel20;
        JPanel jPanel21;
        JBScrollPane jBScrollPane2;
        JLabel jLabel3;
        JSlider jSlider2;
        JPanel jPanel22;
        JBLabel jBLabel10;
        JPanel jPanel23;
        JRadioButton jRadioButton8;
        JRadioButton jRadioButton9;
        JPanel jPanel24;
        JBLabel jBLabel11;
        JPanel jPanel25;
        TitledSeparator titledSeparator5;
        JPanel jPanel26;
        ColorPanel colorPanel2;
        JBLabel jBLabel12;
        JPanel jPanel27;
        MultiLineTextAssetEditor multiLineTextAssetEditor;
        JBLabel jBLabel13;
        JPanel jPanel28;
        ClipartIconButton clipartIconButton;
        JBLabel jBLabel14;
        JPanel jPanel29;
        ImageAssetBrowser imageAssetBrowser2;
        JBLabel jBLabel15;
        JPanel jPanel30;
        JPanel jPanel31;
        JRadioButton jRadioButton10;
        JRadioButton jRadioButton11;
        JRadioButton jRadioButton12;
        JPanel jPanel32;
        JLabel jLabel4;
        JPanel jPanel33;
        TitledSeparator titledSeparator6;
        JTextField jTextField2;
        JBLabel jBLabel16;
        JPanel jPanel34;
        JPanel jPanel35;
        JBScrollPane jBScrollPane3;
        JTextField jTextField3;
        JBLabel jBLabel17;
        JPanel jPanel36;
        JPanel jPanel37;
        this.myRootPanel = jPanel37 = new JPanel();
        jPanel37.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOutputNamePanelRow = jPanel36 = new JPanel();
        jPanel36.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel37.add((Component)jPanel36, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel36.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        this.myOutputNameLabel = jBLabel17 = new JBLabel();
        jBLabel17.setText("Name:");
        jPanel36.add((Component)jBLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        JPanel jPanel38 = new JPanel();
        jPanel38.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel36.add((Component)jPanel38, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myOutputNameTextField = jTextField3 = new JTextField();
        jTextField3.setText("(name)");
        jTextField3.setToolTipText("The filename which will be used for these icons.");
        jPanel38.add((Component)jTextField3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jBTabbedPane.setTabPlacement(1);
        jPanel37.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jBTabbedPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        JPanel jPanel39 = new JPanel();
        jPanel39.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Foreground Layer", null, jPanel39, null);
        this.myForegroundScrollPane = jBScrollPane3 = new JBScrollPane();
        jBScrollPane3.setHorizontalScrollBarPolicy(31);
        jPanel39.add((Component)jBScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myForegroundAllOptionsPanel = jPanel35 = new JPanel();
        jPanel35.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel35);
        this.myForegroundLayerNamePanel = jPanel34 = new JPanel();
        jPanel34.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel34).setVisible(true);
        jPanel35.add((Component)jPanel34, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 0, null, null, null, 0, true));
        this.myForegroundLayerNameLabel = jBLabel16 = new JBLabel();
        jBLabel16.setText("Layer name:");
        jPanel34.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel40 = new JPanel();
        jPanel40.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel34.add((Component)jPanel40, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myForegroundLayerNameTextField = jTextField2 = new JTextField();
        jTextField2.setText("(name)");
        jTextField2.setToolTipText("The filename which will be used for these icons.");
        jPanel40.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySourceAssetTitleSeparator = titledSeparator6 = new TitledSeparator();
        titledSeparator6.setText("Source Asset");
        jPanel35.add((Component)titledSeparator6, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundAssetTypePanel = jPanel33 = new JPanel();
        jPanel33.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel35.add((Component)jPanel33, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundAssetTypeLabel = jLabel4 = new JLabel();
        jLabel4.setText("Asset type:");
        jPanel33.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundAssetRadioButtonsPanel = jPanel32 = new JPanel();
        jPanel32.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel32, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myForegroundClipartRadioButton = jRadioButton12 = new JRadioButton();
        jRadioButton12.setText("Clip art");
        jRadioButton12.setToolTipText("Select from a list of clipart choices to generate Android icons for your app.");
        jPanel32.add((Component)jRadioButton12, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundTextRadioButton = jRadioButton11 = new JRadioButton();
        jRadioButton11.setText("Text");
        jRadioButton11.setToolTipText("Enter text which will be rendered into Android icons for your app.");
        jPanel32.add((Component)jRadioButton11, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundImageRadioButton = jRadioButton10 = new JRadioButton();
        jRadioButton10.setText("Image");
        jRadioButton10.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        jPanel32.add((Component)jRadioButton10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundAssetTypeSourcePanel = jPanel31 = new JPanel();
        jPanel31.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel35.add((Component)jPanel31, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImageAssetRowPanel = jPanel30 = new JPanel();
        jPanel30.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel31.add((Component)jPanel30, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImagePathLabel = jBLabel15 = new JBLabel();
        jBLabel15.setText("Path:");
        jPanel30.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundImageAssetBrowser = imageAssetBrowser2 = new ImageAssetBrowser();
        jPanel30.add((Component)((Object)imageAssetBrowser2), new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myForegroundClipartAssetRowPanel = jPanel29 = new JPanel();
        jPanel29.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel31.add((Component)jPanel29, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundClipartLabel = jBLabel14 = new JBLabel();
        jBLabel14.setText("Clip art:");
        jPanel29.add((Component)jBLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundClipartAssetButton = clipartIconButton = new ClipartIconButton();
        jPanel29.add((Component)clipartIconButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 2, null, null, null));
        this.myForegroundTextAssetRowPanel = jPanel28 = new JPanel();
        jPanel28.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel31.add((Component)jPanel28, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundTextLabel = jBLabel13 = new JBLabel();
        jBLabel13.setText("Text:");
        jPanel28.add((Component)jBLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTextAssetEditor = multiLineTextAssetEditor = new MultiLineTextAssetEditor();
        jPanel28.add((Component)multiLineTextAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundColorRowPanel = jPanel27 = new JPanel();
        jPanel27.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel31.add((Component)jPanel27, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundColorLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Color:");
        jPanel27.add((Component)jBLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundColorPanel = colorPanel2 = new ColorPanel();
        colorPanel2.setSelectedColor(new Color(-16777216));
        jPanel27.add((Component)colorPanel2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null));
        this.myForegroundImageOptionsPanel = jPanel26 = new JPanel();
        jPanel26.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel35.add((Component)jPanel26, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundScalingTitleSeparator = titledSeparator5 = new TitledSeparator();
        titledSeparator5.setText("Scaling");
        jPanel26.add((Component)titledSeparator5, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundTrimPanel = jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel25).setVisible(true);
        jPanel26.add((Component)jPanel25, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTrimLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Trim:");
        jPanel25.add((Component)jBLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTrimOptionsPanel = jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel25.add((Component)jPanel24, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel24.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myForegroundTrimYesRadioButton = jRadioButton9 = new JRadioButton();
        jRadioButton9.setText("Yes");
        jRadioButton9.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        jPanel24.add((Component)jRadioButton9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForegroundTrimNoRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setSelected(true);
        jRadioButton8.setText("No");
        jRadioButton8.setToolTipText("Leave the original asset unmodified.");
        jPanel24.add((Component)jRadioButton8, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForegroundResizePanel = jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel23).setVisible(true);
        jPanel26.add((Component)jPanel23, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundResizeLabel = jBLabel10 = new JBLabel();
        jBLabel10.setText("Resize:");
        jPanel23.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundResizeSliderPanel = jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel22, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myForegroundResizeSlider = jSlider2 = new JSlider();
        jSlider2.setMaximum(400);
        jSlider2.setMinimum(0);
        jSlider2.setMinorTickSpacing(20);
        jSlider2.setPaintLabels(false);
        jSlider2.setPaintTicks(true);
        jSlider2.setSnapToTicks(false);
        jSlider2.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jSlider2.setValue(100);
        jSlider2.setValueIsAdjusting(false);
        jPanel22.add((Component)jSlider2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundResizeValueLabel = jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("100 %");
        jPanel22.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel35.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel41 = new JPanel();
        jPanel41.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Background Layer", null, jPanel41, null);
        this.myBackgroundScrollPane = jBScrollPane2 = new JBScrollPane();
        jBScrollPane2.setHorizontalScrollBarPolicy(31);
        jPanel41.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myBackgroundAllOptionsPanel = jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel21);
        this.myBackgroundLayerNamePanel = jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel20).setVisible(true);
        jPanel21.add((Component)jPanel20, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myBackgroundLayerNameLabel = jBLabel9 = new JBLabel();
        jBLabel9.setText("Layer name:");
        jPanel20.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel42 = new JPanel();
        jPanel42.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel42, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myBackgroundLayerNameTextField = jTextField = new JTextField();
        jTextField.setText("(name)");
        jTextField.setToolTipText("The filename which will be used for these icons.");
        jPanel42.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundSourceAssetTitleSeparator = titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("Source Asset");
        jPanel21.add((Component)titledSeparator4, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundAssetTypePanel = jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel19, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundAssetTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Asset type:");
        jPanel19.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundAssetRadioButtonsPanel = jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel18, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myBackgroundImageRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Image");
        jRadioButton7.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        jPanel18.add((Component)jRadioButton7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundColorRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Color");
        jRadioButton6.setToolTipText("Select from a background color for the Android icons for your app.");
        jPanel18.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundAssetTypeSourcePanel = jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel17, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundImageAssetRowPanel = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel16, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundImagePathLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("Path:");
        jPanel16.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundImageAssetBrowser = imageAssetBrowser = new ImageAssetBrowser();
        jPanel16.add((Component)((Object)imageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundColorRowPanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel15, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundColorLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("Color:");
        jPanel15.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundColorPanel = colorPanel = new ColorPanel();
        colorPanel.setSelectedColor(new Color(-16777216));
        jPanel15.add((Component)colorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(78, -1), null, null));
        this.myBackgroundScalingTitleSeparator = titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Scaling");
        jPanel17.add((Component)titledSeparator3, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundImageOptionsPanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel14, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundTrimRowPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel13).setVisible(true);
        jPanel14.add((Component)jPanel13, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundTrimLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Trim:");
        jPanel13.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundTrimOptionsPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel12.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBackgroundTrimYesRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Yes");
        jRadioButton5.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        jPanel12.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundTrimNoRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        jRadioButton4.setText("No");
        jRadioButton4.setToolTipText("Leave the original asset unmodified.");
        jPanel12.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundResizeRowPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel11).setVisible(true);
        jPanel14.add((Component)jPanel11, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundResizeLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Resize:");
        jPanel11.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundResizeSliderPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel10, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBackgroundResizeSlider = jSlider = new JSlider();
        jSlider.setMaximum(400);
        jSlider.setMinimum(0);
        jSlider.setMinorTickSpacing(20);
        jSlider.setPaintLabels(false);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(false);
        jSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jSlider.setValue(100);
        jPanel10.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundResizeValueLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText("100 %");
        jPanel10.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel21.add((Component)spacer4, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel43 = new JPanel();
        jPanel43.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Options", null, jPanel43, null);
        this.myOtherIconsScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel43.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myOtherIconsAllOptionsPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel9);
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        TitledSeparator titledSeparator7 = new TitledSeparator();
        titledSeparator7.setText("Legacy Icon (API \u2264 25)");
        jPanel9.add((Component)titledSeparator7, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateLegacyIconRowPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setVisible(true);
        jPanel9.add((Component)jPanel8, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateLegacyIconLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Generate:");
        jPanel8.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.mGenerateLegacyIconRadioButtonsPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateLegacyIconYesRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        jRadioButton3.setText("Yes");
        jRadioButton3.setToolTipText("Generate legacy icon (API \u2264 25)");
        jPanel7.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton13 = new JRadioButton();
        jRadioButton13.setSelected(false);
        jRadioButton13.setText("No");
        jRadioButton13.setToolTipText("");
        jPanel7.add((Component)jRadioButton13, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel7.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLegacyIconShapeRowPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myLegacyIconShapeLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Shape:");
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myLegacyIconShapePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myLegacyIconShapeComboBox = jComboBox;
        jComboBox.setToolTipText("The shape of the launcher icon's backdrop.");
        jPanel5.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel5.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myGenerateRoundIconTitle = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Round Icon (API = 25)");
        jPanel9.add((Component)titledSeparator2, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateRoundIconRowPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel9.add((Component)jPanel4, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateRoundIconLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Generate:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myGenerateRoundIconRadioButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateRoundIconYesRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Yes");
        jRadioButton2.setToolTipText("Generate round icon (API 25)");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton14 = new JRadioButton();
        jRadioButton14.setSelected(false);
        jRadioButton14.setText("No");
        jRadioButton14.setToolTipText("");
        jPanel3.add((Component)jRadioButton14, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel3.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myGeneratePlayStoreIconTitle = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Google Play Store Icon");
        jPanel9.add((Component)titledSeparator, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGeneratePlayStoreIconRowPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel9.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGeneratePlayStoreIconLabel = jBLabel = new JBLabel();
        jBLabel.setText("Generate:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myGeneratePlayStoreIconRadioButtonsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGeneratePlayStoreIconYesRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setText("Yes");
        jRadioButton.setToolTipText("Generate icon for Google Play Store (512x512)");
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton15 = new JRadioButton();
        jRadioButton15.setSelected(false);
        jRadioButton15.setText("No");
        jRadioButton15.setToolTipText("");
        jPanel.add((Component)jRadioButton15, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel9.add((Component)spacer9, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton10);
        buttonGroup.add(jRadioButton12);
        buttonGroup.add(jRadioButton11);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton9);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton13);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton14);
        buttonGroup.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton15);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static enum BackgroundAssetType {
        IMAGE,
        COLOR;

    }

    private static enum ForegroundAssetType {
        IMAGE,
        CLIP_ART,
        TEXT;

    }
}

