/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.material.icons.download;

import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.tools.idea.npw.assetstudio.material.icons.download.IconsUpdateData;
import com.android.tools.idea.npw.assetstudio.material.icons.download.MaterialIconsUpdater;
import com.android.tools.idea.npw.assetstudio.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.npw.assetstudio.material.icons.metadata.MaterialIconsMetadataBuilder;
import com.android.tools.idea.npw.assetstudio.material.icons.metadata.MaterialMetadataIcon;
import com.android.tools.idea.npw.assetstudio.material.icons.utils.MaterialIconsUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a \u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002\u001a\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a \u0010\u0019\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cleanUpDownloadDirectories", "", "downloadedFiles", "", "Ljava/io/File;", "cleanupUnusedIcons", "existingMetadata", "Lcom/android/tools/idea/npw/assetstudio/material/icons/metadata/MaterialIconsMetadata;", "targetDir", "Ljava/nio/file/Path;", "createMaterialIconFileDescription", "Lcom/intellij/util/download/DownloadableFileDescription;", "iconMetadata", "Lcom/android/tools/idea/npw/assetstudio/material/icons/metadata/MaterialMetadataIcon;", "style", "", "downloadIconStyles", "getIconsUpdateData", "Lcom/android/tools/idea/npw/assetstudio/material/icons/download/IconsUpdateData;", "oldMetadata", "newMetadata", "renameDownloadedFiles", "updateIconsAtDir", "updateSavedMetadata", "metadataBuilder", "Lcom/android/tools/idea/npw/assetstudio/material/icons/metadata/MaterialIconsMetadataBuilder;", "intellij.android.newProjectWizard"})
public final class MaterialIconsUpdaterKt {
    @NotNull
    private static final Logger log;

    @Slow
    public static final void updateIconsAtDir(@NotNull MaterialIconsMetadata existingMetadata, @NotNull MaterialIconsMetadata newMetadata, @NotNull Path targetDir) {
        MaterialMetadataIcon iconMetadata;
        MaterialMetadataIcon element$iv;
        Intrinsics.checkNotNullParameter((Object)existingMetadata, (String)"existingMetadata");
        Intrinsics.checkNotNullParameter((Object)newMetadata, (String)"newMetadata");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        MaterialIconsUpdaterKt.cleanupUnusedIcons(existingMetadata, targetDir);
        MaterialIconsMetadataBuilder metadataBuilder = new MaterialIconsMetadataBuilder(existingMetadata.getHost(), existingMetadata.getUrlPattern(), existingMetadata.getFamilies());
        MaterialMetadataIcon[] $this$forEach$iv = existingMetadata.getIcons();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MaterialMetadataIcon p0 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            metadataBuilder.addIconMetadata(p0);
        }
        IconsUpdateData updateData = MaterialIconsUpdaterKt.getIconsUpdateData(existingMetadata, newMetadata);
        Iterable $this$forEach$iv2 = updateData.getIconsToRemove();
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv2.iterator();
        while (iterator2.hasNext()) {
            iconMetadata = element$iv = iterator2.next();
            boolean bl = false;
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            try {
                metadataBuilder.removeIconMetadata(iconMetadata);
                MaterialIconsUpdaterKt.updateSavedMetadata(targetDir, metadataBuilder);
            }
            catch (Exception e) {
                log.warn("Error while removing metadata for: '" + iconMetadata.getName() + "'", (Throwable)e);
            }
        }
        $this$forEach$iv2 = updateData.getIconsToDownload();
        $i$f$forEach2 = false;
        iterator2 = $this$forEach$iv2.iterator();
        while (iterator2.hasNext()) {
            iconMetadata = element$iv = iterator2.next();
            boolean bl = false;
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            try {
                MaterialIconsUpdaterKt.downloadIconStyles(existingMetadata, targetDir, iconMetadata);
                metadataBuilder.addIconMetadata(iconMetadata);
                MaterialIconsUpdaterKt.updateSavedMetadata(targetDir, metadataBuilder);
            }
            catch (Exception e) {
                log.warn("Error while downloading '" + iconMetadata.getName() + "'", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanupUnusedIcons(MaterialIconsMetadata existingMetadata, Path targetDir) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        String[] $this$map$iv = existingMetadata.getFamilies();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        MaterialMetadataIcon[] destination$iv$iv = (MaterialMetadataIcon[])new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv2).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_18 = item$iv$iv = $this$mapTo$iv$iv2[i];
            object = destination$iv$iv;
            boolean bl = false;
            object.add(MaterialIconsUtils.INSTANCE.toDirFormat((String)it));
        }
        Set styleDirNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        MaterialMetadataIcon[] $this$map$iv2 = existingMetadata.getIcons();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
        boolean $i$f$mapTo2 = false;
        int item$iv$iv = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < item$iv$iv; ++n) {
            void it;
            void item$iv$iv2;
            void bl = item$iv$iv2 = $this$mapTo$iv$iv[n];
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(it.getName());
        }
        Set iconNamesSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        ArrayList<Path> unusedIconDirPaths = new ArrayList<Path>();
        CancellableFileIo.walkFileTree((Path)targetDir, (Set)SetsKt.emptySet(), (int)2, (FileVisitor)new SimpleFileVisitor<Path>((Set<String>)styleDirNames, targetDir, (Set<String>)iconNamesSet, unusedIconDirPaths){
            final /* synthetic */ Set<String> $styleDirNames;
            final /* synthetic */ Path $targetDir;
            final /* synthetic */ Set<String> $iconNamesSet;
            final /* synthetic */ ArrayList<Path> $unusedIconDirPaths;
            {
                this.$styleDirNames = $styleDirNames;
                this.$targetDir = $targetDir;
                this.$iconNamesSet = $iconNamesSet;
                this.$unusedIconDirPaths = $unusedIconDirPaths;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (this.$styleDirNames.contains(PathsKt.getName((Path)dir)) || Files.isSameFile(this.$targetDir, dir)) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (attrs.isDirectory() && !this.$iconNamesSet.contains(PathsKt.getName((Path)file2))) {
                    this.$unusedIconDirPaths.add(file2);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Iterable $this$forEach$iv = unusedIconDirPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path2 = (Path)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            try {
                PathKt.delete((Path)path2, (boolean)true);
            }
            catch (Exception e) {
                log.warn("Error deleting unused icon directory: " + PathsKt.getName((Path)path2), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void downloadIconStyles(MaterialIconsMetadata existingMetadata, Path targetDir, MaterialMetadataIcon iconMetadata) {
        void $this$mapTo$iv$iv;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        String[] $this$map$iv = existingMetadata.getFamilies();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo22 = false;
        int n = ((void)$this$mapTo$iv$iv2).length;
        for (int i = 0; i < n; ++i) {
            void style;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv2[i];
            collection2 = destination$iv$iv;
            boolean bl = false;
            Path path2 = targetDir.resolve(MaterialIconsUtils.INSTANCE.toDirFormat((String)style));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"targetDir.resolve(style.toDirFormat())");
            PathKt.createDirectories((Path)path2);
            collection2.add(MaterialIconsUpdaterKt.createMaterialIconFileDescription(existingMetadata, iconMetadata, (String)style));
        }
        List fileDescriptions = (List)destination$iv$iv;
        FileDownloader fileDownloader = DownloadableFileService.getInstance().createDownloader(fileDescriptions, "Material Icons");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"getInstance().createDown\u2026ptions, \"Material Icons\")");
        FileDownloader downloader = fileDownloader;
        List list2 = downloader.download(targetDir.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"downloader.download(targetDir.toFile())");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add((File)it.first);
        }
        List downloaded = (List)destination$iv$iv2;
        List<File> renamedFiles = MaterialIconsUpdaterKt.renameDownloadedFiles(downloaded);
        MaterialIconsUpdaterKt.cleanUpDownloadDirectories(renamedFiles);
    }

    private static final DownloadableFileDescription createMaterialIconFileDescription(MaterialIconsMetadata existingMetadata, MaterialMetadataIcon iconMetadata, String style) {
        String styleDirName = MaterialIconsUtils.INSTANCE.toDirFormat(style);
        String iconName = iconMetadata.getName();
        String host = existingMetadata.getHost();
        String pattern = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)existingMetadata.getUrlPattern(), (String)"{family}", (String)styleDirName, (boolean)false, (int)4, null), (String)"{icon}", (String)iconName, (boolean)false, (int)4, null), (String)"{version}", (String)String.valueOf(iconMetadata.getVersion()), (boolean)false, (int)4, null), (String)"{asset}", (String)"24px.xml", (boolean)false, (int)4, null);
        String string = "https://%1s%2s";
        Object[] objectArray = new Object[]{host, pattern};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        String downloadUrl = string2;
        String fileName = styleDirName + File.separatorChar + iconName + File.separatorChar + MaterialIconsUtils.INSTANCE.getIconFileNameWithoutExtension(iconName, styleDirName) + ".tmp";
        DownloadableFileDescription downloadableFileDescription = DownloadableFileService.getInstance().createFileDescription(downloadUrl, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFileDescription, (String)"getInstance().createFile\u2026on(downloadUrl, fileName)");
        return downloadableFileDescription;
    }

    /*
     * Unable to fully structure code
     */
    private static final IconsUpdateData getIconsUpdateData(MaterialIconsMetadata oldMetadata, MaterialIconsMetadata newMetadata) {
        $this$associateBy$iv = oldMetadata.getIcons();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        var6_7 = $this$associateBy$iv;
        destination$iv$iv = (MaterialMetadataIcon[])new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateByTo = false;
        var10_19 = ((void)$this$associateByTo$iv$iv).length;
        for (var9_16 = 0; var9_16 < var10_19; ++var9_16) {
            var12_23 = element$iv$iv = $this$associateByTo$iv$iv[var9_16];
            var16_28 = destination$iv$iv;
            $i$a$-associateBy-MaterialIconsUpdaterKt$getIconsUpdateData$existingIconsMap$1 = false;
            var16_28.put(it.getName(), element$iv$iv);
        }
        existingIconsMap = destination$iv$iv;
        $this$associateBy$iv = newMetadata.getIcons();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateByTo = false;
        element$iv$iv = ((void)$this$associateByTo$iv$iv).length;
        for (var10_19 = 0; var10_19 < element$iv$iv; ++var10_19) {
            $i$a$-associateBy-MaterialIconsUpdaterKt$getIconsUpdateData$existingIconsMap$1 = element$iv$iv = $this$associateByTo$iv$iv[var10_19];
            var16_28 = destination$iv$iv;
            $i$a$-associateBy-MaterialIconsUpdaterKt$getIconsUpdateData$newIconsMap$1 = false;
            var16_28.put(it.getName(), element$iv$iv);
        }
        newIconsMap = destination$iv$iv;
        iconsToRemove = new ArrayList<MaterialMetadataIcon>();
        $this$forEach$iv = oldMetadata.getIcons();
        $i$f$forEach = false;
        destination$iv$iv = $this$forEach$iv.length;
        for ($this$associateByTo$iv$iv = 0; $this$associateByTo$iv$iv < destination$iv$iv; ++$this$associateByTo$iv$iv) {
            icon = element$iv = $this$forEach$iv[$this$associateByTo$iv$iv];
            $i$a$-forEach-MaterialIconsUpdaterKt$getIconsUpdateData$1 = false;
            if (newIconsMap.containsKey(icon.getName())) continue;
            iconsToRemove.add(icon);
        }
        $this$filter$iv = newMetadata.getIcons();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var12_24 = ((void)$this$filterTo$iv$iv).length;
        for (var11_22 = 0; var11_22 < var12_24; ++var11_22) {
            it = element$iv$iv = $this$filterTo$iv$iv[var11_22];
            $i$a$-filter-MaterialIconsUpdaterKt$getIconsUpdateData$iconsToDownload$1 = false;
            if (existingIconsMap.get(it.getName()) == null) ** GOTO lbl-1000
            v0 = existingIconsMap.get(it.getName());
            Intrinsics.checkNotNull(v0);
            if (((MaterialMetadataIcon)v0).getVersion() < it.getVersion()) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        iconsToDownload = (List)destination$iv$iv;
        if (((Collection)iconsToRemove).isEmpty() == false) {
            MaterialIconsUpdaterKt.log.info(iconsToRemove.size() + " icons removed from metadata.");
        }
        if (((Collection)iconsToDownload).isEmpty() == false) {
            MaterialIconsUpdaterKt.log.info(iconsToDownload.size() + " icons to download.");
        }
        return new IconsUpdateData((List<MaterialMetadataIcon>)iconsToRemove, iconsToDownload);
    }

    private static final void updateSavedMetadata(Path targetDir, MaterialIconsMetadataBuilder metadataBuilder) {
        Path path2 = targetDir.resolve("icons_metadata.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"targetDir.resolve(METADATA_FILE_NAME)");
        PathsKt.writeText$default((Path)path2, (CharSequence)MaterialIconsMetadata.Companion.toJsonText(metadataBuilder.build()), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void cleanUpDownloadDirectories(List<? extends File> downloadedFiles) {
        Iterable $this$forEach$iv = downloadedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list2;
            File[] fileArray;
            File downloadedFile = (File)element$iv;
            boolean bl = false;
            File iconDirectory = downloadedFile.getParentFile();
            if (fileArray != null) {
                void $this$filterTo$iv$iv;
                fileArray = iconDirectory.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles()");
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)downloadedFile.getName()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List filesToCleanUp = list2;
            Iterable $this$forEach$iv2 = filesToCleanUp;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File it = (File)element$iv2;
                boolean bl3 = false;
                if (it.delete()) continue;
                throw new IllegalStateException("Unable to delete file: " + it.getName());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> renameDownloadedFiles(List<? extends File> downloadedFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = downloadedFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void downloadedFile;
            File file2 = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            File iconDir = downloadedFile.getParentFile();
            String iconName = iconDir.getName();
            String styleDirName = iconDir.getParentFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)iconName, (String)"iconName");
            Intrinsics.checkNotNullExpressionValue((Object)styleDirName, (String)"styleDirName");
            String newIconFileName = MaterialIconsUtils.INSTANCE.getIconFileNameWithoutExtension(iconName, styleDirName) + ".xml";
            Intrinsics.checkNotNullExpressionValue((Object)iconDir, (String)"iconDir");
            File destFile = FilesKt.resolve((File)iconDir, (String)newIconFileName);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            collection2.add(Files.move(downloadedFile.toPath(), destFile.toPath(), copyOptionArray).toFile());
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger2 = Logger.getInstance(MaterialIconsUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(MaterialIconsUpdater::class.java)");
        log = logger2;
    }
}

