/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TvChannelIconGenerator
extends AdaptiveIconGenerator {
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 120, 120);
    private static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 73, 73);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 80, 80);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 80, 80);
    private static final Density LEGACY_DENSITY = Density.XHIGH;
    private static final double PREVIEW_SCALE = 0.6;

    public TvChannelIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
    }

    @Override
    @NotNull
    public TvChannelIconOptions createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        double scaleFactor;
        TvChannelIconOptions options2 = new TvChannelIconOptions(forPreview);
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            Color color;
            options2.useForegroundColor = foregroundAsset.isColorable();
            Color color2 = color = foregroundAsset.isColorable() ? (Color)foregroundAsset.color().getValueOrNull() : null;
            if (color != null) {
                options2.foregroundColor = color.getRGB();
            }
            scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof ImageAsset && ((ImageAsset)foregroundAsset).isClipart()) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
            }
            options2.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, color, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        if ((backgroundAsset = this.backgroundImageAsset().getValueOrNull()) != null) {
            scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options2.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        options2.backgroundColor = ((Color)this.backgroundColor().get()).getRGB();
        options2.showSafeZone = (Boolean)this.showSafeZone().get();
        options2.previewDensity = LEGACY_DENSITY;
        options2.foregroundLayerName = (String)this.foregroundLayerName().get();
        options2.backgroundLayerName = (String)this.backgroundLayerName().get();
        options2.generateLegacyIcon = (Boolean)this.generateLegacyIcon().get();
        return options2;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context2, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        TvChannelIconOptions launcherIconOptions = (TvChannelIconOptions)options2;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context2, name, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, launcherIconOptions, tasks);
        this.createPreviewImagesTasks(context2, launcherIconOptions, tasks);
        return tasks;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context2, @NotNull String name, @NotNull TvChannelIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options2.generateOutputIcons) {
            return;
        }
        TvChannelIconOptions localOptions = options2.clone();
        localOptions.density = LEGACY_DENSITY;
        this.createOutputIconsForSingleDensityTasks(context2, name, localOptions, localOptions.density, tasks);
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context2, @NotNull String name, @NotNull TvChannelIconOptions options2, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (options2.foregroundImage != null && options2.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvChannelIconOptions foregroundOptions = options2.clone();
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context2, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options2.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                TvChannelIconOptions backgroundOptions = options2.clone();
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context2, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options2.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options2.generateLegacyIcon) {
            tasks.add(() -> {
                TvChannelIconOptions legacyOptions = options2.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = this.generateLegacyImage(context2, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, density, legacy);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull TvChannelIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        TransformedImageAsset image;
        if (!options2.generateOutputIcons) {
            return;
        }
        TvChannelIconOptions iconOptions = options2.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (options2.foregroundImage != null && options2.foregroundImage.isDrawable()) {
            image = options2.foregroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvChannelIconOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    TvChannelIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    TvChannelIconGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isDrawable()) {
            image = options2.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                TvChannelIconOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    TvChannelIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    TvChannelIconGenerator.getLog().error("Transformed background drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options2.backgroundImage == null) {
            tasks.add(() -> {
                TvChannelIconOptions iconOptions = options2.clone();
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    private void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context2, @NotNull TvChannelIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options2.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>(2);
        previewShapes.add(PreviewShape.ADAPTIVE);
        if (options2.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                TvChannelIconOptions localOptions = options2.clone();
                localOptions.density = options2.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                try {
                    image = this.generatePreviewImage(context2, localOptions);
                }
                catch (Throwable e) {
                    TvChannelIconGenerator.getLog().error(e);
                    image = TvChannelIconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context2, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        TvChannelIconOptions launcherIconOptions = (TvChannelIconOptions)options2;
        TvChannelIconOptions localOptions = launcherIconOptions.clone();
        Collection<GeneratedIcon> icons = this.generateIcons(context2, options2, name);
        icons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> icon2.getOutputPath() != null).forEach(icon2 -> {
            assert (icon2.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon2.getCategory().toString(), k -> new LinkedHashMap());
            TvChannelIconOptions iconOptions = localOptions.clone();
            iconOptions.density = icon2.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            imageMap.put(icon2.getOutputPath().toString(), new AnnotatedImage(icon2.getImage(), icon2.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context2, @NotNull IconGenerator.IconOptions options2) {
        if (options2.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        return this.generatePreviewImage(context2, (TvChannelIconOptions)options2);
    }

    @NotNull
    private AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context2, @NotNull TvChannelIconOptions options2) {
        switch (options2.previewShape) {
            case ADAPTIVE: {
                return this.generateViewportPreviewImage(context2, options2);
            }
            case LEGACY: {
                return this.generateLegacyImage(context2, options2);
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context2, @NotNull TvChannelIconOptions options2) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context2, options2, null);
        BufferedImage image = this.cropImageToViewport(options2, mergedImage.getImage());
        if (options2.generatePreviewIcons && options2.showSafeZone) {
            TvChannelIconGenerator.drawSafeZone(image);
        }
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @NotNull
    private AnnotatedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context2, @NotNull TvChannelIconOptions options2) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context2, options2, null);
        BufferedImage image = this.cropImageToViewport(options2, mergedImage.getImage());
        if (options2.showSafeZone) {
            TvChannelIconGenerator.drawSafeZone(image);
        }
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    private static void drawSafeZone(@NotNull BufferedImage image) {
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        gOut.setColor(c);
        gOut.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(gOut, 1.0);
        g.drawCenteredCircle(image.getWidth() / 2, image.getHeight() / 2, AssetStudioUtils.roundToInt((double)image.getWidth() * 0.4583333333333333));
        gOut.dispose();
    }

    @Override
    @NotNull
    protected Rectangle getFullBleedRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, TvChannelIconGenerator.computeScaleFactor(options2));
    }

    @Override
    @NotNull
    protected Rectangle getViewportRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, TvChannelIconGenerator.computeScaleFactor(options2));
    }

    @Override
    @NotNull
    protected Rectangle getLegacyRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, TvChannelIconGenerator.computeScaleFactor(options2));
    }

    private static double computeScaleFactor(@NotNull IconGenerator.IconOptions options2) {
        double scaleFactor = TvChannelIconGenerator.getMdpiScaleFactor(TvChannelIconGenerator.getDensity(options2));
        if (((TvChannelIconOptions)options2).generatePreviewIcons) {
            scaleFactor *= 0.6;
        }
        return scaleFactor;
    }

    @NotNull
    private static Density getDensity(@NotNull IconGenerator.IconOptions options2) {
        return ((TvChannelIconOptions)options2).previewShape == PreviewShape.LEGACY ? options2.density : Density.XXXHIGH;
    }

    @Override
    protected Rectangle getMaxIconRectangle() {
        return IMAGE_SIZE_FULL_BLEED_DP;
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return density == LEGACY_DENSITY;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(TvChannelIconGenerator.class);
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        ADAPTIVE("adaptive", "Adaptive (anydpi)"),
        LEGACY("legacy", "Legacy (xhdpi)");

        public final String id;
        public final String displayName;

        private PreviewShape(String id2, String displayName2) {
            this.id = id2;
            this.displayName = displayName2;
        }
    }

    public static class TvChannelIconOptions
    extends AdaptiveIconGenerator.AdaptiveIconOptions
    implements Cloneable {
        public PreviewShape previewShape = PreviewShape.NONE;

        public TvChannelIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public TvChannelIconOptions clone() {
            return (TvChannelIconOptions)super.clone();
        }
    }
}

