/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.util.AssetUtil;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.rendering.Gravity;
import com.android.tools.idea.rendering.VectorDrawableTransformer;
import com.google.common.util.concurrent.Futures;
import com.intellij.util.ExceptionUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransformedImageAsset {
    @Nullable
    private final Future<BufferedImage> myImageFuture;
    @Nullable
    private final Future<String> myDrawableFuture;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @Nullable
    private final Color myTint;
    private final double myOpacity;
    private final boolean myIsTrimmed;
    @NotNull
    private final String myLineSeparator;
    @NotNull
    private final Dimension myTargetSize;
    @Nullable
    private Rectangle2D myTrimRectangle;
    private double myScaleFactor;
    @Nullable
    private Point2D myShift;
    @NotNull
    private Gravity myGravity;
    @Nullable
    private String myTransformedDrawable;
    @Nullable
    private BufferedImage myTrimmedImage;
    private final Object myLock = new Object();
    private static final Pattern LINE_ENDING_PATTERN = Pattern.compile("(\r\n|\n)");

    public TransformedImageAsset(@NotNull BaseAsset asset, @NotNull Dimension targetSize, double scaleFactor, @Nullable Color tint, @NotNull GraphicGeneratorContext context2, @NotNull String lineSeparator) {
        this.myDrawableFuture = asset instanceof ImageAsset ? ((ImageAsset)asset).getXmlDrawable() : (asset instanceof TextAsset ? ((TextAsset)asset).getXmlDrawable() : null);
        this.myImageFuture = this.myDrawableFuture == null ? asset.toImage() : null;
        this.myTint = asset instanceof TextAsset && ((Color)asset.color().getValue()).equals(tint) ? null : tint;
        this.myOpacity = asset instanceof TextAsset ? 1.0 : (double)((Integer)asset.opacityPercent().get()).intValue() / 100.0;
        this.myIsTrimmed = (Boolean)asset.trimmed().get();
        this.myTargetSize = targetSize;
        this.myScaleFactor = scaleFactor;
        this.myContext = context2;
        this.myGravity = Gravity.CENTER;
        this.myLineSeparator = lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Point2D getShift() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myShift;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShift(@Nullable Point2D shift) {
        Object object = this.myLock;
        synchronized (object) {
            this.myShift = shift;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Gravity getGravity() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myGravity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGravity(@NotNull Gravity gravity) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGravity = gravity;
        }
    }

    public boolean isDrawable() {
        return this.myDrawableFuture != null;
    }

    public boolean isRasterImage() {
        return this.myImageFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    @Nullable
    public String getTransformedDrawable() {
        if (this.myDrawableFuture == null) {
            return null;
        }
        try {
            Object object = this.myLock;
            synchronized (object) {
                String xmlDrawable = this.myDrawableFuture.get();
                if (xmlDrawable == null) {
                    return null;
                }
                if (this.myTransformedDrawable == null) {
                    xmlDrawable = LINE_ENDING_PATTERN.matcher(xmlDrawable).replaceAll(this.myLineSeparator);
                    Rectangle2D clipRectangle = this.myIsTrimmed ? this.getTrimRectangle(xmlDrawable) : null;
                    this.myTransformedDrawable = VectorDrawableTransformer.transform(xmlDrawable, this.myTargetSize, this.myGravity, this.myScaleFactor, clipRectangle, this.myShift, this.myTint, this.myOpacity, false);
                }
                return this.myTransformedDrawable;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @Slow
    @NotNull
    public BufferedImage getTransformedImage(@NotNull Dimension imageSize) {
        BufferedImage trimmedImage;
        String drawable;
        if (this.isDrawable() && (drawable = this.getTransformedDrawable()) != null) {
            Future<BufferedImage> future2 = this.myContext.renderDrawable(drawable, imageSize);
            try {
                return future2.get();
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow((Throwable)e.getCause());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((trimmedImage = this.getTrimmedImage()) == null) {
            return this.createErrorImage(imageSize);
        }
        return this.applyScaleShiftTintAndOpacity(imageSize, trimmedImage);
    }

    @NotNull
    public BufferedImage createErrorImage(@NotNull Dimension imageSize) {
        return this.applyScaleShiftTintAndOpacity(imageSize, AssetStudioUtils.createPlaceholderImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private BufferedImage applyScaleShiftTintAndOpacity(@NotNull Dimension imageSize, @NotNull BufferedImage sourceImage) {
        AssetUtil.Effect[] effectArray;
        double y;
        double x;
        int height;
        int width;
        Object object = this.myLock;
        synchronized (object) {
            double scaleFactor = Math.min(imageSize.getWidth() * this.myScaleFactor / (double)sourceImage.getWidth(), imageSize.getHeight() * this.myScaleFactor / (double)sourceImage.getHeight());
            width = AssetStudioUtils.roundToInt((double)sourceImage.getWidth() * scaleFactor);
            height = AssetStudioUtils.roundToInt((double)sourceImage.getHeight() * scaleFactor);
            x = (double)(imageSize.width - width) / 2.0;
            y = (double)(imageSize.height - height) / 2.0;
            if (this.myShift != null) {
                x += imageSize.getWidth() * this.myShift.getX();
                y += imageSize.getHeight() * this.myShift.getY();
            }
        }
        BufferedImage scaledImage = AssetUtil.scaledImage((BufferedImage)sourceImage, (int)width, (int)height);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageSize.width, (int)imageSize.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        if (this.myTint == null || this.myOpacity == 0.0) {
            effectArray = AssetUtil.NO_EFFECTS;
        } else {
            AssetUtil.FillEffect[] fillEffectArray = new AssetUtil.FillEffect[1];
            effectArray = fillEffectArray;
            fillEffectArray[0] = new AssetUtil.FillEffect((Paint)this.myTint, this.myOpacity);
        }
        AssetUtil.Effect[] effects = effectArray;
        AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)scaledImage, (int)AssetStudioUtils.roundToInt(x), (int)AssetStudioUtils.roundToInt(y), (AssetUtil.Effect[])effects);
        g.dispose();
        return outImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getScaleFactor() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myScaleFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double applyAdditionalScaleFactor(double scale) {
        Object object = this.myLock;
        synchronized (object) {
            this.myScaleFactor *= scale;
            return this.myScaleFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BufferedImage getTrimmedImage() {
        if (this.myImageFuture == null) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTrimmedImage == null) {
                try {
                    BufferedImage image = this.myImageFuture.get();
                    this.myTrimmedImage = this.myIsTrimmed ? AssetStudioUtils.trim(image) : image;
                }
                catch (InterruptedException | ExecutionException e) {
                    return null;
                }
            }
            return this.myTrimmedImage;
        }
    }

    @NotNull
    private Rectangle2D getTrimRectangle(@NotNull String xmlDrawable) {
        if (this.myTrimRectangle == null) {
            this.myTrimRectangle = this.calculateTrimRectangle(xmlDrawable);
        }
        return this.myTrimRectangle;
    }

    @NotNull
    private Rectangle2D calculateTrimRectangle(@NotNull String xmlDrawable) {
        Future<BufferedImage> futureImage = this.myContext.renderDrawable(xmlDrawable, this.myTargetSize);
        Future rectangleFuture = Futures.lazyTransform(futureImage, image -> {
            Rectangle bounds = ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, null);
            if (bounds == null) {
                return new Rectangle(this.myTargetSize);
            }
            double width = this.myTargetSize.getWidth();
            double height = this.myTargetSize.getHeight();
            return new Rectangle2D.Double(bounds.getX() / width, bounds.getY() / height, bounds.getWidth() / width, bounds.getHeight() / height);
        });
        try {
            return (Rectangle2D)rectangleFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return new Rectangle(this.myTargetSize);
        }
    }
}

