/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherLegacyIconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherIconGenerator
extends AdaptiveIconGenerator {
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    public static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX = new Rectangle(0, 0, 768, 768);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_PREVIEW_PLAY_STORE_PX = new Rectangle(0, 0, 528, 529);
    private static final Rectangle IMAGE_SIZE_TARGET_PLAY_STORE_PX = new Rectangle(8, 4, 528, 529);
    private final BoolProperty myGenerateRoundIcon = new BoolValueProperty(true);
    private final BoolProperty myGeneratePlayStoreIcon = new BoolValueProperty(true);
    private final ObjectProperty<IconGenerator.Shape> myLegacyIconShape = new ObjectValueProperty<IconGenerator.Shape>(IconGenerator.Shape.SQUARE);
    private final BoolProperty myShowGrid = new BoolValueProperty();
    private final ObjectValueProperty<Density> myPreviewDensity = new ObjectValueProperty<Density>(Density.XHIGH);

    public LauncherIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
    }

    @NotNull
    public BoolProperty generateRoundIcon() {
        return this.myGenerateRoundIcon;
    }

    @NotNull
    public BoolProperty generatePlayStoreIcon() {
        return this.myGeneratePlayStoreIcon;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> legacyIconShape() {
        return this.myLegacyIconShape;
    }

    @NotNull
    public BoolProperty showGrid() {
        return this.myShowGrid;
    }

    @NotNull
    public ObjectValueProperty<Density> previewDensity() {
        return this.myPreviewDensity;
    }

    @Override
    @NotNull
    public LauncherIconOptions createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        double scaleFactor;
        LauncherIconOptions options2 = new LauncherIconOptions(forPreview);
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            Color color;
            options2.useForegroundColor = foregroundAsset.isColorable();
            Color color2 = color = foregroundAsset.isColorable() ? (Color)foregroundAsset.color().getValueOrNull() : null;
            if (color != null) {
                options2.foregroundColor = color.getRGB();
            }
            scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof ImageAsset && ((ImageAsset)foregroundAsset).isClipart()) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
            }
            options2.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, color, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        if ((backgroundAsset = this.backgroundImageAsset().getValueOrNull()) != null) {
            scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options2.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        options2.backgroundColor = ((Color)this.backgroundColor().get()).getRGB();
        options2.showGrid = (Boolean)this.myShowGrid.get();
        options2.showSafeZone = (Boolean)this.showSafeZone().get();
        options2.previewDensity = this.myPreviewDensity.get();
        options2.foregroundLayerName = (String)this.foregroundLayerName().get();
        options2.backgroundLayerName = (String)this.backgroundLayerName().get();
        options2.generateLegacyIcon = (Boolean)this.generateLegacyIcon().get();
        options2.legacyIconShape = (IconGenerator.Shape)((Object)this.myLegacyIconShape.get());
        options2.generateRoundIcon = (Boolean)this.myGenerateRoundIcon.get();
        options2.generatePlayStoreIcon = (Boolean)this.myGeneratePlayStoreIcon.get();
        return options2;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context2, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options2;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context2, name, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, launcherIconOptions, tasks);
        this.createPreviewImagesTasks(context2, launcherIconOptions, tasks);
        return tasks;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context2, @NotNull String name, @NotNull LauncherIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options2.generateOutputIcons) {
            return;
        }
        for (Density density : DENSITIES) {
            LauncherIconOptions localOptions = options2.clone();
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(context2, name, localOptions, density, tasks);
        }
        if (options2.generatePlayStoreIcon) {
            tasks.add(() -> {
                LauncherIconOptions localOptions = options2.clone();
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generatePlayStoreIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = IconGenerator.Shape.NONE;
                AnnotatedImage image = this.generateLegacyImage(context2, localOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(localOptions, name)), IconCategory.PLAY_STORE, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context2, @NotNull String name, @NotNull LauncherIconOptions options2, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (options2.foregroundImage != null && options2.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions foregroundOptions = options2.clone();
                foregroundOptions.generatePlayStoreIcon = false;
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context2, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options2.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions backgroundOptions = options2.clone();
                backgroundOptions.generatePlayStoreIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context2, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options2.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options2.generateLegacyIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options2.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePlayStoreIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = this.generateLegacyImage(context2, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options2.generateRoundIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options2.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generatePlayStoreIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = IconGenerator.Shape.CIRCLE;
                AnnotatedImage legacyRound = this.generateLegacyImage(context2, legacyOptions);
                return new GeneratedImageIcon(name + "_round", new PathString(this.getIconPath(legacyOptions, name + "_round")), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull LauncherIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        TransformedImageAsset image;
        if (!options2.generateOutputIcons) {
            return;
        }
        LauncherIconOptions iconOptions = options2.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.generatePlayStoreIcon = false;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (iconOptions.generateRoundIcon) {
            tasks.add(() -> {
                String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
                return new GeneratedXmlResource(name + "_round", new PathString(this.getIconPath(iconOptions, name + "_round")), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
            });
        }
        if (options2.foregroundImage != null && options2.foregroundImage.isDrawable()) {
            image = options2.foregroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                LauncherIconOptions iconOptions = options2.clone();
                iconOptions.generatePlayStoreIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    LauncherIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    LauncherIconGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options2.backgroundImage != null && options2.backgroundImage.isDrawable()) {
            image = options2.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                LauncherIconOptions iconOptions = options2.clone();
                iconOptions.generatePlayStoreIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    LauncherIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    LauncherIconGenerator.getLog().error("Transformed background drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options2.backgroundImage == null) {
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options2.clone();
                iconOptions.generatePlayStoreIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    private void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context2, @NotNull LauncherIconOptions options2, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options2.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options2.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options2.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options2.generatePlayStoreIcon) {
            previewShapes.add(PreviewShape.PLAY_STORE);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                LauncherIconOptions localOptions = options2.clone();
                localOptions.density = options2.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generatePlayStoreIcon = previewShape == PreviewShape.PLAY_STORE;
                try {
                    image = this.generatePreviewImage(context2, localOptions);
                }
                catch (Throwable e) {
                    LauncherIconGenerator.getLog().error(e);
                    image = LauncherIconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context2, @NotNull IconGenerator.IconOptions options2, @NotNull String name) {
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options2;
        LauncherIconOptions localOptions = launcherIconOptions.clone();
        localOptions.generatePlayStoreIcon = false;
        Collection<GeneratedIcon> icons = this.generateIcons(context2, options2, name);
        icons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> icon2.getOutputPath() != null).forEach(icon2 -> {
            assert (icon2.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon2.getCategory().toString(), k -> new LinkedHashMap());
            LauncherIconOptions iconOptions = localOptions.clone();
            iconOptions.density = icon2.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            iconOptions.generatePlayStoreIcon = icon2.getCategory() == IconCategory.PLAY_STORE;
            imageMap.put(icon2.getOutputPath().toString(), new AnnotatedImage(icon2.getImage(), icon2.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context2, @NotNull IconGenerator.IconOptions options2) {
        if (options2.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        return this.generatePreviewImage(context2, (LauncherIconOptions)options2);
    }

    @NotNull
    private AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context2, @NotNull LauncherIconOptions options2) {
        switch (options2.previewShape) {
            case CIRCLE: 
            case SQUIRCLE: 
            case ROUNDED_SQUARE: 
            case SQUARE: {
                return this.generateViewportPreviewImage(context2, options2);
            }
            case LEGACY: {
                options2.generatePreviewIcons = true;
                options2.generatePlayStoreIcon = false;
                return this.generateLegacyImage(context2, options2);
            }
            case LEGACY_ROUND: {
                options2.generatePreviewIcons = true;
                options2.generatePlayStoreIcon = false;
                options2.legacyIconShape = IconGenerator.Shape.CIRCLE;
                return this.generateLegacyImage(context2, options2);
            }
            case FULL_BLEED: {
                AnnotatedImage annotatedImage = this.generateFullBleedPreviewImage(context2, options2);
                return new AnnotatedImage(LauncherIconGenerator.scaledPreviewImage(annotatedImage.getImage(), 0.8f), annotatedImage.getErrorMessage());
            }
            case PLAY_STORE: {
                options2.generatePreviewIcons = true;
                options2.generatePlayStoreIcon = true;
                options2.legacyIconShape = IconGenerator.Shape.SQUARE;
                AnnotatedImage annotatedImage = this.generateLegacyImage(context2, options2);
                BufferedImage image = AssetUtil.trimmedImage((BufferedImage)annotatedImage.getImage());
                double scale = LauncherIconGenerator.getMdpiScaleFactor(options2.previewDensity);
                return new AnnotatedImage(LauncherIconGenerator.scaledPreviewImage(image, 0.22 * scale), annotatedImage.getErrorMessage());
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private AnnotatedImage generateFullBleedPreviewImage(@NotNull GraphicGeneratorContext context2, @NotNull LauncherIconOptions options2) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context2, options2, Color.BLACK);
        LauncherIconGenerator.drawGrid(options2, mergedImage.getImage());
        return mergedImage;
    }

    @NotNull
    private AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context2, @NotNull LauncherIconOptions options2) {
        Rectangle viewportRect = this.getViewportRectangle(options2);
        Rectangle legacyRect = this.getLegacyRectangle(options2);
        Density legacyOrPlayStoreDensity = options2.generatePlayStoreIcon ? Density.NODPI : options2.density;
        Rectangle legacyShapeRect = options2.generatePlayStoreIcon ? IMAGE_SIZE_TARGET_PLAY_STORE_PX : LauncherLegacyIconGenerator.getTargetRect(options2.legacyIconShape, legacyOrPlayStoreDensity);
        AnnotatedImage mergedImage = this.generateMergedLayers(context2, options2, null);
        BufferedImage fullBleed = mergedImage.getImage();
        double viewportScale = LauncherIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options2.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : LauncherIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options2.legacyIconShape != IconGenerator.Shape.NONE) {
            shapeImageBack = LauncherIconGenerator.loadBackImage(context2, options2.legacyIconShape, legacyOrPlayStoreDensity);
            shapeImageFore = LauncherIconGenerator.loadStyleImage(context2, options2.legacyIconShape, legacyOrPlayStoreDensity, IconGenerator.Style.SIMPLE);
            shapeImageMask = LauncherIconGenerator.loadMaskImage(context2, options2.legacyIconShape, legacyOrPlayStoreDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = LauncherIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        return new AnnotatedImage(legacyImage, mergedImage.getErrorMessage());
    }

    @NotNull
    private AnnotatedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context2, @NotNull LauncherIconOptions options2) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context2, options2, null);
        BufferedImage image = mergedImage.getImage();
        BufferedImage mask = this.generateMaskLayer(context2, options2, options2.previewShape);
        image = this.cropImageToViewport(options2, image);
        image = LauncherIconGenerator.applyMask(image, mask);
        LauncherIconGenerator.drawGrid(options2, image);
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @Nullable
    private BufferedImage generateMaskLayer(@NotNull GraphicGeneratorContext context2, @NotNull LauncherIconOptions options2, @NotNull PreviewShape shape) {
        String maskName;
        switch (shape) {
            case CIRCLE: {
                maskName = "circle";
                break;
            }
            case SQUARE: {
                maskName = "square";
                break;
            }
            case ROUNDED_SQUARE: {
                maskName = "rounded_corner";
                break;
            }
            case SQUIRCLE: {
                maskName = "squircle";
                break;
            }
            default: {
                maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options2.generatePlayStoreIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = context2.loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            double scale = LauncherIconGenerator.getRectangleInsideScale(maskRect, this.getViewportRectangle(options2));
            return options2.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(mask, scale) : LauncherIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options2.density.getResourceValue());
        return context2.loadImageResource(resourceName);
    }

    @Override
    @NotNull
    protected Rectangle getFullBleedRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        if (((LauncherIconOptions)options2).generatePlayStoreIcon) {
            return IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, LauncherIconGenerator.getMdpiScaleFactor(options2.density));
    }

    @Override
    @NotNull
    protected Rectangle getViewportRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        if (((LauncherIconOptions)options2).generatePlayStoreIcon) {
            return IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, LauncherIconGenerator.getMdpiScaleFactor(options2.density));
    }

    @Override
    @NotNull
    protected Rectangle getLegacyRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options2) {
        if (((LauncherIconOptions)options2).generatePlayStoreIcon) {
            return options2.generatePreviewIcons ? IMAGE_SIZE_VIEWPORT_PREVIEW_PLAY_STORE_PX : IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, LauncherIconGenerator.getMdpiScaleFactor(options2.density));
    }

    @Override
    protected Rectangle getMaxIconRectangle() {
        return IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX;
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull BufferedImage image) {
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        LauncherIconGenerator.drawGrid(launcherIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull Graphics2D gOut) {
        if (launcherIconOptions.generatePlayStoreIcon) {
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
                LauncherIconGenerator.drawFullBleedIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.LEGACY || launcherIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (launcherIconOptions.showGrid) {
                LauncherIconGenerator.drawLegacyIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
            LauncherIconGenerator.drawAdaptiveIconGrid(launcherIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(@NotNull LauncherIconOptions options2, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options2.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options2.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options2.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(@NotNull LauncherIconOptions options2, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options2.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options2.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options2.showSafeZone) {
            g.drawCenteredCircle(center, center, LauncherIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(@NotNull LauncherIconOptions options2, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options2.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull IconGenerator.IconOptions options2, @NotNull String iconName) {
        if (((LauncherIconOptions)options2).generatePlayStoreIcon) {
            return iconName + "-playstore.png";
        }
        return super.getIconPath(options2, iconName);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(LauncherIconGenerator.class);
    }

    public static enum PreviewShape {
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        PLAY_STORE("play-store", "Google Play Store"),
        NONE("none", "none");

        public final String id;
        public final String displayName;

        private PreviewShape(String id2, String displayName2) {
            this.id = id2;
            this.displayName = displayName2;
        }
    }

    public static class LauncherIconOptions
    extends AdaptiveIconGenerator.AdaptiveIconOptions
    implements Cloneable {
        public boolean generateRoundIcon = true;
        public boolean generatePlayStoreIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public IconGenerator.Shape legacyIconShape = IconGenerator.Shape.SQUARE;
        public boolean showGrid;

        public LauncherIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public LauncherIconOptions clone() {
            return (LauncherIconOptions)super.clone();
        }
    }
}

