/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuiltInImages {
    private static final String JAR_URL_PREFIX = "file:";
    private static final String JAR_RESOURCE_PATH_SEPARATOR = ".jar!";

    private BuiltInImages() {
    }

    @Nullable
    public static BufferedImage getStencilImage(@NotNull String relativePath) throws IOException {
        try (InputStream is = BuiltInImages.class.getResourceAsStream(relativePath);){
            BufferedImage bufferedImage = is == null ? null : ImageIO.read(is);
            return bufferedImage;
        }
    }

    @Nullable
    public static BufferedImage getClipartImage(@NotNull String name) throws IOException {
        try (InputStream is = BuiltInImages.class.getResourceAsStream("/images/clipart/big/" + name);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    public static String getJarFilePath(URL jarFileResourceUrl) {
        String imagesFolderPath = jarFileResourceUrl.getPath();
        int pathSeparator = imagesFolderPath.indexOf(JAR_RESOURCE_PATH_SEPARATOR) + JAR_RESOURCE_PATH_SEPARATOR.length() - 1;
        return imagesFolderPath.substring(JAR_URL_PREFIX.length(), pathSeparator);
    }

    @NotNull
    public static List<String> getResourcesNames(@NotNull String pathPrefix, @NotNull String filenameExtension) {
        ArrayList<String> names;
        block9: {
            names = new ArrayList<String>(80);
            try {
                File directory;
                String[] list2;
                Enumeration<URL> en = BuiltInImages.class.getClassLoader().getResources(pathPrefix);
                if (!en.hasMoreElements()) break block9;
                URL url = en.nextElement();
                if ("jar".equals(url.getProtocol())) {
                    String jarPath = BuiltInImages.getJarFilePath(url);
                    try (ZipFile jarFile = new ZipFile(jarPath);){
                        jarFile.stream().forEach(zipEntry -> {
                            String name = zipEntry.getName();
                            if (name.startsWith(pathPrefix) && name.endsWith(filenameExtension)) {
                                int lastSlash = name.lastIndexOf(47);
                                if (lastSlash >= 0) {
                                    name = name.substring(lastSlash + 1);
                                }
                                names.add(name);
                            }
                        });
                        break block9;
                    }
                }
                if ("file".equals(url.getProtocol()) && (list2 = (directory = new File(url.getPath())).list()) != null) {
                    names.addAll(Arrays.asList(list2));
                }
            }
            catch (Exception e) {
                BuiltInImages.getLog().error((Throwable)e);
            }
        }
        return names;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BuiltInImages.class);
    }
}

