/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.google.common.base.CaseFormat;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PathKt;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0002\b\u0004\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010\u001c\u001a\u00020\t2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e\u001a\u0012\u0010\u001f\u001a\u00020\t2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e\u001a\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\n\u0010!\u001a\u00020\u0012*\u00020\u0017\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\""}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createPlaceholderImage", "Ljava/awt/image/BufferedImage;", "getBundledImage", "Ljava/io/File;", "dir", "", "fileName", "orderTemplates", "", "Lcom/android/tools/idea/projectsystem/NamedModuleTemplate;", "templates", "pad", "image", "paddingPercent", "", "scaleDimension", "Ljava/awt/Dimension;", "dim", "scaleFactor", "", "scaleRectangle", "Ljava/awt/Rectangle;", "rect", "scaleRectangleAroundCenter", "toLowerCamelCase", "enumValue", "", "toUpperCamelCase", "trim", "roundToInt", "intellij.android.newProjectWizard"})
@JvmName(name="AssetStudioUtils")
public final class AssetStudioUtils {
    private static final Logger getLOG() {
        Logger logger2 = Logger.getInstance((String)"#com.android.tools.idea.npw.assetstudio.AssetStudioUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\"#com.androi\u2026studio.AssetStudioUtils\")");
        return logger2;
    }

    @NotNull
    public static final Rectangle scaleRectangle(@NotNull Rectangle rect, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return new Rectangle(MathKt.roundToInt((double)((double)rect.x * scaleFactor)), MathKt.roundToInt((double)((double)rect.y * scaleFactor)), MathKt.roundToInt((double)((double)rect.width * scaleFactor)), MathKt.roundToInt((double)((double)rect.height * scaleFactor)));
    }

    @NotNull
    public static final Rectangle scaleRectangleAroundCenter(@NotNull Rectangle rect, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int width = MathKt.roundToInt((double)((double)rect.width * scaleFactor));
        int height = MathKt.roundToInt((double)((double)rect.height * scaleFactor));
        return new Rectangle(MathKt.roundToInt((double)((double)rect.x * scaleFactor - (double)(width - rect.width) / 2.0)), MathKt.roundToInt((double)((double)rect.y * scaleFactor - (double)(height - rect.height) / 2.0)), width, height);
    }

    @NotNull
    public static final Dimension scaleDimension(@NotNull Dimension dim, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        return new Dimension(MathKt.roundToInt((double)((double)dim.width * scaleFactor)), MathKt.roundToInt((double)((double)dim.height * scaleFactor)));
    }

    public static final int roundToInt(double $this$roundToInt) {
        return MathKt.roundToInt((double)$this$roundToInt);
    }

    @NotNull
    public static final BufferedImage createPlaceholderImage() {
        return new BufferedImage(1, 1, 2);
    }

    @NotNull
    public static final BufferedImage trim(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage bufferedImage = ImageUtils.cropBlank((BufferedImage)image, null, (int)2);
        if (bufferedImage == null) {
            bufferedImage = image;
        }
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            return image;
        }
        int largerSide = Math.max(image.getWidth(), image.getHeight());
        int smallerSide = Math.min(image.getWidth(), image.getHeight());
        int padding = RangesKt.coerceAtLeast((int)(largerSide * RangesKt.coerceAtMost((int)paddingPercent, (int)100) / 100), (int)(-(smallerSide / 2 - 1)));
        BufferedImage bufferedImage = AssetUtil.paddedImage((BufferedImage)image, (int)padding);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"paddedImage(image, padding)");
        return bufferedImage;
    }

    @NotNull
    public static final String toLowerCamelCase(@NotNull Enum<?> enumValue) {
        Intrinsics.checkNotNullParameter(enumValue, (String)"enumValue");
        String string = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enumValue.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UPPER_UNDERSCORE.to(Case\u2026ER_CAMEL, enumValue.name)");
        return string;
    }

    @NotNull
    public static final String toUpperCamelCase(@NotNull Enum<?> enumValue) {
        Intrinsics.checkNotNullParameter(enumValue, (String)"enumValue");
        String string = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumValue.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UPPER_UNDERSCORE.to(Case\u2026ER_CAMEL, enumValue.name)");
        return string;
    }

    @NotNull
    public static final File getBundledImage(@NotNull String dir, @NotNull String fileName) {
        File file2;
        Object v0;
        Path devImagesDir;
        Path releaseImagesDir;
        Path homePath;
        block3: {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            homePath = Paths.get(PathManager.getHomePath(), new String[0]);
            releaseImagesDir = homePath.resolve("plugins/android/resources/images/" + dir);
            devImagesDir = homePath.resolve("../../../../../../tools/adt/idea/android/resources/images/" + dir);
            Path releaseImage = releaseImagesDir.resolve(fileName);
            Path devImage = devImagesDir.resolve(fileName);
            Object[] objectArray = new Path[]{releaseImage, devImage, releaseImagesDir, devImagesDir, homePath};
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!PathKt.exists((Path)it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Path path2 = v0;
        File file3 = file2 = path2 != null ? path2.toFile() : null;
        if (file2 == null) {
            throw new IOException("Studio root dir '" + homePath + "' is not readable");
        }
        File root = file2;
        if (root.isDirectory()) {
            AssetStudioUtils.getLOG().error("Bundled image file " + fileName + " is not found neither in " + releaseImagesDir + " not " + devImagesDir);
        }
        return root;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<NamedModuleTemplate> orderTemplates(@NotNull List<NamedModuleTemplate> templates) {
        block10: {
            Intrinsics.checkNotNullParameter(templates, (String)"templates");
            main = null;
            debug = null;
            release = null;
            orderedList = new ArrayList<E>();
            block5: for (NamedModuleTemplate template : templates) {
                block9: {
                    var7_7 = template.getName();
                    switch (var7_7.hashCode()) {
                        case 95458899: {
                            if (var7_7.equals("debug")) break;
                            ** break;
                        }
                        case 1090594823: {
                            if (!var7_7.equals("release")) {
                                ** break;
                            }
                            break block9;
                        }
                        case 3343801: {
                            if (!var7_7.equals("main")) ** break;
                            main = template;
                            continue block5;
                        }
                    }
                    debug = template;
                    continue;
                }
                release = template;
                continue;
lbl25:
                // 4 sources

                orderedList.add(template);
            }
            var6_6 = orderTemplates.1.INSTANCE;
            v0 = Comparator.comparing(new Function((Function1)var6_6){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue(v0, (String)"comparing(NamedModuleTemplate::name)");
            CollectionsKt.sortWith((List)orderedList, v0);
            v1 = release;
            if (v1 != null) {
                it = v1;
                $i$a$-let-AssetStudioUtils$orderTemplates$2 = false;
                orderedList.add(0, it);
            }
            v2 = debug;
            if (v2 != null) {
                it = v2;
                $i$a$-let-AssetStudioUtils$orderTemplates$3 = false;
                orderedList.add(0, it);
            }
            v3 = main;
            if (v3 == null) break block10;
            it = v3;
            $i$a$-let-AssetStudioUtils$orderTemplates$4 = false;
            orderedList.add(0, it);
        }
        return orderedList;
    }
}

