/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.actions;

import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.ui.StudioWizardDialogBuilder;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidAssetStudioAction
extends AnAction {
    protected AndroidAssetStudioAction(@Nullable String text2, @Nullable String description2) {
        super(text2, description2, StudioIcons.Common.ANDROID_HEAD);
    }

    protected static boolean isAvailable(@NotNull DataContext dataContext) {
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        VirtualFile location2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        return module2 != null && view != null && location2 != null && view.getDirectories().length > 0 && AndroidFacet.getInstance((Module)module2) != null && ProjectSystemUtil.getProjectSystem(module2.getProject()).allowsFileCreation() && AndroidAssetStudioAction.getModuleTemplate(module2, location2) != null;
    }

    @Nullable
    private static NamedModuleTemplate getModuleTemplate(@NotNull Module module2, @NotNull VirtualFile location2) {
        for (NamedModuleTemplate namedTemplate : ProjectSystemUtil.getModuleSystem(module2).getModuleTemplates(location2)) {
            if (namedTemplate.getPaths().getResDirectories().isEmpty()) continue;
            return namedTemplate;
        }
        return null;
    }

    @Nullable
    private static File findClosestResFolder(@NotNull AndroidModulePaths paths, @NotNull VirtualFile location2) {
        String toFind = location2.getPath();
        File bestMatch = null;
        int bestCommonPrefixLength = -1;
        for (File resDir : paths.getResDirectories()) {
            int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)resDir.getPath(), (CharSequence)toFind);
            if (commonPrefixLength <= bestCommonPrefixLength) continue;
            bestCommonPrefixLength = commonPrefixLength;
            bestMatch = resDir;
        }
        return bestMatch;
    }

    public final void update(@NotNull AnActionEvent e) {
        e.getPresentation().setVisible(AndroidAssetStudioAction.isAvailable(e.getDataContext()));
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module2 == null) {
            return;
        }
        VirtualFile location2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (location2 == null) {
            return;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return;
        }
        NamedModuleTemplate template = AndroidAssetStudioAction.getModuleTemplate(module2, location2);
        if (template == null) {
            return;
        }
        File resFolder = AndroidAssetStudioAction.findClosestResFolder(template.getPaths(), location2);
        if (resFolder == null) {
            return;
        }
        ModelWizard wizard = this.createWizard(facet2, template, resFolder);
        if (wizard != null) {
            StudioWizardDialogBuilder dialogBuilder = new StudioWizardDialogBuilder(wizard, "Asset Studio");
            dialogBuilder.setProject(facet2.getModule().getProject()).setMinimumSize(this.getWizardMinimumSize()).setPreferredSize(this.getWizardPreferredSize()).setHelpUrl(this.getHelpUrl());
            dialogBuilder.build().show();
        }
    }

    @Nullable
    protected abstract ModelWizard createWizard(@NotNull AndroidFacet var1, @NotNull NamedModuleTemplate var2, @NotNull File var3);

    @NotNull
    protected abstract Dimension getWizardMinimumSize();

    @NotNull
    protected abstract Dimension getWizardPreferredSize();

    @Nullable
    protected URL getHelpUrl() {
        return null;
    }
}

