/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PsiIncludeDirectoryView;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleIncludeViewNode
extends IncludeViewNode<SimpleIncludeValue> {
    SimpleIncludeViewNode(@NotNull SimpleIncludeValue thisInclude, @NotNull Collection<File> allIncludes, boolean showPackageType, @Nullable Project project, @NotNull ViewSettings viewSettings) {
        super(thisInclude, allIncludes, showPackageType, project, viewSettings);
    }

    @NotNull
    private SimpleIncludeValue getSimpleIncludeValue() {
        SimpleIncludeValue value2 = (SimpleIncludeValue)this.getValue();
        assert (value2 != null);
        return value2;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Project project = this.getProject();
        if (project == null) {
            return Collections.EMPTY_LIST;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        SimpleIncludeValue value2 = this.getSimpleIncludeValue();
        VirtualFile virtualFile = fileSystem.findFileByIoFile(value2.getIncludeFolder());
        if (virtualFile == null) {
            return Collections.EMPTY_LIST;
        }
        PsiDirectory directory = psiManager.findDirectory(virtualFile);
        if (directory == null) {
            return Collections.EMPTY_LIST;
        }
        return new PsiIncludeDirectoryView(this.getProject(), (ImmutableList<VirtualFile>)ImmutableList.of(), false, directory, this.getSettings(), null).getChildren();
    }

    @Override
    final void writeDescription(@NotNull PresentationDataWrapper presentation) {
        SimpleIncludeValue concrete = this.getSimpleIncludeValue();
        if (concrete.getPackageType() == PackageType.IncludeFolder) {
            presentation.setIcon(AllIcons.Nodes.Folder);
        } else {
            presentation.setIcon(AllIcons.Nodes.Module);
        }
        presentation.addText(concrete.getSimplePackageName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowPackageType && concrete.getPackageType() != PackageType.IncludeFolder) {
            presentation.addText(String.format(" (%s, ", concrete.getPackageType().myDescription), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (concrete.getPackageType() == PackageType.IncludeFolder) {
            String path2 = FileUtil.getLocationRelativeToUserHome((String)concrete.getIncludeFolder().getPath());
            path2 = LexicalIncludePaths.trimPathSeparators(path2);
            path2 = FilenameUtils.separatorsToSystem((String)path2);
            presentation.addText(String.format("%s)", path2), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            String path3 = concrete.getRelativeIncludeSubFolder();
            path3 = LexicalIncludePaths.trimPathSeparators(path3);
            path3 = FilenameUtils.separatorsToSystem((String)path3);
            presentation.addText(String.format("%s)", path3), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public boolean contains(@NotNull VirtualFile file2) {
        SimpleIncludeValue value2;
        if (!LexicalIncludePaths.hasHeaderExtension(file2.getName())) {
            return false;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile ancestor = fileSystem.findFileByIoFile((value2 = this.getSimpleIncludeValue()).getIncludeFolder());
        return ancestor != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false);
    }

    @Override
    @NotNull
    public Comparable getSortKey() {
        SimpleIncludeValue value2 = this.getSimpleIncludeValue();
        if (value2.getPackageType() != PackageType.IncludeFolder) {
            return "[icon-f]" + value2.getSortKey();
        }
        return "[icon-m]" + value2.getSortKey();
    }
}

