/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeArtifact;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeFile;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkSourceFolderNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludesViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.NativeIncludes;
import com.google.common.collect.Iterables;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkLibraryEnhancedHeadersNode
extends ProjectViewNode<Collection<IdeNativeArtifact>>
implements FolderGroupNode {
    @NotNull
    private final String myNativeLibraryName;
    @NotNull
    private final String myNativeLibraryType;
    @NotNull
    private final NativeIncludes myNativeIncludes;
    @Nullable
    private final PsiFileSystemItemFilter myFilter;
    @Nullable
    private VirtualFile myLibraryFolder;

    public NdkLibraryEnhancedHeadersNode(@NotNull Project project, @NotNull String nativeLibraryName, @NotNull String nativeLibraryType, @NotNull Collection<IdeNativeArtifact> artifacts, @NotNull NativeIncludes nativeIncludes, @NotNull ViewSettings settings, @Nullable PsiFileSystemItemFilter filter2) {
        super(project, artifacts, settings);
        this.myNativeLibraryName = nativeLibraryName;
        this.myNativeLibraryType = nativeLibraryType;
        this.myNativeIncludes = nativeIncludes;
        this.myFilter = filter2;
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> getSourceFolderNodes(@NotNull Project project, @NotNull Collection<IdeNativeArtifact> artifacts, @NotNull ViewSettings settings, @Nullable PsiFileSystemItemFilter filter2) {
        TreeMap<String, RootFolder> rootFolders = new TreeMap<String, RootFolder>();
        for (IdeNativeArtifact artifact2 : artifacts) {
            NdkLibraryEnhancedHeadersNode.addSourceFolders(rootFolders, artifact2);
            NdkLibraryEnhancedHeadersNode.addSourceFiles(rootFolders, artifact2);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryEnhancedHeadersNode.groupFolders(rootFolders);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryEnhancedHeadersNode.mergeFolders(rootFolders);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList children = new ArrayList();
        for (RootFolder rootFolder : rootFolders.values()) {
            PsiDirectory directory = psiManager.findDirectory(rootFolder.rootFolder);
            if (directory == null) continue;
            children.add((AbstractTreeNode<?>)new NdkSourceFolderNode(project, directory, settings, filter2));
        }
        return children;
    }

    private static void addSourceFolders(@NotNull TreeMap<String, RootFolder> rootFolders, @NotNull IdeNativeArtifact artifact2) {
        for (VirtualFile sourceFolder : NdkLibraryEnhancedHeadersNode.getSourceFolders(artifact2)) {
            String path2 = sourceFolder.getPath();
            if (rootFolders.containsKey(path2)) continue;
            RootFolder rootFolder = new RootFolder(sourceFolder);
            rootFolder.sourceFolders.add(sourceFolder);
            rootFolders.put(path2, rootFolder);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFolders(@NotNull IdeNativeArtifact artifact2) {
        ArrayList<File> sourceFolders2 = new ArrayList<File>(artifact2.getExportedHeaders());
        return NdkLibraryEnhancedHeadersNode.convertToVirtualFiles(sourceFolders2);
    }

    private static void addSourceFiles(@NotNull TreeMap<String, RootFolder> rootFolders, @NotNull IdeNativeArtifact artifact2) {
        for (VirtualFile sourceFile : NdkLibraryEnhancedHeadersNode.getSourceFiles(artifact2)) {
            VirtualFile sourceFolder = sourceFile.getParent();
            String path2 = sourceFolder.getPath();
            RootFolder rootFolder = rootFolders.computeIfAbsent(path2, k -> new RootFolder(sourceFolder));
            rootFolder.sourceFiles.add(sourceFile);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFiles(@NotNull IdeNativeArtifact artifact2) {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (IdeNativeFile sourceFile : artifact2.getSourceFiles()) {
            File source = sourceFile.getFilePath();
            sourceFiles.add(source);
        }
        return NdkLibraryEnhancedHeadersNode.convertToVirtualFiles(sourceFiles);
    }

    @NotNull
    private static List<VirtualFile> convertToVirtualFiles(@NotNull Collection<File> files2) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files2.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File file2 : files2) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(file2);
            if (virtualFile == null) continue;
            result2.add(virtualFile);
        }
        return result2;
    }

    private static void groupFolders(@NotNull TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            VirtualFile folderToMergeParent = folderToMerge.rootFolder.getParent();
            if (folderToMergeParent == null) {
                keyToMerge = rootFolders.lowerKey(keyToMerge);
                continue;
            }
            RootFolder targetFolder = rootFolders.get(folderToMergeParent.getPath());
            if (targetFolder != null) {
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            String previousKey = rootFolders.lowerKey(keyToMerge);
            if (previousKey == null) break;
            RootFolder previousFolder = rootFolders.get(previousKey);
            VirtualFile previousFolderParent = previousFolder.rootFolder.getParent();
            if (previousFolderParent != null && previousFolderParent.getPath().equals(folderToMergeParent.getPath())) {
                targetFolder = rootFolders.computeIfAbsent(folderToMergeParent.getPath(), k -> new RootFolder(folderToMergeParent));
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFolders.addAll(previousFolder.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                targetFolder.sourceFiles.addAll(previousFolder.sourceFiles);
                rootFolders.remove(keyToMerge);
                rootFolders.remove(previousKey);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            keyToMerge = previousKey;
        }
    }

    private static void mergeFolders(@NotNull TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            VirtualFile folder;
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            for (folder = folderToMerge.rootFolder.getParent(); folder != null; folder = folder.getParent()) {
                RootFolder targetFolder = rootFolders.get(folder.getPath());
                if (targetFolder == null) {
                    continue;
                }
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                break;
            }
            if (rootFolders.size() <= 1) break;
            if (folder != null) continue;
            keyToMerge = rootFolders.lowerKey(keyToMerge);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        IncludesViewNode includesNode = new IncludesViewNode(this.getNotNullProject(), this.myNativeIncludes, this.getSettings());
        ArrayList<IncludesViewNode> result2 = new ArrayList<IncludesViewNode>();
        result2.add(includesNode);
        Collection<AbstractTreeNode<?>> sourceFolderNodes = NdkLibraryEnhancedHeadersNode.getSourceFolderNodes(this.getNotNullProject(), this.getArtifacts(), this.getSettings(), this.myFilter);
        if (sourceFolderNodes.size() == 1) {
            AbstractTreeNode node = (AbstractTreeNode)Iterables.getOnlyElement(sourceFolderNodes);
            assert (node instanceof NdkSourceFolderNode);
            NdkSourceFolderNode sourceFolderNode = (NdkSourceFolderNode)node;
            sourceFolderNode.setShowFolderPath(false);
            this.myLibraryFolder = sourceFolderNode.getVirtualFile();
            result2.addAll(sourceFolderNode.getChildren());
            return result2;
        }
        for (AbstractTreeNode<?> sourceFolderNode : sourceFolderNodes) {
            if (!(sourceFolderNode instanceof NdkSourceFolderNode)) continue;
            ((NdkSourceFolderNode)sourceFolderNode).setShowFolderPath(true);
        }
        this.myLibraryFolder = null;
        result2.addAll(sourceFolderNodes);
        return result2;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText(this.myNativeLibraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (!this.myNativeLibraryType.isEmpty()) {
            presentation.addText(" (" + this.myNativeLibraryType + (String)(this.myLibraryFolder != null ? ", " + FileUtil.getLocationRelativeToUserHome((String)this.myLibraryFolder.getPresentableUrl()) : "") + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.NativeLibrariesFolder);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        for (IdeNativeArtifact artifact2 : this.getArtifacts()) {
            for (VirtualFile folder : NdkLibraryEnhancedHeadersNode.getSourceFolders(artifact2)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file2, (boolean)false)) continue;
                return true;
            }
        }
        return NdkLibraryEnhancedHeadersNode.containedInIncludeFolders(this.myNativeIncludes, file2);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myNativeLibraryType + this.myNativeLibraryName;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myNativeLibraryName + (String)(this.myNativeLibraryType.isEmpty() ? "" : " (" + this.myNativeLibraryType + ")");
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getNotNullProject());
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>();
        for (IdeNativeArtifact artifact2 : this.getArtifacts()) {
            for (VirtualFile f : NdkLibraryEnhancedHeadersNode.getSourceFolders(artifact2)) {
                PsiDirectory dir = psiManager.findDirectory(f);
                if (dir == null) continue;
                folders.add(dir);
            }
        }
        return folders;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        return this.myProject;
    }

    @NotNull
    private Collection<IdeNativeArtifact> getArtifacts() {
        Collection artifacts = (Collection)this.getValue();
        assert (artifacts != null);
        return artifacts;
    }

    public static boolean containedInIncludeFolders(NativeIncludes myNativeIncludes, VirtualFile file2) {
        return IncludesViewNode.containedInIncludeFolders(myNativeIncludes, file2);
    }

    private static final class RootFolder {
        @NotNull
        final VirtualFile rootFolder;
        @NotNull
        final List<VirtualFile> sourceFolders = new ArrayList<VirtualFile>();
        @NotNull
        final List<VirtualFile> sourceFiles = new ArrayList<VirtualFile>();

        RootFolder(@NotNull VirtualFile rootFolder) {
            this.rootFolder = rootFolder;
        }
    }
}

