/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.navigator.nodes.apk.ndk.PathTrees;
import com.android.tools.idea.navigator.nodes.apk.ndk.SourceCodeFilter;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import icons.StudioIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class NdkSourceNode
extends ProjectViewNode<File> {
    @NotNull
    private final File myNdkPath;
    @NotNull
    private final List<PsiDirectory> mySourceFolders;
    @NotNull
    private final SourceCodeFilter myFilter;

    public NdkSourceNode(@NotNull Project project, @NotNull File ndkPath, @NotNull PathTree ndkPathTree, @NotNull SourceCodeFilter filter2, @NotNull ViewSettings viewSettings) {
        super(project, (Object)ndkPath, viewSettings);
        this.myNdkPath = ndkPath;
        this.myFilter = filter2;
        this.mySourceFolders = PathTrees.findSourceFolders(ndkPathTree, ndkPath.getPath(), project);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        for (PsiDirectory sourceFolder : this.mySourceFolders) {
            if (!VfsUtilCore.isAncestor((VirtualFile)sourceFolder.getVirtualFile(), (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList<PsiDirectoryNode> children = new ArrayList<PsiDirectoryNode>();
        ViewSettings settings = this.getSettings();
        for (PsiDirectory folder : this.mySourceFolders) {
            children.add(new PsiDirectoryNode(this.myProject, folder, settings, (PsiFileSystemItemFilter)this.myFilter));
        }
        return children;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(StudioIcons.Common.ANDROID_HEAD);
        presentation.addText("NDK ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(this.myNdkPath.getPath(), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NdkSourceNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NdkSourceNode that = (NdkSourceNode)((Object)o);
        return Objects.equals(this.myNdkPath, that.myNdkPath) && Objects.equals(this.mySourceFolders, that.mySourceFolders) && Objects.equals(this.myFilter, that.myFilter);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myNdkPath, this.mySourceFolders, this.myFilter);
    }
}

