/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.dex.DexFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;

class DexFileStructure {
    @NotNull
    private final Future<List<DexBackedDexFile>> myDexFilesFuture;
    private boolean myPackagesComputed;
    @NotNull
    private final ApkPackages myPackages = new ApkPackages();

    DexFileStructure(@NotNull List<VirtualFile> dexFiles) {
        ListeningExecutorService executor2 = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
        this.myDexFilesFuture = executor2.submit(() -> {
            ArrayList<DexBackedDexFile> result2 = new ArrayList<DexBackedDexFile>();
            for (VirtualFile dexFile : dexFiles) {
                try {
                    result2.add(DexFiles.getDexFile(dexFile));
                }
                catch (IOException iOException) {}
            }
            return result2;
        });
    }

    @NotNull
    Collection<ApkPackage> getPackages() throws ExecutionException, InterruptedException {
        if (!this.myPackagesComputed) {
            this.myPackagesComputed = true;
            this.computePackages();
        }
        return this.myPackages.values();
    }

    private void computePackages() throws ExecutionException, InterruptedException {
        List<DexBackedDexFile> dexFiles = this.myDexFilesFuture.get();
        for (DexBackedDexFile dexFile : dexFiles) {
            Set definitions = dexFile.getClasses().stream().map(DexBackedClassDef::getType).collect(Collectors.toSet());
            int m = dexFile.getMethodSection().size();
            for (int i = 0; i < m; ++i) {
                DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
                String className = DebuggerUtilsEx.signatureToName((String)methodRef.getDefiningClass());
                String definition = "L" + className.replace('.', '/') + ";";
                if (!definitions.contains(definition)) continue;
                this.myPackages.add(className);
            }
        }
    }

    @VisibleForTesting
    static class ApkPackages {
        @NotNull
        private final Map<String, ApkPackage> myPackagesByName = new HashMap<String, ApkPackage>();

        ApkPackages() {
        }

        void add(@NotNull String classFqn) {
            ApkPackage apkPackage;
            Pair<String, String> packageAndClassNames = ApkPackages.splitName(classFqn);
            String packageName2 = (String)packageAndClassNames.getFirst();
            List segments = Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)packageName2);
            int segmentCount = segments.size();
            if (segmentCount == 0) {
                apkPackage = this.myPackagesByName.computeIfAbsent(packageName2, s -> new ApkPackage("", null));
            } else {
                String first = (String)segments.get(0);
                ApkPackage existing2 = this.myPackagesByName.get(first);
                if (existing2 == null) {
                    ApkPackage newPackage = new ApkPackage(first, null);
                    this.myPackagesByName.put(first, newPackage);
                    apkPackage = segmentCount > 1 ? ApkPackages.addChildren(newPackage, segments, 1) : newPackage;
                } else {
                    apkPackage = ApkPackages.findOrCreateMatchingSubpackage(existing2, segments);
                }
            }
            apkPackage.addClass((String)packageAndClassNames.getSecond());
        }

        @NotNull
        private static Pair<String, String> splitName(@NotNull String classFqn) {
            int lastDotIndex = classFqn.lastIndexOf(46);
            if (lastDotIndex < 0) {
                return Pair.create((Object)"", (Object)classFqn);
            }
            return Pair.create((Object)classFqn.substring(0, lastDotIndex), (Object)classFqn.substring(lastDotIndex + 1));
        }

        @NotNull
        private static ApkPackage findOrCreateMatchingSubpackage(@NotNull ApkPackage apkPackage, @NotNull List<String> segments) {
            ApkPackage current = apkPackage;
            int segmentCount = segments.size();
            for (int i = 1; i < segmentCount; ++i) {
                String segment = segments.get(i);
                ApkPackage child = current.findSubpackage(segment);
                if (child == null) {
                    return ApkPackages.addChildren(current, segments, i);
                }
                current = child;
            }
            return current;
        }

        @NotNull
        private static ApkPackage addChildren(@NotNull ApkPackage apkPackage, @NotNull List<String> segments, int index2) {
            ApkPackage current = apkPackage;
            int segmentCount = segments.size();
            for (int i = index2; i < segmentCount; ++i) {
                String segment = segments.get(i);
                current = current.addSubpackage(segment);
            }
            return current;
        }

        @NotNull
        Collection<ApkPackage> values() {
            return this.myPackagesByName.values();
        }

        @Nullable
        ApkPackage findPackage(@NotNull String name) {
            return this.myPackagesByName.get(name);
        }
    }
}

