/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.navigator.nodes.FileGroupNode;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.GroupNodes;
import com.android.tools.idea.navigator.nodes.android.AndroidResComparator;
import com.android.tools.idea.navigator.nodes.android.AndroidResFileNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResGroupNode
extends ProjectViewNode<List<PsiFile>>
implements FolderGroupNode,
FileGroupNode,
Comparable {
    @NotNull
    private final String myResName;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final List<PsiFile> myFiles;

    AndroidResGroupNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull List<PsiFile> files2, @NotNull String resName, @NotNull ViewSettings settings) {
        super(project, files2, settings);
        this.myResName = resName;
        this.myFacet = androidFacet;
        this.myFiles = files2;
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        List<PsiFile> resFiles = this.getResFiles();
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(resFiles.size());
        for (PsiFile file2 : resFiles) {
            folders.add(file2.getParent());
        }
        return folders;
    }

    @Override
    @NotNull
    public List<PsiFile> getFiles() {
        return this.getResFiles();
    }

    @NotNull
    private List<PsiFile> getResFiles() {
        List files2 = (List)this.getValue();
        assert (files2 != null);
        return files2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        for (PsiFile psiFile : this.myFiles) {
            if (!psiFile.getVirtualFile().equals(file2)) continue;
            return true;
        }
        return false;
    }

    public boolean canRepresent(Object element2) {
        return GroupNodes.canRepresent(this, element2) || GroupNodes.canRepresent(this, element2);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList<AndroidResFileNode> children = new ArrayList<AndroidResFileNode>(this.myFiles.size());
        assert (this.myProject != null);
        for (PsiFile file2 : this.myFiles) {
            children.add(new AndroidResFileNode(this.myProject, file2, this.getSettings(), this.myFacet));
        }
        return children;
    }

    public int getWeight() {
        return 20;
    }

    @Nullable
    public Comparable getSortKey() {
        return this;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this;
    }

    public int compareTo(@NotNull Object obj) {
        return AndroidResComparator.INSTANCE.compare(this, obj);
    }

    @NotNull
    public String getResName() {
        return this.myResName;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        PsiFile fileToOpen;
        if (!this.myFiles.isEmpty() && (fileToOpen = AndroidResGroupNode.findFileToOpen(this.myFiles)) != null) {
            assert (this.myProject != null);
            new OpenFileDescriptor(this.myProject, fileToOpen.getVirtualFile()).navigate(requestFocus);
        }
    }

    @Nullable
    private static PsiFile findFileToOpen(@NotNull List<PsiFile> files2) {
        PsiFile bestFile = null;
        FolderConfiguration bestConfig = null;
        for (PsiFile file2 : files2) {
            PsiDirectory qualifiedDirectory = file2.getParent();
            assert (qualifiedDirectory != null) : "Resource file's parent directory cannot be null";
            FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)qualifiedDirectory.getName());
            if (bestConfig != null && config2 != null && config2.compareTo(bestConfig) >= 0) continue;
            bestConfig = config2;
            bestFile = file2;
        }
        return bestFile;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setPresentableText(this.myResName);
        presentation.addText(this.myResName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myFiles.size() > 1) {
            presentation.addText(String.format(Locale.US, " (%1$d)", this.myFiles.size()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myResName + " (" + this.myFiles.size() + ")";
    }
}

