/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiDirectoryNode
extends PsiDirectoryNode {
    @Nullable
    private final String mySourceSetName;
    @Nullable
    private final PsiDirectory myRootSourceFolder;

    public AndroidPsiDirectoryNode(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull ViewSettings settings, @Nullable String sourceSetName, @Nullable PsiDirectory rootSourceFolder) {
        super(project, directory, settings);
        this.mySourceSetName = sourceSetName;
        this.myRootSourceFolder = rootSourceFolder;
    }

    public AndroidPsiDirectoryNode(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull ViewSettings settings, @Nullable String sourceSetName, @Nullable PsiDirectory rootSourceFolder, @Nullable PsiFileSystemItemFilter filter2) {
        super(project, directory, settings, filter2);
        this.mySourceSetName = sourceSetName;
        this.myRootSourceFolder = rootSourceFolder;
    }

    protected void updateImpl(@NotNull PresentationData data2) {
        super.updateImpl(data2);
        if (this.mySourceSetName != null && !"main".equals(this.mySourceSetName)) {
            data2.addText(data2.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data2.addText(" (" + this.mySourceSetName + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public boolean canRepresent(Object element2) {
        if (super.canRepresent(element2)) {
            return true;
        }
        Project project = this.getProject();
        if (this.myRootSourceFolder == null || project == null) {
            return false;
        }
        VirtualFile file2 = AndroidPsiDirectoryNode.tempGetVirtualFile(element2);
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (file2 == null || directory == null) {
            return false;
        }
        return ProjectViewDirectoryHelper.getInstance((Project)this.getProject()).canRepresent(file2, directory, this.myRootSourceFolder, this.getSettings());
    }

    @Nullable
    public static VirtualFile tempGetVirtualFile(Object element2) {
        if (element2 instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element2;
            return directory.getVirtualFile();
        }
        return element2 instanceof VirtualFile ? (VirtualFile)element2 : null;
    }

    @Nullable
    public Comparable getSortKey() {
        VirtualFile virtualFile = this.getValue() != null ? ((PsiDirectory)this.getValue()).getVirtualFile() : null;
        String path2 = virtualFile != null ? virtualFile.getPath() : "";
        String sourceProviderName = this.mySourceSetName == null ? "" : this.mySourceSetName;
        return this.getQualifiedNameSortKey() + "-" + ("main".equals(sourceProviderName) ? "" : sourceProviderName) + "-" + path2;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiDirectory value2 = (PsiDirectory)this.getValue();
        assert (value2 != null);
        return AndroidPsiDirectoryNode.toTestString(value2.getName(), this.mySourceSetName);
    }

    @NotNull
    static String toTestString(@NotNull String element2, @Nullable String providerName) {
        StringBuilder buffer = new StringBuilder(element2);
        if (providerName != null) {
            buffer.append(" (");
            buffer.append(providerName);
            buffer.append(")");
        }
        return buffer.toString();
    }
}

