/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidViewNodes;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestFileNode
extends PsiFileNode
implements FolderGroupNode {
    @NotNull
    private final AndroidFacet myAndroidFacet;

    AndroidManifestFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet androidFacet) {
        super(project, psiFile, settings);
        this.myAndroidFacet = androidFacet;
    }

    public void update(@NotNull PresentationData data2) {
        NamedIdeaSourceProvider sourceProvider;
        super.update(data2);
        PsiFile file2 = (PsiFile)this.getValue();
        if (file2 != null && (sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myAndroidFacet, file2)) != null && !"main".equals(sourceProvider.getName())) {
            data2.addText(file2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String name = sourceProvider.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                data2.addText(" (" + name + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            data2.setPresentableText(file2.getName());
        }
    }

    @Nullable
    static NamedIdeaSourceProvider getSourceProvider(@NotNull AndroidFacet facet2, @NotNull PsiFile file2) {
        return SourceProvidersKt.findByFile(AndroidViewNodes.getSourceProviders(facet2), file2.getVirtualFile());
    }

    @Nullable
    public Comparable getSortKey() {
        PsiFile file2 = (PsiFile)this.getValue();
        if (file2 == null) {
            return "";
        }
        NamedIdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myAndroidFacet, file2);
        if (sourceProvider == null || "main".equals(sourceProvider.getName())) {
            return "";
        }
        return sourceProvider.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    @NotNull
    public List<PsiDirectory> getFolders() {
        return Collections.emptyList();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile file2 = (PsiFile)this.getValue();
        if (file2 == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(file2.getName());
        NamedIdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myAndroidFacet, file2);
        assert (sourceProvider != null);
        String name = sourceProvider.getName();
        if (StringUtil.isNotEmpty((String)name)) {
            buffer.append(" (");
            buffer.append(name);
            buffer.append(")");
        }
        return buffer.toString();
    }
}

