/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.nav.safeargs.module;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.nav.safeargs.SafeArgsMode;
import com.android.tools.idea.nav.safeargs.SafeArgsModeKt;
import com.android.tools.idea.nav.safeargs.index.NavDestinationData;
import com.android.tools.idea.nav.safeargs.index.NavXmlData;
import com.android.tools.idea.nav.safeargs.index.NavXmlIndex;
import com.android.tools.idea.nav.safeargs.module.ModuleNavigationResourcesModificationTracker;
import com.android.tools.idea.nav.safeargs.psi.SafeArgsFeatureVersionsKt;
import com.android.tools.idea.nav.safeargs.psi.java.LightArgsClass;
import com.android.tools.idea.nav.safeargs.psi.java.LightDirectionsClass;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u00020\u0001:\u0002#$B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/nav/safeargs/module/SafeArgsCacheModuleService;", "", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "_args", "", "Lcom/android/tools/idea/nav/safeargs/psi/java/LightArgsClass;", "_directions", "Lcom/android/tools/idea/nav/safeargs/psi/java/LightDirectionsClass;", "args", "getArgs", "()Ljava/util/List;", "directions", "getDirections", "lastNavigationVersion", "Lcom/android/ide/common/repository/GradleVersion;", "lastResourcesModificationCount", "", "lock", "createLightArgsClasses", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "modulePackage", "", "navigationVersion", "entry", "Lcom/android/tools/idea/nav/safeargs/module/SafeArgsCacheModuleService$NavEntry;", "createLightDirectionsClasses", "refreshSafeArgsLightClassesIfNecessary", "", "Companion", "NavEntry", "intellij.android.nav.safeargs"})
public final class SafeArgsCacheModuleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Object lock;
    @GuardedBy(value="lock")
    private long lastResourcesModificationCount;
    @GuardedBy(value="lock")
    @NotNull
    private GradleVersion lastNavigationVersion;
    @GuardedBy(value="lock")
    @NotNull
    private List<LightDirectionsClass> _directions;
    @GuardedBy(value="lock")
    @NotNull
    private List<LightArgsClass> _args;

    private SafeArgsCacheModuleService(Module module2) {
        this.module = module2;
        Logger logger2 = Logger.getInstance(SafeArgsCacheModuleService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(SafeArgsCach\u2026oduleService::class.java)");
        this.LOG = logger2;
        this.lock = new Object();
        this.lastResourcesModificationCount = Long.MIN_VALUE;
        this.lastNavigationVersion = SafeArgsFeatureVersionsKt.getGRADLE_VERSION_ZERO();
        this._directions = CollectionsKt.emptyList();
        this._args = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<LightDirectionsClass> getDirections() {
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
        if ((androidFacet != null ? SafeArgsModeKt.getSafeArgsMode(androidFacet) : null) != SafeArgsMode.JAVA) {
            return CollectionsKt.emptyList();
        }
        this.refreshSafeArgsLightClassesIfNecessary();
        return this._directions;
    }

    @NotNull
    public final List<LightArgsClass> getArgs() {
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
        if ((androidFacet != null ? SafeArgsModeKt.getSafeArgsMode(androidFacet) : null) != SafeArgsMode.JAVA) {
            return CollectionsKt.emptyList();
        }
        this.refreshSafeArgsLightClassesIfNecessary();
        return this._args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void refreshSafeArgsLightClassesIfNecessary() {
        Object object;
        block16: {
            block15: {
                AndroidFacet androidFacet;
                object = AndroidFacet.getInstance((Module)this.module);
                if (object == null) break block15;
                AndroidFacet it = androidFacet = object;
                boolean bl = false;
                object = SafeArgsModeKt.isSafeArgsEnabled(it) ? androidFacet : null;
                if (object != null) break block16;
            }
            return;
        }
        AndroidFacet facet2 = object;
        String string = ProjectSystemUtil.getModuleSystem(facet2).getPackageName();
        if (string == null) {
            return;
        }
        String modulePackage = string;
        if (DumbService.getInstance((Project)this.module.getProject()).isDumb()) {
            this.LOG.warn("Safe Args classes may be temporarily stale due to indices not being ready right now.");
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            boolean bl = false;
            long modificationCount = ModuleNavigationResourcesModificationTracker.Companion.getInstance(this.module).getModificationCount();
            GradleVersion currVersion = SafeArgsFeatureVersionsKt.findNavigationVersion(facet2);
            if (modificationCount != this.lastResourcesModificationCount || !Intrinsics.areEqual((Object)currVersion, (Object)this.lastNavigationVersion)) {
                Iterable list$iv$iv;
                NavEntry entry;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getModuleResources(facet2);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)localResourceRepository), (String)"getModuleResources(facet)");
                LocalResourceRepository moduleResources = localResourceRepository;
                ListMultimap<String, ResourceItem> listMultimap = moduleResources.getResources(ResourceNamespace.RES_AUTO, ResourceType.NAVIGATION);
                Intrinsics.checkNotNullExpressionValue(listMultimap, (String)"moduleResources.getResou\u2026 ResourceType.NAVIGATION)");
                ListMultimap<String, ResourceItem> navResources = listMultimap;
                Collection collection2 = navResources.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"navResources.values()");
                Iterable iterable = collection2;
                boolean $i$f$mapNotNull = false;
                void var12_16 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    NavEntry navEntry;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    ResourceItem resource = (ResourceItem)element$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"resource");
                    if (IdeResourcesUtil.getSourceAsVirtualFile(resource) == null) {
                        navEntry = null;
                    } else {
                        NavXmlData data2;
                        VirtualFile file2;
                        Project project = facet2.getModule().getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
                        navEntry = NavXmlIndex.Companion.getDataForFile(project, file2) == null ? null : new NavEntry(resource, data2);
                    }
                    if (navEntry == null) continue;
                    NavEntry it$iv$iv = navEntry;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List entries2 = (List)destination$iv$iv;
                $this$mapNotNull$iv = entries2;
                SafeArgsCacheModuleService safeArgsCacheModuleService = this;
                boolean $i$f$flatMap = false;
                $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    entry = (NavEntry)element$iv$iv;
                    boolean bl5 = false;
                    list$iv$iv = this.createLightDirectionsClasses(facet2, modulePackage, entry);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                safeArgsCacheModuleService._directions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                $this$flatMap$iv = entries2;
                safeArgsCacheModuleService = this;
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    entry = (NavEntry)element$iv$iv;
                    boolean bl6 = false;
                    list$iv$iv = this.createLightArgsClasses(facet2, modulePackage, currVersion, entry);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                safeArgsCacheModuleService._args = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                this.lastResourcesModificationCount = modificationCount;
                this.lastNavigationVersion = currVersion;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<LightDirectionsClass> createLightDirectionsClasses(AndroidFacet facet2, String modulePackage, NavEntry entry) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NavDestinationData destination;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = entry.getData().getResolvedDestinations();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            destination = (NavDestinationData)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)destination.getActions()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination = (NavDestinationData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new LightDirectionsClass(facet2, modulePackage, entry.getResource(), entry.getData(), destination));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<LightArgsClass> createLightArgsClasses(AndroidFacet facet2, String modulePackage, GradleVersion navigationVersion, NavEntry entry) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NavDestinationData destination;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = entry.getData().getResolvedDestinations();
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            destination = (NavDestinationData)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)destination.getArguments()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination = (NavDestinationData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new LightArgsClass(facet2, modulePackage, navigationVersion, entry.getResource(), destination));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    @NotNull
    public static final SafeArgsCacheModuleService getInstance(@NotNull AndroidFacet facet2) {
        return Companion.getInstance(facet2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/nav/safeargs/module/SafeArgsCacheModuleService$NavEntry;", "", "resource", "Lcom/android/ide/common/resources/ResourceItem;", "data", "Lcom/android/tools/idea/nav/safeargs/index/NavXmlData;", "(Lcom/android/ide/common/resources/ResourceItem;Lcom/android/tools/idea/nav/safeargs/index/NavXmlData;)V", "getData", "()Lcom/android/tools/idea/nav/safeargs/index/NavXmlData;", "getResource", "()Lcom/android/ide/common/resources/ResourceItem;", "intellij.android.nav.safeargs"})
    private static final class NavEntry {
        @NotNull
        private final ResourceItem resource;
        @NotNull
        private final NavXmlData data;

        public NavEntry(@NotNull ResourceItem resource, @NotNull NavXmlData data2) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.resource = resource;
            this.data = data2;
        }

        @NotNull
        public final ResourceItem getResource() {
            return this.resource;
        }

        @NotNull
        public final NavXmlData getData() {
            return this.data;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/nav/safeargs/module/SafeArgsCacheModuleService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/nav/safeargs/module/SafeArgsCacheModuleService;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.nav.safeargs"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SafeArgsCacheModuleService getInstance(@NotNull AndroidFacet facet2) {
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            Object object = facet2.getModule().getService(SafeArgsCacheModuleService.class);
            Intrinsics.checkNotNull((Object)object);
            return (SafeArgsCacheModuleService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

