/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ImmutablePermissionHolder;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MergedManifestSnapshotFactory {
    MergedManifestSnapshotFactory() {
    }

    @Nullable
    private static String getAttributeValue(@NotNull Element element2, @Nullable String namespaceUri, @NotNull String attributeName) {
        return Strings.emptyToNull((String)element2.getAttributeNS(namespaceUri, attributeName));
    }

    @Nullable
    private static ResourceValue getResourceValue(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull Element element2, @Nullable String namespaceUri, @NotNull String attributeName) {
        String value2 = MergedManifestSnapshotFactory.getAttributeValue(element2, namespaceUri, attributeName);
        if (value2 == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse((String)value2);
        ResourceReference reference = url == null ? null : url.resolve(namespace, namespacePrefix -> element2.lookupNamespaceURI(namespacePrefix));
        return new ManifestResourceValue(namespace, type, attributeName, value2, reference);
    }

    private static AndroidVersion getApiVersion(@NotNull Element usesSdk, @NotNull String attribute, @NotNull AndroidVersion defaultApiLevel) {
        AndroidVersion version2;
        String valueString = MergedManifestSnapshotFactory.getAttributeValue(usesSdk, "http://schemas.android.com/apk/res/android", attribute);
        if (valueString != null && (version2 = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version2;
        }
        return defaultApiLevel;
    }

    @Deprecated
    @NotNull
    static MergedManifestSnapshot createEmptyMergedManifestSnapshot(@NotNull Module module2) {
        return new MergedManifestSnapshot(module2, null, null, null, (ImmutableMap<String, ActivityAttributesSnapshot>)ImmutableMap.of(), null, AndroidVersion.DEFAULT, AndroidVersion.DEFAULT, null, null, false, null, null, null, ImmutablePermissionHolder.EMPTY, false, (ImmutableList<Element>)ImmutableList.of(), (ImmutableList<Element>)ImmutableList.of(), (ImmutableList<Element>)ImmutableList.of(), null, (ImmutableList<MergingReport.Record>)ImmutableList.of(), false);
    }

    @NotNull
    static MergedManifestSnapshot createMergedManifestSnapshot(@NotNull AndroidFacet facet2, @NotNull MergedManifestInfo mergedManifestInfo) {
        try {
            Element root;
            Document document2 = mergedManifestInfo.getXmlDocument();
            Element element2 = root = document2 == null ? null : document2.getDocumentElement();
            if (root == null) {
                throw new MergedManifestException.MissingElement("manifest", mergedManifestInfo);
            }
            String appId = MergedManifestSnapshotFactory.getAttributeValue(root, null, "package");
            String packageName2 = ProjectSystemUtil.getModuleSystem(facet2).getPackageName();
            if (packageName2 == null) {
                throw new MergedManifestException.MissingAttribute("manifest", null, "package", mergedManifestInfo);
            }
            Namespacing namespacing = ResourceRepositoryManager.getInstance(facet2).getNamespacing();
            ResourceNamespace namespace = namespacing == Namespacing.DISABLED ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)packageName2);
            String versionCodeStr = MergedManifestSnapshotFactory.getAttributeValue(root, "http://schemas.android.com/apk/res/android", "versionCode");
            Integer versionCode2 = null;
            try {
                versionCode2 = versionCodeStr != null ? Integer.valueOf(versionCodeStr) : null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ResourceValue appIcon = null;
            ResourceValue appLabel = null;
            String manifestTheme = null;
            boolean supportsRtl = false;
            Boolean isAppDebuggable = null;
            boolean appHasCode = true;
            HashMap<String, ActivityAttributesSnapshot> activityAttributesMap = new HashMap<String, ActivityAttributesSnapshot>();
            ArrayList<Element> activities2 = new ArrayList<Element>();
            ArrayList<Element> activityAliases = new ArrayList<Element>(4);
            ArrayList<Element> services = new ArrayList<Element>(4);
            AndroidVersion targetSdk = AndroidVersion.DEFAULT;
            AndroidVersion minSdk = AndroidVersion.DEFAULT;
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)2);
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                String name;
                String protectionLevel;
                Element element3;
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if ("application".equals(nodeName)) {
                    Element application = (Element)node;
                    appIcon = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.DRAWABLE, application, "http://schemas.android.com/apk/res/android", "icon");
                    appLabel = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.STRING, application, "http://schemas.android.com/apk/res/android", "label");
                    manifestTheme = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "theme");
                    supportsRtl = "true".equals(MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "supportsRtl"));
                    String debuggable2 = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "debuggable");
                    isAppDebuggable = debuggable2 == null ? null : Boolean.valueOf("true".equals(debuggable2));
                    String hasCode = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "hasCode");
                    appHasCode = hasCode == null || "true".equals(hasCode);
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 1) continue;
                        String childNodeName = child.getNodeName();
                        if ("activity".equals(childNodeName)) {
                            Element element4 = (Element)child;
                            ActivityAttributesSnapshot attributes = MergedManifestSnapshotFactory.createActivityAttributesSnapshot(element4, packageName2, namespace);
                            activityAttributesMap.put(attributes.getName(), attributes);
                            activities2.add(element4);
                            continue;
                        }
                        if ("activity-alias".equals(childNodeName)) {
                            activityAliases.add((Element)child);
                            continue;
                        }
                        if (!"service".equals(childNodeName)) continue;
                        services.add((Element)child);
                    }
                    continue;
                }
                if ("uses-sdk".equals(nodeName)) {
                    Element usesSdk = (Element)node;
                    minSdk = MergedManifestSnapshotFactory.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                    targetSdk = MergedManifestSnapshotFactory.getApiVersion(usesSdk, "targetSdkVersion", minSdk);
                    continue;
                }
                if ("uses-permission".equals(nodeName) || "uses-permission-sdk-23".equals(nodeName) || "uses-permission-sdk-m".equals(nodeName)) {
                    element3 = (Element)node;
                    String name2 = element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (name2.isEmpty()) continue;
                    permissions.add(name2);
                    continue;
                }
                if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element3 = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
                revocable.add(name);
            }
            AndroidVersion modelMinSdk = null;
            AndroidVersion modelTargetSdk = null;
            AndroidModel androidModel = AndroidModel.get(facet2);
            if (androidModel != null) {
                modelMinSdk = androidModel.getMinSdkVersion();
                modelTargetSdk = androidModel.getTargetSdkVersion();
            }
            ImmutablePermissionHolder permissionHolder = new ImmutablePermissionHolder(modelMinSdk == null ? minSdk : modelMinSdk, modelTargetSdk == null ? targetSdk : modelTargetSdk, (Set<String>)ImmutableSet.copyOf((Collection)permissions), (Set<String>)ImmutableSet.copyOf((Collection)revocable));
            Actions actions2 = mergedManifestInfo.getActions();
            ImmutableList<MergingReport.Record> loggingRecords = mergedManifestInfo.getLoggingRecords();
            return new MergedManifestSnapshot(facet2.getModule(), packageName2, versionCode2, manifestTheme, (ImmutableMap<String, ActivityAttributesSnapshot>)ImmutableMap.copyOf(activityAttributesMap), mergedManifestInfo, minSdk, targetSdk, appIcon, appLabel, supportsRtl, isAppDebuggable, document2, (ImmutableList<VirtualFile>)ImmutableList.copyOf(mergedManifestInfo.getFiles()), permissionHolder, appHasCode, (ImmutableList<Element>)ImmutableList.copyOf(activities2), (ImmutableList<Element>)ImmutableList.copyOf(activityAliases), (ImmutableList<Element>)ImmutableList.copyOf(services), actions2, loggingRecords, true);
        }
        catch (MergedManifestException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MergedManifestException.ParsingError(mergedManifestInfo, (Throwable)e);
        }
    }

    @NotNull
    private static ActivityAttributesSnapshot createActivityAttributesSnapshot(@NotNull Element activity, @Nullable String packageName2, @NotNull ResourceNamespace namespace) {
        Object name = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "name");
        if (name == null || ((String)name).isEmpty()) {
            throw new RuntimeException("Activity name cannot be empty.");
        }
        int index2 = ((String)name).indexOf(46);
        if (index2 <= 0 && packageName2 != null && !packageName2.isEmpty()) {
            name = packageName2 + (index2 == -1 ? "." : "") + (String)name;
        }
        ResourceValue icon2 = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.DRAWABLE, activity, "http://schemas.android.com/apk/res/android", "icon");
        ResourceValue label = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.STRING, activity, "http://schemas.android.com/apk/res/android", "label");
        Object value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "parentActivityName");
        if (value2 == null || ((String)value2).isEmpty()) {
            for (Node child = activity.getFirstChild(); child != null; child = child.getNextSibling()) {
                String metaDataName;
                if (child.getNodeType() != 1 || !child.getNodeName().equals("meta-data") || !"android.support.PARENT_ACTIVITY".equals(metaDataName = MergedManifestSnapshotFactory.getAttributeValue((Element)child, "http://schemas.android.com/apk/res/android", "name")) || (value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "value")) == null || (index2 = ((String)value2).indexOf(46)) > 0 || packageName2 == null || packageName2.isEmpty()) continue;
                value2 = packageName2 + (index2 == -1 ? "." : "") + (String)value2;
                break;
            }
        }
        String parentActivity = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "theme");
        String theme = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "uiOptions");
        String uiOptions = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        return new ActivityAttributesSnapshot(activity, icon2, label, (String)name, parentActivity, theme, uiOptions);
    }

    private static class ManifestResourceValue
    extends ResourceValueImpl {
        @Nullable
        private final ResourceReference myReference;

        ManifestResourceValue(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull String name, @Nullable String value2, @Nullable ResourceReference reference) {
            super(namespace, type, name, value2);
            this.myReference = reference;
        }

        @Nullable
        public ResourceReference getReference() {
            return this.myReference;
        }
    }
}

