/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LowAgpVersionNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"ml.low.agp.notification.panel");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"ml.low.ago.notification.panel.hidden");
    private static final String MIN_AGP_VERSION = "4.1.0-alpha10";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        AgpVersion agpVersion;
        if (fileEditor.getUserData(HIDDEN_KEY) != null || !(fileEditor instanceof TfliteModelFileEditor)) {
            return null;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        AgpVersion agpVersion2 = agpVersion = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        if (agpVersion == null || agpVersion.compareTo(MIN_AGP_VERSION) >= 0) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
        panel2.setText("ML Model Binding is not fully supported in the current Android Gradle Plugin, so please update to the latest version.");
        panel2.createActionLabel("Hide notification", () -> {
            fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        });
        return panel2;
    }
}

