/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.notifications;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.viewer.TfliteModelFileEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesTooLowNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"ml.deps.too.low.notification.panel");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"ml.deps.too.low.notification.panel.hidden");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (fileEditor.getUserData(HIDDEN_KEY) != null || !(fileEditor instanceof TfliteModelFileEditor)) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
        if (module2 == null || !MlUtils.isMlModelBindingBuildFeatureEnabled(module2) || !MlUtils.isModelFileInMlModelsFolder(module2, file2)) {
            return null;
        }
        List<Pair<GradleCoordinate, GradleCoordinate>> depPairList = MlUtils.getDependenciesLowerThanRequiredVersion(module2);
        if (!depPairList.isEmpty()) {
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
            panel2.setText("ML Model Binding requires updated dependencies");
            panel2.createActionLabel("View dependencies", () -> {
                String existingDepString = depPairList.stream().map(it -> (GradleCoordinate)it.getFirst()).map(it -> String.format(Locale.US, "    %s:%s:%s\n", it.getGroupId(), it.getArtifactId(), it.getRevision())).collect(Collectors.joining(""));
                String requiredDepString = depPairList.stream().map(it -> (GradleCoordinate)it.getSecond()).map(it -> String.format(Locale.US, "    %s:%s:%s\n", it.getGroupId(), it.getArtifactId(), it.getRevision())).collect(Collectors.joining(""));
                Messages.showWarningDialog((String)String.format(Locale.US, "Existing:\n%s\nRequired:\n%s", existingDepString, requiredDepString), (String)"Dependencies Needing Updates");
            });
            panel2.createActionLabel("Hide notification", () -> {
                fileEditor.putUserData(HIDDEN_KEY, (Object)"true");
                EditorNotifications.getInstance((Project)project).updateNotifications(file2);
            });
            return panel2;
        }
        return null;
    }
}

