/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.importmodel;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.mlkit.importmodel.ChooseMlModelStep;
import com.android.tools.idea.mlkit.importmodel.MlWizardModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.StudioWizardDialogBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ImportMlModelAction
extends AnAction {
    @VisibleForTesting
    static final String MIN_AGP_VERSION = "4.1.0-alpha04";
    @VisibleForTesting
    static final String TITLE = "TensorFlow Lite Model";
    @VisibleForTesting
    static final int MIN_SDK_VERSION = 19;

    public ImportMlModelAction() {
        super(TITLE, null, StudioIcons.Shell.Filetree.ANDROID_FILE);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        List<NamedModuleTemplate> moduleTemplates = ImportMlModelAction.getModuleTemplates(e);
        if (!moduleTemplates.isEmpty() && module2 != null && e.getProject() != null) {
            String title = "Import TensorFlow Lite model";
            ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(new ChooseMlModelStep(new MlWizardModel(module2), moduleTemplates, e.getProject(), title)).build();
            new StudioWizardDialogBuilder(wizard, title).build().show();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(e.getDataContext());
        if (module2 == null) {
            presentation.setEnabled(false);
            return;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (androidPluginInfo == null) {
            presentation.setEnabled(false);
            return;
        }
        AgpVersion agpVersion = androidPluginInfo.getPluginVersion();
        if (agpVersion == null || agpVersion.compareTo(MIN_AGP_VERSION) < 0) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.message("android.wizard.action.requires.new.agp", TITLE, MIN_AGP_VERSION));
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            presentation.setEnabled(false);
            return;
        }
        if (AndroidModuleInfo.getInstance(androidFacet).getMinSdkVersion().getFeatureLevel() < 19) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.message("android.wizard.action.requires.minsdk", TITLE, 19));
            return;
        }
        if (ImportMlModelAction.getModuleTemplates(e).isEmpty()) {
            presentation.setEnabled(false);
        }
        presentation.setEnabledAndVisible(true);
    }

    @NotNull
    private static List<NamedModuleTemplate> getModuleTemplates(@NotNull AnActionEvent e) {
        if (e.getProject() == null) {
            return Collections.emptyList();
        }
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(e.getDataContext());
        VirtualFile virtualFile = e.getProject().getProjectFile();
        if (module2 == null || virtualFile == null) {
            return Collections.emptyList();
        }
        return ProjectSystemUtil.getModuleSystem(module2).getModuleTemplates(virtualFile);
    }
}

