/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.importmodel;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.mlkit.importmodel.MlWizardModel;
import com.android.tools.idea.npw.template.components.ModuleTemplateComboProvider;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TfliteModelException;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseMlModelStep
extends ModelWizardStep<MlWizardModel> {
    private final BindingsManager myBindings;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myModelLocation;
    private ComboBox<NamedModuleTemplate> myFlavorBox;
    private JCheckBox myBasicCheckBox;
    private JTextArea myBasicTextArea;
    private JCheckBox myGpuCheckBox;
    private JTextArea myGpuTextArea;
    private HyperlinkLabel myLearnMoreLabel;

    public ChooseMlModelStep(@NotNull MlWizardModel model2, @NotNull List<NamedModuleTemplate> moduleTemplates, @NotNull Project project, @NotNull String title) {
        super(model2, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myModelLocation.addBrowseFolderListener("Select TensorFlow Lite Model Location", "Select existing TensorFlow Lite model to import to ml folder", project, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor());
        for (NamedModuleTemplate namedModuleTemplate : moduleTemplates) {
            this.myFlavorBox.addItem((Object)namedModuleTemplate);
        }
        this.myLearnMoreLabel.setIcon(StudioIcons.Common.INFO);
        this.myLearnMoreLabel.setHyperlinkText("This is needed to ensure ML Model Binding works correctly ", "Learn more", "");
        this.myLearnMoreLabel.setHyperlinkTarget("https://developer.android.com/studio/write/mlmodelbinding");
        this.myBindings.bindTwoWay(new TextProperty(this.myModelLocation.getTextField()), model2.sourceLocation);
        this.myBindings.bindTwoWay(new SelectedProperty(this.myBasicCheckBox), model2.autoAddBasicSetup);
        this.myBindings.bindTwoWay(new SelectedProperty(this.myGpuCheckBox), model2.autoAddGpuSetup);
        this.myBasicTextArea.setBackground(null);
        this.myBasicTextArea.setForeground((Color)JBColor.DARK_GRAY);
        this.myGpuTextArea.setBackground(null);
        this.myGpuTextArea.setForeground((Color)JBColor.DARK_GRAY);
        String basicText = this.getBasicInformationText();
        this.myBasicTextArea.setText(basicText);
        if (basicText.isEmpty()) {
            this.myBasicCheckBox.setVisible(false);
            this.myBasicTextArea.setVisible(false);
            model2.autoAddBasicSetup.set(false);
        }
        String gpuText = this.getGpuInformationText();
        this.myGpuTextArea.setText(gpuText);
        if (gpuText.isEmpty()) {
            this.myGpuCheckBox.setVisible(false);
            this.myGpuTextArea.setVisible(false);
        }
        if (basicText.isEmpty() && gpuText.isEmpty()) {
            this.myLearnMoreLabel.setVisible(false);
        }
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        SelectedItemProperty selectedFavor = new SelectedItemProperty((JComboBox)this.myFlavorBox);
        this.myValidatorPanel.registerValidator(ObjectProperty.wrap(selectedFavor), value2 -> ChooseMlModelStep.checkFlavor(value2), new ObservableValue[0]);
        Expression<File> locationFile = model2.sourceLocation.transform(File::new);
        this.myValidatorPanel.registerValidator(locationFile, value2 -> this.checkPath((File)value2), new ObservableValue[]{selectedFavor});
        this.myValidatorPanel.setBorder(WizardUtils.WIZARD_BORDER.LARGE.border);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }

    @NotNull
    private String getBasicInformationText() {
        StringBuilder stringBuilder = new StringBuilder();
        Module module2 = ((MlWizardModel)this.getModel()).getModule();
        if (!MlUtils.isMlModelBindingBuildFeatureEnabled(module2)) {
            stringBuilder.append("buildFeatures {\n  mlModelBinding true\n}\n\n");
        }
        for (GradleCoordinate dep : MlUtils.getMissingRequiredDependencies(module2)) {
            stringBuilder.append(dep).append("\n");
        }
        return stringBuilder.toString();
    }

    @NotNull
    private String getGpuInformationText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (GradleCoordinate dep : MlUtils.getMissingTfliteGpuDependencies(((MlWizardModel)this.getModel()).getModule())) {
            stringBuilder.append(dep).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        super.onProceeding();
        File mlDirectory = ChooseMlModelStep.getMlDirectory(((NamedModuleTemplate)this.myFlavorBox.getSelectedItem()).component2());
        ((MlWizardModel)this.getModel()).mlDirectory.set(mlDirectory.getAbsolutePath());
    }

    @NotNull
    @VisibleForTesting
    Validator.Result checkPath(@NotNull File file2) {
        VirtualFile existingFile;
        if (!file2.isFile()) {
            return new Validator.Result(Validator.Severity.ERROR, "Select a TensorFlow Lite model file to import.");
        }
        if (file2.length() > 0xC800000L) {
            return new Validator.Result(Validator.Severity.ERROR, "This file is larger than the maximum supported size of 200 MB.");
        }
        if (!ChooseMlModelStep.isValidTfliteModel(file2)) {
            return new Validator.Result(Validator.Severity.ERROR, "This is not a valid TensorFlow Lite model file.");
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        if (Objects.equals(virtualFile, existingFile = this.findExistingModelFile(file2.getName()))) {
            return new Validator.Result(Validator.Severity.ERROR, "This model file is already part of your project.");
        }
        if (existingFile != null && existingFile.exists()) {
            return new Validator.Result(Validator.Severity.WARNING, "File already exists in your project and will be overridden. If you would like to upload it as a separate file, please rename it.");
        }
        return Validator.Result.OK;
    }

    @Nullable
    private VirtualFile findExistingModelFile(@NotNull String fileName) {
        VirtualFile directory = VfsUtil.findFileByIoFile((File)ChooseMlModelStep.getMlDirectory(((NamedModuleTemplate)this.myFlavorBox.getSelectedItem()).component2()), (boolean)false);
        if (directory == null || !directory.exists()) {
            return null;
        }
        return directory.findChild(fileName);
    }

    private static File getMlDirectory(AndroidModulePaths androidModulePaths) {
        List<File> mlDirectories = androidModulePaths.getMlModelsDirectories();
        if (!mlDirectories.isEmpty()) {
            return mlDirectories.get(0);
        }
        return new File(androidModulePaths.getManifestDirectory(), "ml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidTfliteModel(@NotNull File file2) {
        if (!file2.getName().endsWith(".tflite")) {
            return false;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        if (virtualFile == null) {
            return false;
        }
        try {
            byte[] bytes2 = null;
            try {
                bytes2 = virtualFile.contentsToByteArray();
            }
            catch (FileTooBigException e) {
                bytes2 = Files.readAllBytes(file2.toPath());
            }
            finally {
                if (bytes2 == null) {
                    return false;
                }
                ModelInfo.buildFrom((ByteBuffer)ByteBuffer.wrap(bytes2));
            }
        }
        catch (TfliteModelException | IOException | RuntimeException e) {
            Logger.getInstance(ChooseMlModelStep.class).warn("Exception when parsing TensorFlow Lite model: " + file2.getName(), e);
            return false;
        }
        return true;
    }

    @NotNull
    private static Validator.Result checkFlavor(@NotNull NamedModuleTemplate flavor) {
        if (flavor.getPaths().getMlModelsDirectories().isEmpty()) {
            new Validator.Result(Validator.Severity.ERROR, "No valid ml directory in checkFlavor.");
        }
        return Validator.Result.OK;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myModelLocation;
    }

    private void createUIComponents() {
        this.myFlavorBox = new ModuleTemplateComboProvider(Collections.emptyList()).createComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JCheckBox jCheckBox;
        HyperlinkLabel hyperlinkLabel2;
        JTextArea jTextArea2;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(200, 109));
        this.myModelLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setName("Location Browser Button");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Model location:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 2, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Create ml directory in");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 2, 1, 3, null, new Dimension(-1, 60), new Dimension(-1, 60)));
        ComboBox<NamedModuleTemplate> comboBox2 = this.myFlavorBox;
        jPanel.add((Component)comboBox2, new GridConstraints(2, 2, 1, 1, 8, 0, 2, 3, null, null, null));
        this.myBasicCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Automatically add build feature and dependencies to build.gradle");
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myBasicTextArea = jTextArea2 = new JTextArea();
        jTextArea2.setMargin(new Insets(0, 2, 0, 0));
        jPanel.add((Component)jTextArea2, new GridConstraints(4, 0, 1, 4, 8, 2, 0, 3, null, null, null, 2));
        this.myLearnMoreLabel = hyperlinkLabel2 = new HyperlinkLabel();
        hyperlinkLabel2.setAlignmentY(0.0f);
        hyperlinkLabel2.setText("");
        jPanel.add((Component)hyperlinkLabel2, new GridConstraints(7, 0, 1, 4, 9, 0, 0, 1, null, null, null, 2));
        this.myGpuCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Automatically add TensorFlow Lite GPU dependencies to build.gradle (optional)");
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myGpuTextArea = jTextArea = new JTextArea();
        jTextArea.setMargin(new Insets(0, 2, 0, 0));
        jTextArea.setText("");
        jPanel.add((Component)jTextArea, new GridConstraints(6, 0, 1, 4, 8, 2, 0, 3, null, null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

