/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.settings;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.LogcatPresenter;
import com.android.tools.idea.logcat.LogcatToolWindowFactory;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterFileType;
import com.android.tools.idea.logcat.settings.AndroidLogcatSettings;
import com.android.tools.idea.logcat.settings.LogcatApplicationSettingsConfigurableKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GridBag;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\u000f\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\r8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00158\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00158\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u00020\u00158\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/logcat/settings/LogcatApplicationSettingsConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "logcatSettings", "Lcom/android/tools/idea/logcat/settings/AndroidLogcatSettings;", "(Lcom/android/tools/idea/logcat/settings/AndroidLogcatSettings;)V", "component", "Ljavax/swing/JPanel;", "cycleBufferSizeTextField", "Ljavax/swing/JTextField;", "getCycleBufferSizeTextField$intellij_android_logcat", "()Ljavax/swing/JTextField;", "cyclicBufferSizeWarningLabel", "Ljavax/swing/JLabel;", "getCyclicBufferSizeWarningLabel$intellij_android_logcat", "()Ljavax/swing/JLabel;", "defaultFilterTextField", "Lcom/intellij/ui/EditorTextField;", "getDefaultFilterTextField$intellij_android_logcat", "()Lcom/intellij/ui/EditorTextField;", "enableNamedFiltersCheckbox", "Ljavax/swing/JCheckBox;", "getEnableNamedFiltersCheckbox$intellij_android_logcat", "()Ljavax/swing/JCheckBox;", "filterHistoryAutocompleteCheckbox", "getFilterHistoryAutocompleteCheckbox$intellij_android_logcat", "mostRecentlyUsedFilterIsDefaultCheckbox", "getMostRecentlyUsedFilterIsDefaultCheckbox$intellij_android_logcat", "apply", "", "createComponent", "getBufferSizeKb", "", "()Ljava/lang/Integer;", "getDisplayName", "", "isModified", "", "updateWarningLabel", "intellij.android.logcat"})
public final class LogcatApplicationSettingsConfigurable
implements Configurable,
Configurable.NoScroll {
    @NotNull
    private final AndroidLogcatSettings logcatSettings;
    @VisibleForTesting
    @NotNull
    private final JTextField cycleBufferSizeTextField;
    @VisibleForTesting
    @NotNull
    private final EditorTextField defaultFilterTextField;
    @VisibleForTesting
    @NotNull
    private final JCheckBox mostRecentlyUsedFilterIsDefaultCheckbox;
    @VisibleForTesting
    @NotNull
    private final JLabel cyclicBufferSizeWarningLabel;
    @VisibleForTesting
    @NotNull
    private final JCheckBox filterHistoryAutocompleteCheckbox;
    @VisibleForTesting
    @NotNull
    private final JCheckBox enableNamedFiltersCheckbox;
    @NotNull
    private final JPanel component;

    /*
     * WARNING - void declaration
     */
    public LogcatApplicationSettingsConfigurable(@NotNull AndroidLogcatSettings logcatSettings) {
        void $this$component_u24lambda_u2d3;
        JComponent $this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u2d2;
        JComponent $this$defaultFilterTextField_u24lambda_u2d1;
        JTextField $this$cycleBufferSizeTextField_u24lambda_u2d0;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)logcatSettings, (String)"logcatSettings");
        this.logcatSettings = logcatSettings;
        JTextField jTextField = jComponent = new JTextField(10);
        LogcatApplicationSettingsConfigurable logcatApplicationSettingsConfigurable = this;
        boolean bl = false;
        $this$cycleBufferSizeTextField_u24lambda_u2d0.setText(String.valueOf(this.logcatSettings.getBufferSize() / 1024));
        logcatApplicationSettingsConfigurable.cycleBufferSizeTextField = jComponent;
        $this$cycleBufferSizeTextField_u24lambda_u2d0 = jComponent = new EditorTextField(ProjectManager.getInstance().getDefaultProject(), (FileType)LogcatFilterFileType.INSTANCE);
        logcatApplicationSettingsConfigurable = this;
        boolean bl2 = false;
        $this$defaultFilterTextField_u24lambda_u2d1.setEnabled(!this.logcatSettings.getMostRecentlyUsedFilterIsDefault());
        logcatApplicationSettingsConfigurable.defaultFilterTextField = jComponent;
        $this$defaultFilterTextField_u24lambda_u2d1 = jComponent = new JCheckBox(LogcatBundle.message("logcat.settings.default.filter.mru", new Object[0]));
        logcatApplicationSettingsConfigurable = this;
        boolean bl3 = false;
        ((AbstractButton)$this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u2d2).setSelected(this.logcatSettings.getMostRecentlyUsedFilterIsDefault());
        ((AbstractButton)$this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u2d2).addActionListener(new ActionListener(this, (JCheckBox)$this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u2d2){
            final /* synthetic */ LogcatApplicationSettingsConfigurable this$0;
            final /* synthetic */ JCheckBox $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public final void actionPerformed(ActionEvent it) {
                this.this$0.getDefaultFilterTextField$intellij_android_logcat().setEnabled(!this.$this_apply.isSelected());
            }
        });
        logcatApplicationSettingsConfigurable.mostRecentlyUsedFilterIsDefaultCheckbox = jComponent;
        this.cyclicBufferSizeWarningLabel = new JLabel();
        this.filterHistoryAutocompleteCheckbox = new JCheckBox(LogcatBundle.message("logcat.settings.history.autocomplete", new Object[0]), this.logcatSettings.getFilterHistoryAutocomplete());
        this.enableNamedFiltersCheckbox = new JCheckBox(LogcatBundle.message("logcat.settings.enable.named.filters", new Object[0]), this.logcatSettings.getNamedFiltersEnabled());
        $this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u2d2 = jComponent = new JPanel(new GridBagLayout());
        logcatApplicationSettingsConfigurable = this;
        boolean bl4 = false;
        this.cyclicBufferSizeWarningLabel.setForeground((Color)JBColor.red);
        this.cycleBufferSizeTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ LogcatApplicationSettingsConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LogcatApplicationSettingsConfigurable.access$updateWarningLabel(this.this$0);
            }
        });
        GridBag gridBag = new GridBag().anchor(18);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"GridBag().anchor(NORTHWEST)");
        GridBag gridBag2 = gridBag;
        $this$component_u24lambda_u2d3.add((Component)new JLabel(LogcatBundle.message("logcat.settings.buffer.size", new Object[0])), gridBag2.nextLine().next().anchor(17));
        $this$component_u24lambda_u2d3.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag2.next());
        $this$component_u24lambda_u2d3.add((Component)this.cycleBufferSizeTextField, gridBag2.next().anchor(17));
        $this$component_u24lambda_u2d3.add((Component)new JLabel(LogcatBundle.message("logcat.settings.buffer.kb", new Object[0])), gridBag2.next().weightx(1.0).anchor(17));
        $this$component_u24lambda_u2d3.add((Component)this.cyclicBufferSizeWarningLabel, gridBag2.nextLine().next().coverLine().anchor(18));
        $this$component_u24lambda_u2d3.add((Component)new JLabel(LogcatBundle.message("logcat.settings.default.filter", new Object[0])), gridBag2.nextLine().next().anchor(17));
        $this$component_u24lambda_u2d3.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag2.next());
        $this$component_u24lambda_u2d3.add((Component)this.defaultFilterTextField, gridBag2.next().anchor(17).fillCellHorizontally().weightx(1.0).coverLine());
        $this$component_u24lambda_u2d3.add((Component)this.mostRecentlyUsedFilterIsDefaultCheckbox, gridBag2.nextLine().setColumn(2).coverLine().anchor(17));
        $this$component_u24lambda_u2d3.add((Component)this.filterHistoryAutocompleteCheckbox, gridBag2.nextLine().next().coverLine().anchor(18));
        Object t = StudioFlags.LOGCAT_NAMED_FILTERS_ENABLE.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"LOGCAT_NAMED_FILTERS_ENABLE.get()");
        if (((Boolean)t).booleanValue()) {
            $this$component_u24lambda_u2d3.add((Component)this.enableNamedFiltersCheckbox, gridBag2.nextLine().next().coverLine().anchor(18));
        }
        $this$component_u24lambda_u2d3.add((Component)new JPanel(), gridBag2.nextLine().next().weighty(1.0));
        logcatApplicationSettingsConfigurable.component = jComponent;
    }

    @NotNull
    public final JTextField getCycleBufferSizeTextField$intellij_android_logcat() {
        return this.cycleBufferSizeTextField;
    }

    @NotNull
    public final EditorTextField getDefaultFilterTextField$intellij_android_logcat() {
        return this.defaultFilterTextField;
    }

    @NotNull
    public final JCheckBox getMostRecentlyUsedFilterIsDefaultCheckbox$intellij_android_logcat() {
        return this.mostRecentlyUsedFilterIsDefaultCheckbox;
    }

    @NotNull
    public final JLabel getCyclicBufferSizeWarningLabel$intellij_android_logcat() {
        return this.cyclicBufferSizeWarningLabel;
    }

    @NotNull
    public final JCheckBox getFilterHistoryAutocompleteCheckbox$intellij_android_logcat() {
        return this.filterHistoryAutocompleteCheckbox;
    }

    @NotNull
    public final JCheckBox getEnableNamedFiltersCheckbox$intellij_android_logcat() {
        return this.enableNamedFiltersCheckbox;
    }

    @NotNull
    public JPanel createComponent() {
        JPanel jPanel;
        JPanel $this$createComponent_u24lambda_u2d4 = jPanel = this.component;
        boolean bl = false;
        this.defaultFilterTextField.setText(this.logcatSettings.getDefaultFilter());
        return jPanel;
    }

    private final void updateWarningLabel() {
        String string;
        Integer value2 = this.getBufferSizeKb();
        if (value2 == null || !LogcatApplicationSettingsConfigurableKt.access$isValidBufferSize(value2)) {
            Object[] objectArray = new Object[]{"102400", "100"};
            string = LogcatBundle.message("logcat.settings.buffer.warning.invalid", objectArray);
        } else {
            string = value2 > FileUtilRt.LARGE_FOR_CONTENT_LOADING / 1024 ? LogcatBundle.message("logcat.settings.buffer.warning.tooLarge", new Object[0]) : "";
        }
        this.cyclicBufferSizeWarningLabel.setText(string);
    }

    @NotNull
    public String getDisplayName() {
        return LogcatBundle.message("logcat.settings.title", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        Integer bufferSizeKb = this.getBufferSizeKb();
        if (bufferSizeKb != null && LogcatApplicationSettingsConfigurableKt.access$isValidBufferSize(bufferSizeKb)) {
            int n = this.logcatSettings.getBufferSize() / 1024;
            if (bufferSizeKb != n) return true;
        }
        if (!Intrinsics.areEqual((Object)this.defaultFilterTextField.getText(), (Object)this.logcatSettings.getDefaultFilter())) return true;
        if (this.mostRecentlyUsedFilterIsDefaultCheckbox.isSelected() != this.logcatSettings.getMostRecentlyUsedFilterIsDefault()) return true;
        if (this.filterHistoryAutocompleteCheckbox.isSelected() != this.logcatSettings.getFilterHistoryAutocomplete()) return true;
        if (this.enableNamedFiltersCheckbox.isSelected() == this.logcatSettings.getNamedFiltersEnabled()) return false;
        return true;
    }

    public void apply() {
        Integer n = this.getBufferSizeKb();
        if (n == null) {
            return;
        }
        this.logcatSettings.setBufferSize(n * 1024);
        String string = this.defaultFilterTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultFilterTextField.text");
        this.logcatSettings.setDefaultFilter(string);
        this.logcatSettings.setMostRecentlyUsedFilterIsDefault(this.mostRecentlyUsedFilterIsDefaultCheckbox.isSelected());
        this.logcatSettings.setFilterHistoryAutocomplete(this.filterHistoryAutocompleteCheckbox.isSelected());
        this.logcatSettings.setNamedFiltersEnabled(this.enableNamedFiltersCheckbox.isSelected());
        Iterable $this$forEach$iv = LogcatToolWindowFactory.Companion.getLogcatPresenters$intellij_android_logcat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogcatPresenter it = (LogcatPresenter)element$iv;
            boolean bl = false;
            it.applyLogcatSettings(this.logcatSettings);
        }
    }

    private final Integer getBufferSizeKb() {
        Integer n;
        try {
            String string = this.cycleBufferSizeTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cycleBufferSizeTextField.text");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            n = null;
        }
        return n;
    }

    public static final /* synthetic */ void access$updateWarningLabel(LogcatApplicationSettingsConfigurable $this) {
        $this.updateWarningLabel();
    }
}

