/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0006J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\nJ\u0006\u0010#\u001a\u00020 R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator;", "", "()V", "filterHintRanges", "", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$Range;", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint;", "getFilterHintRanges", "()Ljava/util/List;", "messageRanges", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "getMessageRanges", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "", "getText", "()Ljava/lang/String;", "textAttributesKeyRanges", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getTextAttributesKeyRanges", "textAttributesRanges", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getTextAttributesRanges", "accumulate", "textAttributes", "textAttributesKey", "filterHint", "addMessageRange", "", "start", "", "end", "message", "getTextLength", "FilterHint", "Range", "intellij.android.logcat"})
public final class TextAccumulator {
    @NotNull
    private final StringBuilder stringBuilder = new StringBuilder();
    @NotNull
    private final List<Range<TextAttributes>> textAttributesRanges = new ArrayList();
    @NotNull
    private final List<Range<TextAttributesKey>> textAttributesKeyRanges = new ArrayList();
    @NotNull
    private final List<Range<FilterHint>> filterHintRanges = new ArrayList();
    @NotNull
    private final List<Range<LogcatMessage>> messageRanges = new ArrayList();

    @NotNull
    public final String getText() {
        String string = this.stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    @NotNull
    public final List<Range<TextAttributes>> getTextAttributesRanges() {
        return this.textAttributesRanges;
    }

    @NotNull
    public final List<Range<TextAttributesKey>> getTextAttributesKeyRanges() {
        return this.textAttributesKeyRanges;
    }

    @NotNull
    public final List<Range<FilterHint>> getFilterHintRanges() {
        return this.filterHintRanges;
    }

    @NotNull
    public final List<Range<LogcatMessage>> getMessageRanges() {
        return this.messageRanges;
    }

    @NotNull
    public final TextAccumulator accumulate(@NotNull String text2, @Nullable TextAttributes textAttributes, @Nullable TextAttributesKey textAttributesKey, @Nullable FilterHint filterHint) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean bl2 = bl = textAttributes == null || textAttributesKey == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TextAccumulator$accumulate$22 = false;
            String $i$a$-assert-TextAccumulator$accumulate$22 = "Only one of textAttributesKey and textAttributesKeyKey can be set";
            throw new AssertionError((Object)$i$a$-assert-TextAccumulator$accumulate$22);
        }
        int start2 = this.stringBuilder.length();
        int end = start2 + text2.length();
        this.stringBuilder.append(text2);
        if (textAttributes != null) {
            this.textAttributesRanges.add(new Range<TextAttributes>(start2, end, textAttributes));
        } else if (textAttributesKey != null) {
            this.textAttributesKeyRanges.add(new Range<TextAttributesKey>(start2, end, textAttributesKey));
        }
        if (filterHint != null) {
            this.filterHintRanges.add(new Range<FilterHint>(start2, start2 + filterHint.getLength(), filterHint));
        }
        return this;
    }

    public static /* synthetic */ TextAccumulator accumulate$default(TextAccumulator textAccumulator, String string, TextAttributes textAttributes, TextAttributesKey textAttributesKey, FilterHint filterHint, int n, Object object) {
        if ((n & 2) != 0) {
            textAttributes = null;
        }
        if ((n & 4) != 0) {
            textAttributesKey = null;
        }
        if ((n & 8) != 0) {
            filterHint = null;
        }
        return textAccumulator.accumulate(string, textAttributes, textAttributesKey, filterHint);
    }

    public final int getTextLength() {
        return this.stringBuilder.length();
    }

    public final void addMessageRange(int start2, int end, @NotNull LogcatMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageRanges.add(new Range<LogcatMessage>(start2, end, message2));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator$Range;", "T", "", "start", "", "end", "data", "(IILjava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getEnd", "()I", "getStart", "component1", "component2", "component3", "copy", "(IILjava/lang/Object;)Lcom/android/tools/idea/logcat/messages/TextAccumulator$Range;", "equals", "", "other", "hashCode", "toString", "", "intellij.android.logcat"})
    public static final class Range<T> {
        private final int start;
        private final int end;
        private final T data;

        public Range(int start2, int end, T data2) {
            this.start = start2;
            this.end = end;
            this.data = data2;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final T getData() {
            return this.data;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        public final T component3() {
            return this.data;
        }

        @NotNull
        public final Range<T> copy(int start2, int end, T data2) {
            return new Range<T>(start2, end, data2);
        }

        public static /* synthetic */ Range copy$default(Range range, int n, int n2, Object object, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                n = range.start;
            }
            if ((n3 & 2) != 0) {
                n2 = range.end;
            }
            if ((n3 & 4) != 0) {
                object = range.data;
            }
            return range.copy(n, n2, object);
        }

        @NotNull
        public String toString() {
            return "Range(start=" + this.start + ", end=" + this.end + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            result2 = result2 * 31 + (this.data == null ? 0 : this.data.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual(this.data, range.data);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\bH&J\u0006\u0010\f\u001a\u00020\rR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint;", "", "()V", "length", "", "getLength", "()I", "text", "", "getText", "()Ljava/lang/String;", "getFilter", "isElided", "", "AppName", "Level", "Tag", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint$AppName;", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint$Level;", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint$Tag;", "intellij.android.logcat"})
    public static abstract class FilterHint {
        private FilterHint() {
        }

        @NotNull
        public abstract String getText();

        public abstract int getLength();

        public final boolean isElided() {
            return this.getText().length() > this.getLength();
        }

        @NotNull
        public abstract String getFilter();

        public /* synthetic */ FilterHint(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint$Tag;", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint;", "text", "", "length", "", "(Ljava/lang/String;I)V", "getLength", "()I", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "getFilter", "hashCode", "toString", "intellij.android.logcat"})
        public static final class Tag
        extends FilterHint {
            @NotNull
            private final String text;
            private final int length;

            public Tag(@NotNull String text2, int length) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(null);
                this.text = text2;
                this.length = length;
            }

            @Override
            @NotNull
            public String getText() {
                return this.text;
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            @NotNull
            public String getFilter() {
                return "tag:" + this.getText();
            }

            @NotNull
            public final String component1() {
                return this.getText();
            }

            public final int component2() {
                return this.getLength();
            }

            @NotNull
            public final Tag copy(@NotNull String text2, int length) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new Tag(text2, length);
            }

            public static /* synthetic */ Tag copy$default(Tag tag, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = tag.getText();
                }
                if ((n2 & 2) != 0) {
                    n = tag.getLength();
                }
                return tag.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "Tag(text=" + this.getText() + ", length=" + this.getLength() + ")";
            }

            public int hashCode() {
                int result2 = this.getText().hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.getLength());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Tag)) {
                    return false;
                }
                Tag tag = (Tag)other;
                if (!Intrinsics.areEqual((Object)this.getText(), (Object)tag.getText())) {
                    return false;
                }
                return this.getLength() == tag.getLength();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint$AppName;", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint;", "text", "", "length", "", "(Ljava/lang/String;I)V", "getLength", "()I", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "getFilter", "hashCode", "toString", "intellij.android.logcat"})
        public static final class AppName
        extends FilterHint {
            @NotNull
            private final String text;
            private final int length;

            public AppName(@NotNull String text2, int length) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(null);
                this.text = text2;
                this.length = length;
            }

            @Override
            @NotNull
            public String getText() {
                return this.text;
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            @NotNull
            public String getFilter() {
                return "package:" + this.getText();
            }

            @NotNull
            public final String component1() {
                return this.getText();
            }

            public final int component2() {
                return this.getLength();
            }

            @NotNull
            public final AppName copy(@NotNull String text2, int length) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new AppName(text2, length);
            }

            public static /* synthetic */ AppName copy$default(AppName appName, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = appName.getText();
                }
                if ((n2 & 2) != 0) {
                    n = appName.getLength();
                }
                return appName.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "AppName(text=" + this.getText() + ", length=" + this.getLength() + ")";
            }

            public int hashCode() {
                int result2 = this.getText().hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.getLength());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AppName)) {
                    return false;
                }
                AppName appName = (AppName)other;
                if (!Intrinsics.areEqual((Object)this.getText(), (Object)appName.getText())) {
                    return false;
                }
                return this.getLength() == appName.getLength();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\b\u0010\u0015\u001a\u00020\fH\u0016J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint$Level;", "Lcom/android/tools/idea/logcat/messages/TextAccumulator$FilterHint;", "level", "Lcom/android/tools/idea/logcat/message/LogLevel;", "(Lcom/android/tools/idea/logcat/message/LogLevel;)V", "length", "", "getLength", "()I", "getLevel", "()Lcom/android/tools/idea/logcat/message/LogLevel;", "text", "", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "getFilter", "hashCode", "toString", "intellij.android.logcat"})
        public static final class Level
        extends FilterHint {
            @NotNull
            private final LogLevel level;
            @NotNull
            private final String text;
            private final int length;

            public Level(@NotNull LogLevel level) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                super(null);
                this.level = level;
                this.text = " " + this.level.getPriorityLetter() + " ";
                this.length = 3;
            }

            @NotNull
            public final LogLevel getLevel() {
                return this.level;
            }

            @Override
            @NotNull
            public String getText() {
                return this.text;
            }

            @Override
            public int getLength() {
                return this.length;
            }

            @Override
            @NotNull
            public String getFilter() {
                return "level:" + this.level.name();
            }

            @NotNull
            public final LogLevel component1() {
                return this.level;
            }

            @NotNull
            public final Level copy(@NotNull LogLevel level) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                return new Level(level);
            }

            public static /* synthetic */ Level copy$default(Level level, LogLevel logLevel, int n, Object object) {
                if ((n & 1) != 0) {
                    logLevel = level.level;
                }
                return level.copy(logLevel);
            }

            @NotNull
            public String toString() {
                return "Level(level=" + this.level + ")";
            }

            public int hashCode() {
                return this.level.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Level)) {
                    return false;
                }
                Level level = (Level)other;
                return this.level == level.level;
            }
        }
    }
}

