/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.FormattingOptions;
import com.android.tools.idea.logcat.messages.LogcatColors;
import com.android.tools.idea.logcat.messages.MessageFormatterKt;
import com.android.tools.idea.logcat.messages.TextAccumulator;
import java.time.ZoneId;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/logcat/messages/MessageFormatter;", "", "logcatColors", "Lcom/android/tools/idea/logcat/messages/LogcatColors;", "zoneId", "Ljava/time/ZoneId;", "(Lcom/android/tools/idea/logcat/messages/LogcatColors;Ljava/time/ZoneId;)V", "previousPid", "", "Ljava/lang/Integer;", "previousTag", "", "formatMessages", "", "formattingOptions", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "textAccumulator", "Lcom/android/tools/idea/logcat/messages/TextAccumulator;", "messages", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "intellij.android.logcat"})
public final class MessageFormatter {
    @NotNull
    private final LogcatColors logcatColors;
    @NotNull
    private final ZoneId zoneId;
    @Nullable
    private String previousTag;
    @Nullable
    private Integer previousPid;

    public MessageFormatter(@NotNull LogcatColors logcatColors, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)logcatColors, (String)"logcatColors");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.logcatColors = logcatColors;
        this.zoneId = zoneId;
    }

    public final void formatMessages(@NotNull FormattingOptions formattingOptions, @NotNull TextAccumulator textAccumulator, @NotNull List<LogcatMessage> messages) {
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
        Intrinsics.checkNotNullParameter((Object)textAccumulator, (String)"textAccumulator");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        String newline = StringsKt.padEnd$default((String)"\n", (int)(formattingOptions.getHeaderWidth() + 1), (char)'\u0000', (int)2, null);
        for (LogcatMessage message2 : messages) {
            if (message2.getHeader() == ConstantsKt.SYSTEM_HEADER) {
                TextAccumulator.accumulate$default(textAccumulator, message2.getMessage() + "\n", null, null, null, 14, null);
                continue;
            }
            int start2 = textAccumulator.getTextLength();
            LogcatHeader header = message2.getHeader();
            String tag = header.getTag();
            String appName = header.getAppName();
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getTimestampFormat().format(header.getTimestamp(), this.zoneId), null, null, null, 14, null);
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getProcessThreadFormat().format(header.getPid(), header.getTid()), null, null, null, 14, null);
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getTagFormat().format(tag, this.previousTag), this.logcatColors.getTagColor$intellij_android_logcat(tag), null, MessageFormatterKt.access$getTagFilterHint(tag, formattingOptions), 4, null);
            TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getAppNameFormat().format(appName, header.getPid(), this.previousPid), null, null, MessageFormatterKt.access$getAppNameFilterHint(appName, formattingOptions), 6, null);
            formattingOptions.getLevelFormat().format(header.getLogLevel(), textAccumulator, this.logcatColors);
            TextAccumulator.accumulate$default(textAccumulator, StringsKt.replace$default((String)message2.getMessage(), (String)"\n", (String)newline, (boolean)false, (int)4, null) + "\n", null, this.logcatColors.getMessageKey$intellij_android_logcat(header.getLogLevel()), null, 10, null);
            int end = textAccumulator.getTextLength();
            textAccumulator.addMessageRange(start2, end - 1, message2);
            this.previousTag = tag;
            this.previousPid = header.getPid();
        }
    }
}

